/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.versioning;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.web.tomcat6.versioning.AbsVirtualContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualContext
extends AbsVirtualContext {
    private static Log logger = LogFactory.getLog(VirtualContext.class);
    private List<Context> reservedContexts = new ArrayList<Context>();
    private List<Context> disabledContexts = new ArrayList<Context>();
    private List<Context> privateContexts = new ArrayList<Context>();

    public VirtualContext(JmxService jmxService, String userURI, Context contextInstance) {
        super(jmxService, userURI, contextInstance);
    }

    @Override
    protected void addContextInternal(Context contextInstance, String policy) throws IllegalArgumentException {
        if ("Disabled".equals(policy)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Addind disabled context " + contextInstance.getPath() + " for userURI " + this.userURI));
            }
            this.disabledContexts.add(contextInstance);
        } else if ("Private".equals(policy)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Addind private context " + contextInstance.getPath() + " for userURI " + this.userURI));
            }
            this.privateContexts.add(contextInstance);
        } else if ("Reserved".equals(policy)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Addind reserved context " + contextInstance.getPath() + " for userURI " + this.userURI));
            }
            this.reservedContexts.add(contextInstance);
        } else {
            throw new IllegalArgumentException("Invalid policy: " + policy);
        }
    }

    public Map<String, String> getContexts() {
        HashMap<String, String> result;
        int mapSize = this.disabledContexts.size() + this.reservedContexts.size() + this.privateContexts.size();
        if (this.defaultContext != null) {
            result = new HashMap(1 + mapSize);
            result.put(this.defaultContext.getPath(), "Default");
        } else {
            result = new HashMap<String, String>(mapSize);
        }
        for (Context context : this.disabledContexts) {
            result.put(context.getPath(), "Disabled");
        }
        for (Context context : this.reservedContexts) {
            result.put(context.getPath(), "Reserved");
        }
        for (Context context : this.privateContexts) {
            result.put(context.getPath(), "Private");
        }
        return result;
    }

    protected String findPrivateContext(Request req) {
        return null;
    }

    protected String findDisabledContext(Request req) {
        Cookie[] cookies;
        ArrayList<String> sessions = new ArrayList<String>();
        String requestSessionid = req.getRequestedSessionId();
        if (requestSessionid != null) {
            sessions.add(requestSessionid);
        }
        if ((cookies = req.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!Globals.SESSION_COOKIE_NAME.equals(cookie.getName())) continue;
                sessions.add(cookie.getValue().toString());
            }
        }
        if (sessions.size() == 0) {
            logger.debug((Object)"No session found");
            return null;
        }
        for (Context context : this.disabledContexts) {
            for (String sessionid : sessions) {
                try {
                    Session session = context.getManager().findSession(sessionid);
                    if (session == null || !session.isValid()) continue;
                    logger.debug((Object)("Found session " + session + " for context " + context.getPath()));
                    return context.getPath();
                }
                catch (IOException e) {
                    logger.error((Object)"Cannot read session", (Throwable)e);
                }
            }
        }
        logger.debug((Object)"None of the user's sessions belong to the disabled contexts");
        return null;
    }

    public boolean rebindContext(String versionedPath, String policy) {
        Context contextInstance;
        if (this.defaultContext != null && versionedPath.equals(this.defaultContext.getPath())) {
            contextInstance = this.defaultContext;
            this.defaultContext = null;
        } else {
            contextInstance = this.findDeleteContextObject(versionedPath, true);
        }
        if (contextInstance == null) {
            return false;
        }
        this.addContext(contextInstance, policy);
        return true;
    }

    @Override
    protected Context findContextObject(String versionedPath) {
        Context result = super.findContextObject(versionedPath);
        if (result == null) {
            result = this.findDeleteContextObject(versionedPath, false);
        }
        return result;
    }

    protected Context findDeleteContextObject(String versionedPath, boolean delete) {
        if (this.disabledContexts != null) {
            for (Context context : this.disabledContexts) {
                if (!versionedPath.equals(context.getPath())) continue;
                if (delete) {
                    this.disabledContexts.remove(context);
                }
                return context;
            }
        }
        if (this.reservedContexts != null) {
            for (Context context : this.reservedContexts) {
                if (!versionedPath.equals(context.getPath())) continue;
                if (delete) {
                    this.reservedContexts.remove(context);
                }
                return context;
            }
        }
        if (this.privateContexts != null) {
            for (Context context : this.privateContexts) {
                if (!versionedPath.equals(context.getPath())) continue;
                if (delete) {
                    this.privateContexts.remove(context);
                }
                return context;
            }
        }
        return null;
    }

    @Override
    public boolean removeContext(String versionedPath) {
        boolean result = super.removeContext(versionedPath);
        if (!result) {
            boolean bl = result = null != this.findDeleteContextObject(versionedPath, true);
        }
        if (this.defaultContext == null && this.privateContexts.isEmpty() && this.reservedContexts.isEmpty() && this.disabledContexts.isEmpty()) {
            this.removeVirtualContext();
        }
        return result;
    }

    @Override
    public boolean hasContext(String versionedPath) {
        boolean result = super.hasContext(versionedPath);
        if (!result) {
            result = null != this.findDeleteContextObject(versionedPath, false);
        }
        return result;
    }

    public String findContext(Request req) {
        String contextURI = this.findPrivateContext(req);
        logger.debug((Object)("findPrivateContext returned : " + contextURI));
        if (contextURI == null) {
            contextURI = this.findDisabledContext(req);
            logger.debug((Object)("findDisabledContext returned : " + contextURI));
        }
        if (contextURI == null) {
            if (this.defaultContext == null) {
                logger.debug((Object)"No context found, default also null. Returning null.");
            } else {
                contextURI = this.defaultContext.getPath();
                logger.debug((Object)("No context found, returning default : " + contextURI));
            }
        }
        return contextURI;
    }
}

