/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.ow2.jonas.audit.internal.logger.AuditLogServiceException;
import org.ow2.jonas.audit.internal.logger.PatternEntry;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

class AuditLogJMXWaiter
implements Runnable {
    private static final long SLEEP_TIME = 2000L;
    private Log logger = LogFactory.getLog(AuditLogJMXWaiter.class);
    private boolean wait = true;
    private List<PatternEntry> patternEntries = null;
    private MBeanServer jmxServer = null;

    public AuditLogJMXWaiter(MBeanServer jmxServer) {
        this.jmxServer = jmxServer;
        this.patternEntries = new ArrayList<PatternEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPatternEntry(PatternEntry patternEntry) {
        List<PatternEntry> list = this.patternEntries;
        synchronized (list) {
            this.patternEntries.add(patternEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.wait) {
            List<PatternEntry> list = this.patternEntries;
            synchronized (list) {
                Iterator<PatternEntry> itPatternEntry = this.patternEntries.iterator();
                while (itPatternEntry.hasNext()) {
                    PatternEntry patternEntry = itPatternEntry.next();
                    Set<ObjectName> objectNames = this.jmxServer.queryNames(patternEntry.getObjectNamePattern(), null);
                    if (objectNames.size() <= 0) continue;
                    ObjectName objectName = objectNames.iterator().next();
                    itPatternEntry.remove();
                    try {
                        patternEntry.getListener().register(objectName);
                        this.logger.info((Object)"Add Notifications from ''{0}''", new Object[]{objectName});
                    }
                    catch (AuditLogServiceException e) {
                        this.logger.error((Object)"Unable to register the listener with objectName ''{0}''.", new Object[]{objectName});
                    }
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.debug((Object)"Unable to wait", new Object[]{e});
            }
        }
    }

    public void end() {
        this.wait = false;
    }
}

