/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.webauditor.report;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.util.auditreport.impl.CurrentInvocationID;
import org.ow2.util.auditreport.impl.WebInvocationAuditReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WebInvocationAuditReportFactory {
    private static final int START_LEVEL = -1;
    private static Log logger = LogFactory.getLog(WebInvocationAuditReportFactory.class);
    private boolean creatingReports = true;
    private MBeanServer jmxServer = null;

    public WebInvocationAuditReportFactory(MBeanServer jmxServer) {
        this.jmxServer = jmxServer;
    }

    public WebInvocationAuditReport prepareAuditReport(long invocationNumber, long timestamp, long start, Thread current, String role, HttpServletRequest req) {
        if (!this.creatingReports) {
            return null;
        }
        int freeMemoryBefore = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryBefore = (int)Runtime.getRuntime().totalMemory();
        try {
            String[] rolesArray;
            String prefix = "/webcontainer/root";
            String post = "";
            if (req.getRequestURI().equals("/") && req.getContextPath().equals("")) {
                post = post + "root";
            }
            WebInvocationAuditReport reporttmp = new WebInvocationAuditReport(req);
            reporttmp.setKeyID(CurrentInvocationID.getInstance().getAuditID().getID());
            reporttmp.setFreeMemoryBefore(freeMemoryBefore);
            int paramSize = req.getParameterMap().values().size();
            Object[] params = new String[paramSize];
            int i = 0;
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = req.getParameter(name);
                params[i] = name + ":" + value;
                ++i;
            }
            reporttmp.setMethodParameters(params);
            reporttmp.setMethodStackTrace((Object[])current.getStackTrace());
            reporttmp.setRequestStart(start);
            reporttmp.setRequestTimeStamp(timestamp);
            SecurityContext securityContext = SecurityCurrent.getCurrent().getSecurityContext();
            String roles = "";
            String username = "";
            if (securityContext == null) {
                securityContext = new SecurityContext();
            }
            if ((rolesArray = securityContext.getRoles()) != null) {
                roles = Arrays.asList(rolesArray).toString();
            }
            username = securityContext.getPrincipalName();
            reporttmp.setRoles(roles);
            reporttmp.setUser(username);
            reporttmp.setTarget(prefix + req.getRequestURI() + post);
            String packagePath = this.getPackagePath(req.getContextPath());
            if (packagePath.charAt(0) == '/') {
                reporttmp.setTarget(reporttmp.getTarget().replace("/webcontainer/", "/webcontainer" + packagePath));
            } else {
                reporttmp.setTarget(reporttmp.getTarget().replace("/webcontainer/", "/webcontainer/" + packagePath));
            }
            reporttmp.setTotalMemoryBefore(totalMemoryBefore);
            return reporttmp;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to  prepare the audit report", new Object[]{ex});
            return null;
        }
    }

    public String getPackagePath(String servletMapping) {
        String[] warPath = new String[]{};
        String war = "";
        String[] earPath = new String[]{};
        String ear = "";
        Set<Object> objs = new HashSet();
        try {
            objs = this.jmxServer.queryMBeans(new ObjectName(":j2eeType=WebModule,name=//localhost" + servletMapping + ",*"), null);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)("Unable to get package from servlet mapping " + servletMapping), new Object[]{e});
        }
        catch (NullPointerException e) {
            logger.error((Object)("Unable to get package from servlet mapping " + servletMapping), new Object[]{e});
        }
        for (ObjectInstance objectInstance : objs) {
            try {
                if (this.jmxServer.getAttribute(objectInstance.getObjectName(), "warURL") != null) {
                    warPath = ((URL)this.jmxServer.getAttribute(objectInstance.getObjectName(), "warURL")).toString().split("/");
                    war = warPath[warPath.length - 1];
                } else {
                    war = "";
                }
                if (this.jmxServer.getAttribute(objectInstance.getObjectName(), "earURL") != null) {
                    earPath = ((URL)this.jmxServer.getAttribute(objectInstance.getObjectName(), "earURL")).toString().split("/");
                    ear = earPath[earPath.length - 1];
                    ear = ear.substring(0, ear.lastIndexOf("_")) + ".ear";
                    continue;
                }
                ear = "";
            }
            catch (Exception e) {
                logger.error((Object)("Unable to get package from servlet mapping " + servletMapping), new Object[]{e});
            }
        }
        return ear + "/" + war + "/";
    }

    public void completeAuditReport(WebInvocationAuditReport report, long stop, Object returnedObject) {
        if (!this.creatingReports) {
            return;
        }
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) < 0L) continue;
            garbageCollectionTime += time;
        }
        int freeMemoryAfter = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryAfter = (int)Runtime.getRuntime().totalMemory();
        report.setFreeMemoryAfter(freeMemoryAfter);
        report.setTotalMemoryAfter(totalMemoryAfter);
        report.setMethodReturn(returnedObject);
        report.setRequestStop(stop);
        report.setSweepMarkTime(totalGarbageCollections);
        report.setScavengeTime(garbageCollectionTime);
    }

    public void setCreatingReports(boolean creatingReportsParam) {
        this.creatingReports = creatingReportsParam;
    }
}

