/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Host;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class ExpandWar {
    private static final Log log = LogFactory.getLog(ExpandWar.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static String expand(Host host, URL war, String pathname) throws IOException {
        File appBase = new File(host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!appBase.exists() || !appBase.isDirectory()) {
            throw new IOException(sm.getString("hostConfig.appBase", appBase.getAbsolutePath()));
        }
        File docBase = new File(appBase, pathname);
        if (docBase.exists()) {
            return docBase.getAbsolutePath();
        }
        docBase.mkdir();
        String canonicalDocBasePrefix = docBase.getCanonicalPath();
        if (!canonicalDocBasePrefix.endsWith(File.separator)) {
            canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input = null;
        boolean success = false;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File expandedFile = new File(docBase, name);
                if (!expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) {
                    throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name));
                }
                int last = name.lastIndexOf(47);
                if (last >= 0) {
                    File parent = new File(docBase, name.substring(0, last));
                    parent.mkdirs();
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                ExpandWar.expand(input, expandedFile);
                long lastModified = jarEntry.getTime();
                if (lastModified != -1L && lastModified != 0L) {
                    expandedFile.setLastModified(lastModified);
                }
                input.close();
                input = null;
            }
            success = true;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (!success) {
                ExpandWar.deleteDir(docBase);
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                input = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                jarFile = null;
            }
        }
        return docBase.getAbsolutePath();
    }

    public static void validate(Host host, URL war, String pathname) throws IOException {
        File docBase;
        String canonicalDocBasePrefix;
        File appBase = new File(host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        if (!(canonicalDocBasePrefix = (docBase = new File(appBase, pathname)).getCanonicalPath()).endsWith(File.separator)) {
            canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File expandedFile = new File(docBase, name);
                if (expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) continue;
                throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name));
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                jarFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ExpandWar.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e) {
                log.error(sm.getString("expandWar.copy", fileSrc, fileDest), e);
                result = false;
                continue;
            }
            finally {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException e) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        return ExpandWar.delete(dir, true);
    }

    public static boolean delete(File dir, boolean logFailure) {
        boolean result = dir.isDirectory() ? ExpandWar.deleteDir(dir, logFailure) : (dir.exists() ? dir.delete() : true);
        if (logFailure && !result) {
            log.error(sm.getString("expandWar.deleteFailed", dir.getAbsolutePath()));
        }
        return result;
    }

    public static boolean deleteDir(File dir) {
        return ExpandWar.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean logFailure) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                ExpandWar.deleteDir(file, logFailure);
                continue;
            }
            file.delete();
        }
        boolean result = dir.exists() ? dir.delete() : true;
        if (logFailure && !result) {
            log.error(sm.getString("expandWar.deleteFailed", dir.getAbsolutePath()));
        }
        return result;
    }

    protected static File expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        ExpandWar.expand(input, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(InputStream input, File file) throws IOException {
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

