/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;

public class ContextAccessController {
    private static Hashtable<Object, Object> readOnlyContexts = new Hashtable();
    private static Hashtable<Object, Object> securityTokens = new Hashtable();

    public static void setSecurityToken(Object name, Object token) {
        if (!securityTokens.containsKey(name) && token != null) {
            securityTokens.put(name, token);
        }
    }

    public static void unsetSecurityToken(Object name, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            securityTokens.remove(name);
        }
    }

    public static boolean checkSecurityToken(Object name, Object token) {
        Object refToken = securityTokens.get(name);
        if (refToken == null) {
            return true;
        }
        return refToken != null && refToken.equals(token);
    }

    public static void setWritable(Object name, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            readOnlyContexts.remove(name);
        }
    }

    public static void setReadOnly(Object name) {
        readOnlyContexts.put(name, name);
    }

    public static boolean isWritable(Object name) {
        return !readOnlyContexts.containsKey(name);
    }
}

