/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7;

import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.loader.WebappLoader;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.modeler.Registry;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.web.tomcat7.Tomcat7Service;
import org.ow2.jonas.web.tomcat7.loader.NoSystemAccessWebappClassLoader;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASStandardContext
extends StandardContext {
    private static final long serialVersionUID = 1L;
    private static transient Tomcat7Service catalinaService = null;
    private static Log logger = LogFactory.getLog(JOnASStandardContext.class);
    private URL earURL = null;
    private boolean inEarCase = false;
    private boolean inServerXml = false;
    private boolean java2DelegationModel = false;
    private WebContainerDeploymentDesc webDeploymentDescriptor = null;
    private String jonasDeploymentDescriptor = null;
    private boolean startedJStdx = false;
    private URL warURL = null;
    private String earON = null;
    private Map<String, Map<String, String>> injectionsMap = null;
    private Context envContext = null;

    public JOnASStandardContext() {
        this(true, true, false);
    }

    public JOnASStandardContext(boolean inServerXml, boolean java2DelegationModel, boolean inEarCase) {
        this.inServerXml = inServerXml;
        this.java2DelegationModel = java2DelegationModel;
        this.inEarCase = inEarCase;
    }

    public void setTomcatService(Tomcat7Service tomcat) {
        catalinaService = tomcat;
    }

    public URL getEarURL() {
        return this.earURL;
    }

    public WebContainerDeploymentDesc getWebDeploymentDescriptor() {
        return this.webDeploymentDescriptor;
    }

    public String getJonasDeploymentDescriptor() {
        return this.jonasDeploymentDescriptor;
    }

    public URL getWarURL() {
        return this.warURL;
    }

    public boolean isInEarCase() {
        return this.inEarCase;
    }

    public boolean isInServerXml() {
        return this.inServerXml;
    }

    public boolean isJava2DelegationModel() {
        return this.java2DelegationModel;
    }

    protected void setEarURL(URL earURL) {
        this.earURL = earURL;
        ObjectName j2eeAppOn = null;
        String appName = this.getJ2EEApplication();
        String serverON = this.getServer();
        if (appName != null && serverON != null) {
            try {
                ObjectName serverOn = ObjectName.getInstance(serverON);
                String domainName = serverOn.getDomain();
                String serverName = serverOn.getKeyProperty("name");
                j2eeAppOn = J2eeObjectName.J2EEApplication((String)domainName, (String)serverName, (String)appName);
            }
            catch (MalformedObjectNameException e) {
                logger.error((Object)"Cannot build the ObjectName for the context ''{0}''", new Object[]{e});
            }
        }
        if (j2eeAppOn != null) {
            this.earON = j2eeAppOn.toString();
        }
    }

    protected void setInEarCase(boolean inEarCase) {
        this.inEarCase = inEarCase;
    }

    protected void setJava2DelegationModel(boolean java2DelegationModel) {
        this.java2DelegationModel = java2DelegationModel;
    }

    public void setWebDeploymentDescriptor(WebContainerDeploymentDesc webDeploymentDescriptor) {
        this.webDeploymentDescriptor = webDeploymentDescriptor;
    }

    public void setJonasDeploymentDescriptor(String jonasDeploymentDescriptor) {
        this.jonasDeploymentDescriptor = jonasDeploymentDescriptor;
    }

    protected void setWarURL(URL warURL) {
        this.warURL = warURL;
    }

    @Override
    public synchronized void startInternal() throws LifecycleException {
        if (catalinaService != null && catalinaService.isTomcatStarted()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Tomcat in Web container service is started, starting the context...", new Object[0]);
            }
            this.startedJStdx = true;
            super.startInternal();
        }
    }

    @Override
    public synchronized void stopInternal() throws LifecycleException {
        if (this.startedJStdx) {
            this.startedJStdx = false;
            super.stopInternal();
            this.unregisterJMX();
        }
    }

    private void unregisterJMX() {
        if (this.getObjectName() != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.getObjectName());
        }
    }

    public void addResource(ContextResource resource) {
    }

    public void addEnvironment(ContextEnvironment environment) {
    }

    @Override
    public void addMessageDestinationRef(MessageDestinationRef mdr) {
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        if (!this.startedJStdx) {
            super.setParentClassLoader(parent);
        }
    }

    public String getEarON() {
        return this.earON;
    }

    @Override
    public String getWorkDir() {
        String superWorkDir = super.getWorkDir();
        if (superWorkDir == null) {
            String temp;
            String hostName = null;
            String engineName = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                hostName = parentHost.getName();
                Container parentEngine = parentHost.getParent();
                if (parentEngine != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            superWorkDir = catalinaService.getServerProperties().getWorkDirectory() + File.separator + "tomcat" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            new File(superWorkDir).mkdirs();
            super.setWorkDir(superWorkDir);
        }
        return superWorkDir;
    }

    @Override
    public void setLoader(Loader loader) {
        if (loader instanceof WebappLoader) {
            ((WebappLoader)loader).setLoaderClass(NoSystemAccessWebappClassLoader.class.getName());
        }
        super.setLoader(loader);
    }

    @Override
    public boolean listenerStart() {
        this.setInstanceManager(new DefaultInstanceManager(this.envContext, this.injectionsMap, this, this.getClass().getClassLoader()));
        this.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)this.getInstanceManager());
        return super.listenerStart();
    }

    public void setEnvContext(Context envContext) {
        this.envContext = envContext;
    }

    public void setInjectionMap(Map<String, Map<String, String>> injectionsMap) {
        this.injectionsMap = injectionsMap;
    }
}

