/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors.changetracking;

import java.beans.PropertyChangeEvent;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;

public class AttributeChangeListener
extends ObjectChangeListener {
    protected transient ClassDescriptor descriptor;
    protected transient UnitOfWorkImpl uow;
    protected ObjectChangeSet objectChangeSet;
    protected Object owner;

    public AttributeChangeListener(ClassDescriptor descriptor, UnitOfWorkImpl uow, Object owner) {
        this.descriptor = descriptor;
        this.uow = uow;
        this.owner = owner;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public void setObjectChangeSet(ObjectChangeSet changeSet) {
        this.objectChangeSet = changeSet;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public UnitOfWorkImpl getUnitOfWork() {
        return this.uow;
    }

    public void setUnitOfWork(UnitOfWorkImpl uow) {
        this.uow = uow;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.ignoreEvents) {
            return;
        }
        this.internalPropertyChange(evt);
    }

    public void internalPropertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() == evt.getOldValue()) {
            return;
        }
        DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForAttributeName(evt.getPropertyName());
        if (mapping == null) {
            throw ValidationException.wrongPropertyNameInChangeEvent(this.owner.getClass(), evt.getPropertyName());
        }
        if ((mapping instanceof AbstractDirectMapping || mapping instanceof AbstractTransformationMapping) && (evt.getNewValue() == null && evt.getOldValue() == null || evt.getNewValue() != null && evt.getNewValue().equals(evt.getOldValue()))) {
            return;
        }
        super.internalPropertyChange(evt);
        if (this.uow.getUnitOfWorkChangeSet() == null) {
            this.uow.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet(this.uow));
        }
        if (this.objectChangeSet == null) {
            this.uow.addToChangeTrackedHardList(this.owner);
            this.objectChangeSet = this.getDescriptor().getObjectBuilder().createObjectChangeSet(this.owner, (UnitOfWorkChangeSet)this.uow.getUnitOfWorkChangeSet(), false, this.uow);
        }
        if (evt.getClass().equals(ClassConstants.PropertyChangeEvent_Class)) {
            mapping.updateChangeRecord(evt.getSource(), evt.getNewValue(), evt.getOldValue(), this.objectChangeSet, this.getUnitOfWork());
        } else if (evt.getClass().equals(ClassConstants.CollectionChangeEvent_Class) || evt.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
            mapping.updateCollectionChangeRecord((CollectionChangeEvent)evt, this.objectChangeSet, this.getUnitOfWork());
        } else {
            throw ValidationException.wrongChangeEvent(evt.getClass());
        }
    }

    public void clearChanges() {
        super.clearChanges();
        this.objectChangeSet = null;
    }
}

