/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.jpa.deployment.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileArchive
implements Archive {
    private final JarFile jarFile;
    private final URL rootURL;
    private final Logger logger;
    private static final String WAR_SUFFIX = ".war";
    private static final String CLASS_SUFFIX = ".class";
    private static final String WEB_PREFIX = "WEB-INF/classes";
    private static final int WEb_PREFIX_AFTER_INDEX = "WEB-INF/classes".length();

    private boolean isWar() {
        String rootPath = this.rootURL.getPath();
        return rootPath.endsWith(WAR_SUFFIX);
    }

    private String treat(String name) {
        if (name.endsWith(CLASS_SUFFIX) && name.startsWith(WEB_PREFIX)) {
            return name.substring(WEb_PREFIX_AFTER_INDEX + 1);
        }
        return name;
    }

    public JarFileArchive(JarFile jarFile) throws MalformedURLException {
        this(jarFile, Logger.global);
    }

    public JarFileArchive(JarFile jarFile, Logger logger) throws MalformedURLException {
        logger.entering("JarFileArchive", "JarFileArchive", new Object[]{jarFile});
        this.logger = logger;
        this.jarFile = jarFile;
        this.rootURL = new File(jarFile.getName()).toURI().toURL();
        logger.logp(Level.FINER, "JarFileArchive", "JarFileArchive", "rootURL = {0}", this.rootURL);
    }

    @Override
    public Iterator<String> getEntries() {
        Enumeration<JarEntry> jarEntries = this.jarFile.entries();
        ArrayList<String> result = new ArrayList<String>();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory()) continue;
            String entryName = jarEntry.getName();
            if (this.isWar()) {
                entryName = this.treat(entryName);
            }
            result.add(entryName);
        }
        return result.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        InputStream is = null;
        ZipEntry entry = this.jarFile.getEntry(entryPath);
        if (entry != null) {
            is = this.jarFile.getInputStream(entry);
        }
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        return this.jarFile.getEntry(entryPath) != null ? new URL("jar:" + this.rootURL + "!/" + entryPath) : null;
    }

    @Override
    public URL getRootURL() {
        return this.rootURL;
    }
}

