/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableMetadata
extends TableMetadata {
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private List<JoinColumnMetadata> m_inverseJoinColumns = new ArrayList<JoinColumnMetadata>();

    public JoinTableMetadata() {
        super("<join-table>");
    }

    public JoinTableMetadata(Annotation joinTable, MetadataAccessibleObject accessibleObject) {
        super(joinTable, accessibleObject);
        if (joinTable != null) {
            for (Annotation joinColumn : (Annotation[])MetadataHelper.invokeMethod("joinColumns", joinTable)) {
                this.m_joinColumns.add(new JoinColumnMetadata(joinColumn, accessibleObject));
            }
            for (Annotation inverseJoinColumn : (Annotation[])MetadataHelper.invokeMethod("inverseJoinColumns", joinTable)) {
                this.m_inverseJoinColumns.add(new JoinColumnMetadata(inverseJoinColumn, accessibleObject));
            }
        }
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_join_table_catalog";
    }

    public List<JoinColumnMetadata> getInverseJoinColumns() {
        return this.m_inverseJoinColumns;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    @Override
    public String getNameContext() {
        return "metadata_default_join_table_name";
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_join_table_schema";
    }

    public void setInverseJoinColumns(List<JoinColumnMetadata> inverseJoinColumns) {
        this.m_inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }
}

