/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxrpc.mbean;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class WebServicesObjectName {
    public static final String WEBSERVICE_TYPE = "WebService";
    public static final String PORTCOMPONENT_TYPE = "WebServicePortComponent";
    public static final String HANDLER_TYPE = "WebServiceHandler";
    public static final String EJBMODULE = "EJBModule";
    public static final String WEBMODULE = "WebModule";
    public static final String J2EEAPPLICATION = "J2EEApplication";
    public static final String J2EESERVER = "J2EEServer";
    private static String domain = null;

    private WebServicesObjectName() {
    }

    private static String getDomain() {
        return domain;
    }

    public static void setDomain(String myDomain) {
        domain = myDomain;
    }

    private static String getInheritedPropertiesAsString(ObjectName name) {
        Hashtable table = (Hashtable)name.getKeyPropertyList().clone();
        table.remove("j2eeType");
        table.remove("type");
        table.remove("subtype");
        table.remove("name");
        StringBuffer sb = new StringBuffer();
        for (String key : table.keySet()) {
            sb.append(key + "=" + table.get(key) + ",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static ObjectName service(String name, ObjectName parent) throws MalformedObjectNameException {
        String parentModule = "";
        parentModule = parent.getKeyProperty("j2eeType").equals(EJBMODULE) ? "EJBModule=" + parent.getKeyProperty("name") : "WebModule=" + parent.getKeyProperty("name");
        return ObjectName.getInstance(WebServicesObjectName.getDomain() + ":type=WebService,name=" + name + "," + parentModule + "," + WebServicesObjectName.getInheritedPropertiesAsString(parent));
    }

    public static ObjectName portComponent(String name, ObjectName parent) throws MalformedObjectNameException {
        String parentModule = "";
        if (parent.getKeyProperty("type").equals(WEBSERVICE_TYPE)) {
            parentModule = "WebService=" + parent.getKeyProperty("name");
        }
        return ObjectName.getInstance(WebServicesObjectName.getDomain() + ":type=" + PORTCOMPONENT_TYPE + ",name=" + name + "," + parentModule + "," + WebServicesObjectName.getInheritedPropertiesAsString(parent));
    }

    public static ObjectName handler(String name, ObjectName parent) throws MalformedObjectNameException {
        String parentModule = "";
        if (parent.getKeyProperty("type").equals(PORTCOMPONENT_TYPE)) {
            parentModule = "WebServicePortComponent=" + parent.getKeyProperty("name");
        }
        return ObjectName.getInstance(WebServicesObjectName.getDomain() + ":type=" + HANDLER_TYPE + ",name=" + name + "," + parentModule + "," + WebServicesObjectName.getInheritedPropertiesAsString(parent));
    }

    public static ObjectName getStatelessSessionBeanQuery(ObjectName parent, String ejbName) {
        try {
            StringBuffer sb = new StringBuffer(parent.getDomain());
            sb.append(":j2eeType=StatelessSessionBean");
            sb.append(",name=");
            sb.append(ejbName);
            sb.append(",J2EEApplication=");
            if (parent.getKeyProperty(J2EEAPPLICATION) != null) {
                sb.append(parent.getKeyProperty(J2EEAPPLICATION));
            } else {
                sb.append(parent.getKeyProperty("name"));
            }
            sb.append(",J2EEServer=");
            sb.append(parent.getKeyProperty(J2EESERVER));
            sb.append(",*");
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName getServletQuery(ObjectName parent, String servletName) {
        try {
            StringBuffer sb = new StringBuffer(parent.getDomain());
            sb.append(":j2eeType=Servlet");
            sb.append(",name=");
            sb.append(servletName);
            sb.append(",J2EEApplication=");
            if (parent.getKeyProperty(J2EEAPPLICATION) != null) {
                sb.append(parent.getKeyProperty(J2EEAPPLICATION));
            } else {
                sb.append(parent.getKeyProperty("name"));
            }
            sb.append(",J2EEServer=");
            sb.append(parent.getKeyProperty(J2EESERVER));
            sb.append(",*");
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName getEJBModule(ObjectName ear, String key) {
        try {
            StringBuffer sb = new StringBuffer(ear.getDomain());
            sb.append(":j2eeType=EJBModule");
            sb.append(",name=");
            sb.append(key);
            sb.append(",J2EEApplication=");
            sb.append(ear.getKeyProperty("name"));
            sb.append(",J2EEServer=");
            sb.append(ear.getKeyProperty(J2EESERVER));
            sb.append(",*");
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public static ObjectName getWebModule(ObjectName ear, String key) {
        try {
            StringBuffer sb = new StringBuffer(ear.getDomain());
            sb.append(":j2eeType=WebModule");
            sb.append(",name=");
            sb.append(key);
            sb.append(",J2EEApplication=");
            sb.append(ear.getKeyProperty("name"));
            sb.append(",J2EEServer=");
            sb.append(ear.getKeyProperty(J2EESERVER));
            sb.append(",*");
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }
}

