/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentIdStamp;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.StringId;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class AgentId
implements Serializable {
    static final long serialVersionUID = 1L;
    transient short from;
    transient short to;
    transient int stamp;
    transient String str = null;
    public static final int NullIdStamp = 0;
    public static final int FactoryIdStamp = 1;
    public static final int MaxSystemIdStamp = 2;
    public static int MinWKSIdStamp = 3;
    public static int NameServiceStamp = 4;
    public static int SchedulerServiceStamp = 5;
    public static int FileTransfertStamp = 6;
    public static int JndiServiceStamp = 7;
    public static int LocalJndiServiceStamp = 8;
    public static int SCAdminProxyStamp = 9;
    public static int JoramAdminStamp = 10;
    public static int JoramAdminPxStamp = 11;
    public static int ControlTopicStamp = 12;
    public static int ServerConfigStamp = 13;
    public static int ResourceAgentStamp = 14;
    public static int AMQPAgentStamp = 15;
    public static int MaxWKSIdStamp;
    public static int MaxIdStamp;
    public static final AgentId nullId;
    static AgentId localId;
    static AgentId factoryId;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(this.from);
        out.writeShort(this.to);
        out.writeInt(this.stamp);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.from = in.readShort();
        this.to = in.readShort();
        this.stamp = in.readInt();
    }

    public static final AgentId factoryId(short sid) {
        return new AgentId(sid, sid, 1);
    }

    public static final AgentId localId(short sid) {
        return new AgentId(sid, sid, 0);
    }

    static void init() throws IOException, ClassNotFoundException {
        localId = new AgentId(AgentServer.getServerId(), AgentServer.getServerId(), 0);
        factoryId = new AgentId(AgentServer.getServerId(), AgentServer.getServerId(), 1);
        AgentIdStamp.init();
    }

    AgentId() throws IOException {
        this(AgentServer.getServerId());
    }

    AgentId(short to) throws IOException {
        this(AgentServer.getServerId(), to, AgentIdStamp.stamp.newStamp(to));
    }

    public AgentId(short from, short to, int stamp) {
        this.from = from;
        this.to = to;
        this.stamp = stamp;
    }

    public final short getFrom() {
        return this.from;
    }

    public final short getTo() {
        return this.to;
    }

    public final int getStamp() {
        return this.stamp;
    }

    public static final int parseInt(String str, int idx, int end) throws NumberFormatException {
        int result = 0;
        int limit = 0xCCCCCCC;
        int digitzero = 48;
        while (idx < end) {
            int digit;
            if ((digit = str.charAt(idx++) - digitzero) < 0 || digit > 9) {
                throw new NumberFormatException("bad digit");
            }
            if (result >= limit) {
                throw new NumberFormatException("limit");
            }
            result *= 10;
            result += digit;
        }
        return result;
    }

    public static final AgentId fromString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.charAt(0) != '#') {
            throw new IllegalArgumentException(str + ": bad agent identifier");
        }
        try {
            int start = 1;
            int end = str.indexOf(46, start);
            short from = (short)AgentId.parseInt(str, start, end);
            start = end + 1;
            end = str.indexOf(46, start);
            short to = (short)AgentId.parseInt(str, start, end);
            start = end + 1;
            end = str.length();
            int stamp = AgentId.parseInt(str, start, end);
            return new AgentId(from, to, stamp);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException(str + ": " + exc);
        }
    }

    public final String toString() {
        if (this.str == null) {
            this.str = StringId.toStringId('#', '.', this.from, this.to, this.stamp);
        }
        return this.str;
    }

    public int hashCode() {
        return this.stamp;
    }

    public final boolean isNullId() {
        return this.stamp == 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof AgentId && ((AgentId)obj).from == this.from && ((AgentId)obj).to == this.to && ((AgentId)obj).stamp == this.stamp;
    }

    static {
        MaxIdStamp = MaxWKSIdStamp = 1024;
        nullId = new AgentId(0, 0, 0);
    }
}

