/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class XMLSerializer {
    private static final String DEF_LINE_SEP = "\n";
    private Document doc;
    private LSSerializer serializer;
    private LSOutput output;

    public XMLSerializer(Document doc) {
        DOMImplementationRegistry registry;
        this.doc = doc;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get the system DOMImplementationRegistry", e);
        }
        DOMImplementation impl = registry.getDOMImplementation("LS 3.0");
        DOMImplementationLS factory = (DOMImplementationLS)((Object)impl);
        this.serializer = factory.createLSSerializer();
        this.serializer.setNewLine(DEF_LINE_SEP);
        this.output = factory.createLSOutput();
        this.output.setEncoding("UTF-8");
    }

    public void serialize(OutputStream os) throws IOException {
        this.output.setByteStream(os);
        this.serialize();
    }

    public void serialize(Writer writer) throws IOException {
        this.output.setCharacterStream(writer);
        this.serialize();
    }

    private void serialize() {
        this.serializer.write(this.doc, this.output);
    }
}

