/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.factory;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.JNDIUtils;
import org.ow2.jonas.security.internal.realm.factory.AbstractJResource;
import org.ow2.jonas.security.internal.realm.lib.HashHelper;
import org.ow2.jonas.security.internal.realm.lib.XML;
import org.ow2.jonas.security.internal.realm.principal.Group;
import org.ow2.jonas.security.internal.realm.principal.Role;
import org.ow2.jonas.security.internal.realm.principal.User;
import org.ow2.jonas.security.realm.factory.JResourceException;
import org.ow2.jonas.security.realm.principal.JUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JResourceMemory
extends AbstractJResource {
    private static final long serialVersionUID = 1L;
    private Hashtable<String, Group> groups = new Hashtable();
    private Hashtable<String, Role> roles = new Hashtable();
    private static final String FACTORY_TYPE = "org.ow2.jonas.security.internal.realm.factory.JResourceMemory";
    private static final String FACTORY_NAME = "org.ow2.jonas.security.internal.realm.factory.JResourceMemoryFactory";

    public void addUser(User user) throws Exception {
        if (this.getUsers().get(user.getName()) != null) {
            throw new Exception("User " + user.getName() + " already exists.");
        }
        String[] userGroups = user.getArrayGroups();
        String groupName = null;
        for (int g = 0; g < userGroups.length; ++g) {
            groupName = userGroups[g];
            if (this.groups.containsKey(groupName)) continue;
            this.addGroup(new Group(groupName));
        }
        String[] userRoles = user.getArrayRoles();
        String roleName = null;
        for (int g = 0; g < userRoles.length; ++g) {
            roleName = userRoles[g];
            if (this.roles.containsKey(roleName)) continue;
            this.addRole(new Role(roleName));
        }
        this.getUsers().put(user.getName(), user);
        this.registerUserMBean(user);
    }

    public void addGroup(Group group) throws Exception {
        if (this.groups.get(group.getName()) != null) {
            throw new Exception("Group " + group.getName() + " already exists.");
        }
        String[] groupRoles = group.getArrayRoles();
        String roleName = null;
        for (int g = 0; g < groupRoles.length; ++g) {
            roleName = groupRoles[g];
            if (this.roles.containsKey(roleName)) continue;
            this.addRole(new Role(roleName));
        }
        this.groups.put(group.getName(), group);
        this.registerGroupMBean(group);
    }

    public void addRole(Role role) throws Exception {
        if (this.roles.get(role.getName()) != null) {
            throw new Exception("Role " + role.getName() + " already exists.");
        }
        this.roles.put(role.getName(), role);
        this.registerRoleMBean(role);
    }

    public JUser findUser(String name) throws JResourceException {
        if (name == null) {
            return null;
        }
        return (User)this.getUsers().get(name);
    }

    public boolean isValidUser(JUser user, String credentials) {
        boolean validated = false;
        String pass = user.getHashPassword().getPassword();
        String algo = user.getHashPassword().getAlgorithm();
        if (algo != null) {
            try {
                validated = HashHelper.hashPassword(credentials, algo).equalsIgnoreCase(pass);
            }
            catch (NoSuchAlgorithmException nsae) {
                JResourceMemory.getLogger().log(BasicLevel.ERROR, (Object)("Can't make a password with the algorithm " + algo + ". " + nsae.getMessage()));
            }
        } else {
            validated = credentials.equals(pass);
        }
        return validated;
    }

    public Hashtable<String, Group> getGroups() {
        return this.groups;
    }

    public Hashtable<String, Role> getRoles() {
        return this.roles;
    }

    public ArrayList<String> getArrayListCombinedRoles(JUser user) throws JResourceException {
        ArrayList<String> allCombinedRoles = new ArrayList<String>();
        if (user == null) {
            return allCombinedRoles;
        }
        String[] userRoles = user.getArrayRoles();
        for (int r = 0; r < userRoles.length; ++r) {
            String roleName = userRoles[r];
            if (allCombinedRoles.contains(roleName)) continue;
            allCombinedRoles.add(roleName);
        }
        String[] userGroups = user.getArrayGroups();
        for (int g = 0; g < userGroups.length; ++g) {
            String groupName = userGroups[g];
            Group group = this.groups.get(groupName);
            if (group == null) continue;
            String[] groupRoles = group.getArrayRoles();
            for (int gr = 0; gr < groupRoles.length; ++gr) {
                String roleName = groupRoles[gr];
                if (allCombinedRoles.contains(roleName)) continue;
                allCombinedRoles.add(roleName);
            }
        }
        return allCombinedRoles;
    }

    public void setGroups(Hashtable<String, Group> groups) {
        this.groups = groups;
    }

    public void setRoles(Hashtable<String, Role> roles) {
        this.roles = roles;
    }

    public void addUser(String username, String password) throws Exception {
        this.addUser(new User(username, password));
    }

    public void addGroup(String groupname) throws Exception {
        this.addGroup(new Group(groupname));
    }

    public void addRole(String rolename) throws Exception {
        this.addRole(new Role(rolename));
    }

    public void removeUser(String username) throws Exception {
        if (this.getUsers().get(username) == null) {
            throw new Exception("Can not remove user " + username + ". This user doesn't exist");
        }
        this.getUsers().remove(username);
        this.unregisterUserMBean(this.getName(), username);
    }

    public void removeGroup(String groupname) throws Exception {
        if (this.groups.get(groupname) == null) {
            throw new Exception("Can not remove group " + groupname + ". This group doesn't exist");
        }
        Enumeration<JUser> users = this.getUsers().elements();
        while (users.hasMoreElements()) {
            User user = (User)users.nextElement();
            user.removeGroup(groupname);
        }
        this.groups.remove(groupname);
        this.unregisterGroupMBean(this.getName(), groupname);
    }

    public void removeRole(String rolename) throws Exception {
        if (this.roles.get(rolename) == null) {
            throw new Exception("Can not remove role " + rolename + ". This role doesn't exist");
        }
        Enumeration<Group> groups = this.getGroups().elements();
        while (groups.hasMoreElements()) {
            Group group = groups.nextElement();
            group.removeRole(rolename);
        }
        Enumeration<JUser> users = this.getUsers().elements();
        while (users.hasMoreElements()) {
            User user = (User)users.nextElement();
            user.removeRole(rolename);
        }
        this.roles.remove(rolename);
        this.unregisterRoleMBean(this.getName(), rolename);
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("    <memoryrealm name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("      <roles>\n");
        XML.xmlHashtable(xml, this.getRoles(), "        ");
        xml.append("      </roles>\n");
        xml.append("      <groups>\n");
        XML.xmlHashtable(xml, this.getGroups(), "        ");
        xml.append("      </groups>\n");
        xml.append("      <users>\n");
        XML.xmlHashtable(xml, this.getUsers(), "        ");
        xml.append("      </users>\n");
        xml.append("    </memoryrealm>");
        return xml.toString();
    }

    public String toString() {
        return this.toXML();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(FACTORY_TYPE, FACTORY_NAME, null);
        reference.add(new StringRefAddr("name", this.getName()));
        byte[] bytes = JNDIUtils.getBytesFromObject(this.getUsers(), (Logger)JResourceMemory.getLogger());
        if (bytes != null) {
            reference.add(new BinaryRefAddr("users", bytes));
        }
        if ((bytes = JNDIUtils.getBytesFromObject(this.groups, (Logger)JResourceMemory.getLogger())) != null) {
            reference.add(new BinaryRefAddr("groups", bytes));
        }
        if ((bytes = JNDIUtils.getBytesFromObject(this.roles, (Logger)JResourceMemory.getLogger())) != null) {
            reference.add(new BinaryRefAddr("roles", bytes));
        }
        return reference;
    }

    public String[] listRoles() {
        String[] s = new String[this.roles.size()];
        int i = 0;
        Enumeration<String> e = this.roles.keys();
        while (e.hasMoreElements()) {
            s[i] = e.nextElement();
            ++i;
        }
        return s;
    }

    public String[] listGroups() {
        String[] s = new String[this.groups.size()];
        int i = 0;
        Enumeration<String> e = this.groups.keys();
        while (e.hasMoreElements()) {
            s[i] = e.nextElement();
            ++i;
        }
        return s;
    }

    public void removeMBeans() throws JResourceException {
        boolean error = false;
        Enumeration<Object> e = this.getUsers().elements();
        while (e.hasMoreElements()) {
            User u = (User)e.nextElement();
            try {
                this.unregisterUserMBean(this.getName(), u.getName());
            }
            catch (MalformedObjectNameException e1) {
                e1.printStackTrace();
                error = true;
            }
        }
        e = this.roles.elements();
        while (e.hasMoreElements()) {
            Role r = (Role)e.nextElement();
            try {
                this.unregisterRoleMBean(this.getName(), r.getName());
            }
            catch (MalformedObjectNameException e1) {
                e1.printStackTrace();
                error = true;
            }
        }
        e = this.groups.elements();
        while (e.hasMoreElements()) {
            Group g = (Group)e.nextElement();
            try {
                this.unregisterGroupMBean(this.getName(), g.getName());
            }
            catch (MalformedObjectNameException e1) {
                e1.printStackTrace();
                error = true;
            }
        }
        if (error) {
            throw new JResourceException("There were errors during the remove of the MBeans resource " + this.getName());
        }
    }
}

