/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.modifier;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;

public abstract class AbsApplicationModifier
extends ArchiveModifier {
    private List ejbModifiers = null;
    private List webModifiers = null;
    private List cltModifiers = null;
    private Application app = null;
    private Config config = null;

    public AbsApplicationModifier(Application archive, Config config) {
        super(archive);
        this.config = config;
        this.app = archive;
        this.initVectors();
        this.init();
    }

    private void initVectors() {
        this.ejbModifiers = new Vector();
        this.webModifiers = new Vector();
        this.cltModifiers = new Vector();
    }

    protected abstract void init();

    public Archive modify() throws GenBaseException {
        Archive a;
        AbsApplicationModifier.getLogger().log(BasicLevel.INFO, (Object)("Processing Application " + this.app.getName()));
        for (ArchiveModifier wm : this.webModifiers) {
            a = wm.modify();
            if (AbsApplicationModifier.getLogger().isLoggable(BasicLevel.DEBUG)) {
                AbsApplicationModifier.getLogger().log(BasicLevel.DEBUG, (Object)("Modifying WebApp '" + a.getName() + "'"));
            }
            this.app.addFile(a.getRootFile());
        }
        for (ArchiveModifier cm : this.cltModifiers) {
            a = cm.modify();
            if (AbsApplicationModifier.getLogger().isLoggable(BasicLevel.DEBUG)) {
                AbsApplicationModifier.getLogger().log(BasicLevel.DEBUG, (Object)("Modifying Client '" + a.getName() + "'"));
            }
            this.app.addFile(a.getRootFile());
        }
        for (ArchiveModifier em : this.ejbModifiers) {
            a = em.modify();
            if (AbsApplicationModifier.getLogger().isLoggable(BasicLevel.DEBUG)) {
                AbsApplicationModifier.getLogger().log(BasicLevel.DEBUG, (Object)("Modifying EjbJar '" + a.getName() + "'"));
            }
            this.app.addFile(a.getRootFile());
        }
        return this.save(this.config, "apps" + File.separator + this.app.getName());
    }

    protected List getCltModifiers() {
        return this.cltModifiers;
    }

    protected List getEjbModifiers() {
        return this.ejbModifiers;
    }

    protected List getWebModifiers() {
        return this.webModifiers;
    }

    protected Application getApplication() {
        return this.app;
    }
}

