/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.ha.local;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Timer;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.local.LocalRequestChannel;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.GetProxyIdListNot;
import org.objectweb.joram.mom.proxies.ResetCollocatedConnectionsNot;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class HALocalRequestChannel
implements RequestChannel {
    public static Logger logger = Debug.getLogger((String)HALocalRequestChannel.class.getName());
    public static final int NONE = 0;
    public static final int INIT = 1;
    public static final int RUN = 2;
    private static Object lock = new Object();
    private static int status;
    private Identity identity;
    private LocalRequestChannel localRequestChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String args, boolean firstTime) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("HALocalConnection.init(" + args + ',' + firstTime + ')'));
        }
        Object object = lock;
        synchronized (object) {
            status = 1;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForStart() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"HALocalConnection.waitForStart()");
        }
        Object object = lock;
        synchronized (object) {
            while (status == 0) {
                try {
                    lock.wait();
                }
                catch (InterruptedException exc) {}
            }
            if (status == 1) {
                GetProxyIdListNot gpin = new GetProxyIdListNot();
                try {
                    gpin.invoke(AdminTopic.getDefault());
                    AgentId[] proxyIds = gpin.getIds();
                    ResetCollocatedConnectionsNot rccn = new ResetCollocatedConnectionsNot();
                    for (int i = 0; i < proxyIds.length; ++i) {
                        Channel.sendTo((AgentId)proxyIds[i], (Notification)rccn);
                    }
                    status = 2;
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                    throw new Error(exc.toString());
                }
            }
        }
    }

    public HALocalRequestChannel(Identity identity) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("HALocalConnection.<init>(" + identity + ')'));
        }
        HALocalRequestChannel.waitForStart();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)" -> create the local connection");
        }
        this.identity = identity;
    }

    public void setTimer(Timer timer) {
    }

    public void connect() throws Exception {
        this.localRequestChannel = new LocalRequestChannel(this.identity);
        this.localRequestChannel.connect();
    }

    public void send(AbstractJmsRequest request) throws Exception {
        this.localRequestChannel.send(request);
    }

    public AbstractJmsReply receive() throws Exception {
        return this.localRequestChannel.receive();
    }

    public void close() {
        this.localRequestChannel.close();
    }

    public void closing() {
    }
}

