/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.fos.xml2mi;

import java.util.Iterator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.fos.metainfo.FosClassMapping;
import org.objectweb.jorm.mapper.fos.metainfo.FosGenClassMapping;
import org.objectweb.jorm.mapper.fos.metainfo.FosMapping;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.xml2mi.lib.BasicMappingParser;
import org.objectweb.util.monolog.api.BasicLevel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FosParser
extends BasicMappingParser {
    private void parseClassMapping(Element classMappingElem, Mapping mapping) {
        FosClassMapping fosClassMapping = (FosClassMapping)mapping.createClassMapping("");
        fosClassMapping.setLogger(this.logger);
        Class c = (Class)fosClassMapping.getLinkedMO();
        Iterator it = c.getFields().iterator();
        while (it.hasNext()) {
            Object fd = it.next();
            if (!(fd instanceof PrimitiveElement)) continue;
            fosClassMapping.addFieldMapping(((PrimitiveElement)fd).getName());
        }
        NodeList children = classMappingElem.getChildNodes();
        String dirname = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Iterator it2;
            NameDef nd;
            String linkend;
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("fos-dir-name")) {
                dirname = child.getFirstChild().getNodeValue();
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("read dirname: " + dirname));
                }
            } else if (childName.equals("id-mapping")) {
                linkend = ((Element)child).getAttribute("link-end");
                nd = this.getIdNameDef(fosClassMapping, linkend);
                if (nd.isNameRef()) {
                    it2 = nd.iterateField();
                    while (it2.hasNext()) {
                        fosClassMapping.addFieldMapping((String)it2.next());
                    }
                } else {
                    fosClassMapping.addFieldMapping(nd.getFieldName());
                }
                fosClassMapping.createIdentifierMapping(nd);
            } else if (childName.equals("fos-ref-mapping")) {
                linkend = ((Element)child).getAttribute("link-end");
                nd = this.getRefNameDef(linkend, childName);
                if (nd.isNameRef()) {
                    it2 = nd.iterateField();
                    while (it2.hasNext()) {
                        fosClassMapping.addFieldMapping((String)it2.next());
                    }
                } else {
                    fosClassMapping.addFieldMapping(nd.getFieldName());
                }
                fosClassMapping.createReferenceMapping(null, nd);
            } else if (!childName.equals("#text")) {
                this.logger.log(BasicLevel.WARN, (Object)("element <" + childName + "> unknown !"));
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
        fosClassMapping.setDirName(dirname);
    }

    private void parseGenClassMapping(Element genClassMappingElem, Mapping mapping) {
        GenClassRef genClassRef;
        String linkend = genClassMappingElem.getAttribute("link-end");
        if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("linkend of fos-gen-class-mapping <" + linkend + ">"));
        }
        if ((genClassRef = (GenClassRef)this.idvalue2genclassref.get(linkend)) != null && this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("GenClassRef name " + genClassRef.getName()));
        }
        if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("create a new BasicFosGenClassMapping for the current Class (" + this.currentClass.getName() + ")"));
        }
        FosGenClassMapping fosGenClassMapping = ((FosMapping)mapping).createGenClassMapping("", genClassRef);
        fosGenClassMapping.setLogger(this.logger);
        Iterator it = genClassRef.getIndexFields().iterator();
        while (it.hasNext()) {
            fosGenClassMapping.addFieldMapping(((TypedElement)it.next()).getName());
        }
        NodeList children = genClassMappingElem.getChildNodes();
        String dirname = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Iterator it2;
            NameDef nd;
            String namedefName;
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("fos-dir-name")) {
                dirname = child.getFirstChild().getNodeValue();
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("read dirname: " + dirname));
                }
            } else if (childName.equals("id-mapping")) {
                namedefName = ((Element)child).getAttribute("link-end");
                nd = genClassRef.getIdNameDef(namedefName);
                if (nd.isNameRef()) {
                    it2 = nd.iterateField();
                    while (it2.hasNext()) {
                        fosGenClassMapping.addFieldMapping((String)it2.next());
                    }
                } else {
                    fosGenClassMapping.addFieldMapping(nd.getFieldName());
                }
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Fetching the ID name def of the GenClassRef " + namedefName));
                    if (nd.isFieldName()) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("fieldName: " + nd.getFieldName()));
                    } else if (nd.isNameRef()) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("NameRef: " + nd.getNameRef()));
                    }
                }
                fosGenClassMapping.createIdentifierMapping(nd);
            } else if (childName.equals("fos-ref-mapping")) {
                namedefName = ((Element)child).getAttribute("link-end");
                nd = null;
                if (genClassRef.isPrimitive()) {
                    this.logger.log(BasicLevel.WARN, (Object)("You define a generic class of primitive and a useless name-def for the elements: generic class id=" + genClassRef.getGenClassId()));
                    continue;
                }
                if (genClassRef.isClassRef()) {
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Get the ref name def of the GenClassRef " + namedefName));
                    }
                    if ((nd = genClassRef.getClassRef().getRefNameDef(namedefName)).isNameRef()) {
                        it2 = nd.iterateField();
                        while (it2.hasNext()) {
                            fosGenClassMapping.addFieldMapping((String)it2.next());
                        }
                    } else {
                        fosGenClassMapping.addFieldMapping(nd.getFieldName());
                    }
                } else if (genClassRef.isGenClassRef()) {
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Get the ref name def of the ClassRef " + namedefName));
                    }
                    if ((nd = genClassRef.getGenClassRef().getRefNameDef(namedefName)).isNameRef()) {
                        it2 = nd.iterateField();
                        while (it2.hasNext()) {
                            fosGenClassMapping.addFieldMapping((String)it2.next());
                        }
                    } else {
                        fosGenClassMapping.addFieldMapping(nd.getFieldName());
                    }
                }
                String ruleName = ((Element)child).getAttribute("rule-name");
                fosGenClassMapping.createReferenceMapping(ruleName, nd);
            } else if (!childName.equals("#text")) {
                this.logger.log(BasicLevel.WARN, (Object)("element <" + childName + "> unknown !"));
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
        fosGenClassMapping.setDirName(dirname);
    }

    public void parseMapping(Element mappingElem, Mapping mapping) throws PException {
        if (mappingElem.getNodeName().equals("fos-class-mapping")) {
            this.parseClassMapping(mappingElem, mapping);
        } else if (mappingElem.getNodeName().equals("fos-gen-class-mapping")) {
            this.parseGenClassMapping(mappingElem, mapping);
        } else {
            throw new PException("Mapping element not supported by FOS: " + mappingElem.getNodeName());
        }
    }
}

