/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.util.io.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class DirJavaExplorer
implements PathExplorer,
Loggable {
    private Collection paths = new ArrayList();
    private Logger logger;
    private LoggerFactory loggerFactory;
    static final String LOGGER_NAME = "org.objectweb.jorm.io.pathexplorer";
    static String fileSeparator = System.getProperty("file.separator");
    static String pathSeparator = System.getProperty("path.separator");

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactory loggerfactory) {
        this.loggerFactory = this.loggerFactory;
        if (this.logger == null && this.loggerFactory != null) {
            this.logger = this.loggerFactory.getLogger(LOGGER_NAME);
        }
    }

    public void addPath(String cpath) {
        int previous = 0;
        int current = cpath.indexOf(pathSeparator, previous);
        while (current != -1) {
            this.paths.add(cpath.substring(previous, current));
            previous = current + 1;
            current = cpath.indexOf(pathSeparator, previous);
        }
        this.paths.add(cpath.substring(previous));
    }

    public void addPath(Collection path) {
        this.paths.addAll(path);
    }

    public InputStream getInputStream(String file) {
        if (this.logger != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Search " + file));
        }
        try {
            File f = null;
            Iterator it = this.paths.iterator();
            while (it.hasNext()) {
                File p;
                String path = (String)it.next();
                if (this.logger != null) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Try with " + path));
                }
                if ((p = new File(path)).exists()) {
                    if (p.isDirectory()) {
                        f = new File(p, file);
                        if (!f.exists()) continue;
                        if (this.logger != null) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("Found " + f.getAbsolutePath()));
                        }
                        return new FileInputStream(f);
                    }
                    if (p.isFile()) {
                        JarFile jarfile = null;
                        try {
                            jarfile = new JarFile(path);
                            ZipEntry zipentry = jarfile.getEntry(file);
                            if (zipentry == null) {
                                zipentry = jarfile.getEntry(file.replace('\\', '/'));
                            }
                            if (zipentry == null) {
                                zipentry = jarfile.getEntry(file.replace('/', '\\'));
                            }
                            if (zipentry != null) {
                                if (this.logger != null) {
                                    this.logger.log(BasicLevel.DEBUG, (Object)("Found " + file + " in " + path));
                                }
                                return jarfile.getInputStream(zipentry);
                            }
                            if (this.logger == null) continue;
                            this.logger.log(BasicLevel.DEBUG, (Object)("Entry not Found " + file + " in jar file " + path));
                            Enumeration<JarEntry> e = jarfile.entries();
                            while (e.hasMoreElements()) {
                                this.logger.log(BasicLevel.DEBUG, (Object)("entry: " + e.nextElement()));
                            }
                            continue;
                        }
                        catch (IOException e) {
                            if (this.logger == null) continue;
                            this.logger.log(BasicLevel.WARN, (Object)("Unmanaged file entry: " + path));
                            continue;
                        }
                    }
                    if (this.logger == null) continue;
                    this.logger.log(BasicLevel.WARN, (Object)("Unmanaged path entry: " + path));
                    continue;
                }
                System.out.println("WARN: Unreachable path entry: " + path);
            }
            f = new File(file);
            if (f.exists()) {
                if (this.logger != null) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Found " + f.getAbsolutePath()));
                }
                return new FileInputStream(f);
            }
            return null;
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.ERROR, (Object)"", (Throwable)e);
            }
            return null;
        }
    }

    public OutputStream getOutputStream(String file) {
        return null;
    }

    public String getClassPath() {
        String result = "";
        boolean first = true;
        Iterator it = this.paths.iterator();
        while (it.hasNext()) {
            result = result + (first ? "" : File.pathSeparator) + it.next();
            first = false;
        }
        return result;
    }
}

