/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.util.io.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Iterator;
import org.objectweb.jorm.util.io.api.TargetHolder;

public class JavaFileHolder
implements TargetHolder {
    private Hashtable name2fw = new Hashtable();
    private File targetDirectory = null;

    public JavaFileHolder(String _targetDirectory) throws Exception {
        if (_targetDirectory == null) {
            String currentDir = System.getProperties().getProperty("user.dir");
            this.targetDirectory = new File(currentDir);
        } else {
            this.targetDirectory = new File(_targetDirectory);
        }
        if (!this.targetDirectory.isDirectory()) {
            throw new Exception("The parameter must be a directory.");
        }
    }

    public synchronized FileWriter getFileWriter(String fileName) throws Exception {
        File child = new File(this.targetDirectory, fileName);
        FileWriter result = (FileWriter)this.name2fw.get(child);
        if (result == null) {
            File parentDir = child.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            child.createNewFile();
            result = new FileWriter(child);
            this.name2fw.put(child, result);
        }
        return result;
    }

    public synchronized FileOutputStream getFileOutputStream(String fileName) throws Exception {
        File child = new File(this.targetDirectory, fileName);
        File parentDir = child.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        child.createNewFile();
        FileOutputStream fos = new FileOutputStream(child);
        return fos;
    }

    public File getFile(String filename) {
        return new File(this.targetDirectory, filename);
    }

    public synchronized Iterator iterateFile() {
        return this.name2fw.keySet().iterator();
    }

    public synchronized Iterator iterateFileWriter() {
        return this.name2fw.entrySet().iterator();
    }

    public synchronized void javacAll() throws Exception {
    }
}

