/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.datasource.rdb.lib;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JDBCTupleCollection
implements TupleCollection {
    private ResultSet resultSet;
    private TupleStructure tupleStructure;
    private VariableOperand[] operandBuffer;
    private Tuple buffer;
    private RdbAdapter adapter;
    private PreparedStatement preparedStatement;
    private boolean debug;
    private Logger log;
    private int index;
    private boolean isLast = false;

    public JDBCTupleCollection(TupleStructure tupleStructure, ResultSet rs, PreparedStatement ps, RdbAdapter adapter, Logger logger) throws MedorException, ExpressionException, SQLException {
        this.log = logger;
        this.debug = this.log.isLoggable(BasicLevel.DEBUG);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"JDBCTupleCollection creation");
        }
        this.tupleStructure = tupleStructure;
        this.resultSet = rs;
        int size = tupleStructure.getSize();
        this.operandBuffer = new VariableOperand[size];
        for (int cpt = 0; cpt < size; ++cpt) {
            this.operandBuffer[cpt] = new BasicVariableOperand(tupleStructure.getField(cpt + 1).getType());
        }
        this.buffer = new MemoryTuple(this.operandBuffer);
        this.adapter = adapter;
        this.preparedStatement = ps;
        this.index = 0;
        this.isLast = false;
        this.next();
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.tupleStructure;
    }

    public boolean isLast() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.isLast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MedorException {
        if (this.resultSet != null) {
            JDBCTupleCollection jDBCTupleCollection = this;
            synchronized (jDBCTupleCollection) {
                if (this.resultSet != null) {
                    try {
                        try {
                            this.resultSet.close();
                            this.preparedStatement.close();
                        }
                        catch (SQLException e) {
                            throw new MedorException("Impossible to close the result set: ", e);
                        }
                        Object var4_2 = null;
                        this.resultSet = null;
                        this.preparedStatement = null;
                        this.tupleStructure = null;
                        this.buffer = null;
                        this.adapter = null;
                        this.operandBuffer = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_3 = null;
                        this.resultSet = null;
                        this.preparedStatement = null;
                        this.tupleStructure = null;
                        this.buffer = null;
                        this.adapter = null;
                        this.operandBuffer = null;
                        throw throwable;
                    }
                }
            }
        }
    }

    public boolean next() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.isLast) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)"No more result");
            }
            return false;
        }
        try {
            this.loadTuple();
            ++this.index;
            boolean bl = this.isLast = !this.resultSet.next();
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Current tuple load from the resultset, index=" + this.index + ", isLast=" + this.isLast));
            }
        }
        catch (SQLException sqlex) {
            throw new MedorException(sqlex);
        }
        catch (ExpressionException sqlex) {
            throw new MedorException(sqlex);
        }
        return true;
    }

    public void first() throws MedorException {
        block7: {
            if (this.resultSet == null) {
                throw new MedorException("Impossible to use a closed TupleCollection");
            }
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)"");
            }
            if (this.index == 1) {
                return;
            }
            try {
                if (this.resultSet.first()) {
                    this.index = 0;
                    this.isLast = false;
                    this.next();
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)"resultset.previous()=true");
                    }
                    break block7;
                }
                throw new MedorException("can't move the cursor to the first row");
            }
            catch (SQLException ex) {
                throw new MedorException(ex);
            }
        }
    }

    public int getRow() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.index;
    }

    public Tuple getTuple() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.buffer;
    }

    private void loadTuple() throws ExpressionException, MedorException, SQLException {
        StringBuffer sb;
        PType ptype = null;
        int size = this.tupleStructure.getSize();
        if (this.debug) {
            sb = new StringBuffer();
        }
        block27: for (int cpt = 1; cpt <= size; ++cpt) {
            ptype = this.tupleStructure.getField(cpt).getType();
            switch (ptype.getTypeCode()) {
                case 4: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getInt(this.resultSet, cpt, -1));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 3: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getShort(this.resultSet, cpt, (short)-1));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 2: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getByte(this.resultSet, cpt, (byte)-1));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 5: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getLong(this.resultSet, cpt, -1L));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 7: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getDouble(this.resultSet, cpt, -1.0));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 0: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getBoolean(this.resultSet, cpt, false));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 6: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getFloat(this.resultSet, cpt, 0.0f));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 16: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getString(this.resultSet, cpt, null));
                    continue block27;
                }
                case 8: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getOboolean(this.resultSet, cpt, null));
                    continue block27;
                }
                case 9: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getOchar(this.resultSet, cpt, null));
                    continue block27;
                }
                case 10: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getObyte(this.resultSet, cpt, null));
                    continue block27;
                }
                case 11: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getOshort(this.resultSet, cpt, null));
                    continue block27;
                }
                case 12: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getOint(this.resultSet, cpt, null));
                    continue block27;
                }
                case 13: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getOlong(this.resultSet, cpt, null));
                    continue block27;
                }
                case 14: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getOfloat(this.resultSet, cpt, null));
                    continue block27;
                }
                case 15: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getOdouble(this.resultSet, cpt, null));
                    continue block27;
                }
                case 17: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getDate(this.resultSet, cpt, null));
                    continue block27;
                }
                case 1: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getChar(this.resultSet, cpt, '\u0000'));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 19: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getByteArray(this.resultSet, cpt, null));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 18: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getCharArray(this.resultSet, cpt, null));
                    this.operandBuffer[cpt - 1].setIsDefined(!this.resultSet.wasNull());
                    continue block27;
                }
                case 22: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getBigDecimal(this.resultSet, cpt, null));
                    continue block27;
                }
                case 21: {
                    this.operandBuffer[cpt - 1].setValue(this.adapter.getBigInteger(this.resultSet, cpt, null));
                    continue block27;
                }
                case 20: {
                    try {
                        this.operandBuffer[cpt - 1].setValue(this.adapter.getSerialized(this.resultSet, cpt, null));
                        continue block27;
                    }
                    catch (Exception e) {
                        throw new MedorException("Impossible to fetch a serialized field a the index " + cpt, e);
                    }
                }
            }
        }
        if (this.debug) {
            sb = new StringBuffer("[");
            String sep = "";
            for (int cpt = 0; cpt < size; ++cpt) {
                sb.append(sep);
                sb.append(this.operandBuffer[cpt]);
                sep = ",";
            }
            sb.append(']');
            this.log.log(BasicLevel.DEBUG, (Object)("Tuple loaded: " + sb.toString()));
        }
    }

    public Tuple getTuple(int row) throws MedorException {
        if (this.row(row)) {
            return this.getTuple();
        }
        throw new MedorException("Can't move to the row: " + row);
    }

    public boolean isEmpty() throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("return " + (this.buffer == null)));
        }
        return this.buffer == null;
    }

    public boolean row(int i) throws MedorException {
        if (this.resultSet == null) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (this.index == i) {
            return true;
        }
        try {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("resultSet.absolute(" + i + ")"));
            }
            if (this.resultSet.absolute(i)) {
                this.index = i - 1;
                this.isLast = false;
                this.next();
                return true;
            }
            return false;
        }
        catch (SQLException sqlex) {
            throw new MedorException(sqlex);
        }
    }
}

