/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.datasource.rdb.lib;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.OracleAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.lib.RdbConnectionWrapper;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.api.EvaluationException;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.datasource.api.Wrapper;
import org.objectweb.medor.datasource.rdb.lib.JDBCTupleCollection;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.expression.api.CalculatedParameterOperand;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.InCollection;
import org.objectweb.medor.filter.lib.IsEmpty;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.medor.query.rdb.api.RdbQueryLeaf;
import org.objectweb.medor.query.rdb.lib.AggregateRdbQueryNode;
import org.objectweb.medor.query.rdb.lib.MedorExpression2WhereClause;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.EmptyTupleCollection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JDBCWrapper
implements Wrapper {
    static Logger log = null;
    static Logger TClog = null;
    boolean debug;

    public JDBCWrapper() {
        if (log == null) {
            log = Log.loggerFactory.getLogger("org.objectweb.medor.eval.rdb.JDBCWrapper");
            TClog = Log.loggerFactory.getLogger("org.objectweb.medor.eval.rdb.JDBCTC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleCollection fetchData(QueryLeaf lf, ParameterOperand[] parameters, Object connection, EvaluationMetaData evalMD) throws EvaluationException {
        String sqlRequest;
        this.debug = log.isLoggable(BasicLevel.DEBUG);
        if (this.debug) {
            log.log(BasicLevel.DEBUG, (Object)("Parameters: " + this.posToString(parameters)));
        }
        RdbQueryLeaf leaf = (RdbQueryLeaf)lf;
        RdbAdapter rdbAdapt = this.getRdbAdapter(leaf);
        Connection conn = this.getConnection(connection);
        ResultSet resultSet = null;
        PreparedStatement ps = null;
        ParameterOperand[] usedParameters = this.getUsedPOs(leaf, parameters, rdbAdapt, evalMD);
        RdbQueryLeaf rdbQueryLeaf = leaf;
        synchronized (rdbQueryLeaf) {
            try {
                sqlRequest = leaf.getSqlRequest(parameters, evalMD != null && evalMD.getLimitedRangeStartAt() > 0, evalMD != null && evalMD.getLimitedRangeSize() < Integer.MAX_VALUE);
                if (this.debug) {
                    log.log(BasicLevel.DEBUG, (Object)("SQL query for leaf " + leaf + ": " + sqlRequest));
                }
            }
            catch (Exception e) {
                throw new EvaluationException(e);
            }
        }
        try {
            ps = conn.prepareStatement(sqlRequest, 1004, 1007);
            if (usedParameters != null) {
                this.assignParameter(ps, usedParameters, rdbAdapt);
            }
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
        if (this.debug) {
            log.log(BasicLevel.DEBUG, (Object)("Evaluate the query: " + sqlRequest));
        }
        try {
            resultSet = ps.executeQuery();
            if (!resultSet.next()) {
                if (this.debug) {
                    log.log(BasicLevel.DEBUG, (Object)"No result, closing the ResultSet and the PreparedStatement");
                }
                resultSet.close();
                ps.close();
                return new EmptyTupleCollection(lf.getTupleStructure());
            }
            if (this.debug) {
                log.log(BasicLevel.DEBUG, (Object)"There is a result");
            }
            return new JDBCTupleCollection(lf.getTupleStructure(), resultSet, ps, rdbAdapt, TClog);
        }
        catch (EvaluationException ee) {
            throw ee;
        }
        catch (Exception mexp) {
            throw new EvaluationException(mexp);
        }
    }

    private Connection getConnection(Object connection) throws EvaluationException {
        try {
            return RdbConnectionWrapper.narrow2SQL(connection);
        }
        catch (PException e) {
            throw new EvaluationException("Impossible to evaluate a jdbc leaf:", e);
        }
    }

    private RdbAdapter getRdbAdapter(RdbQueryLeaf leaf) {
        RdbAdapter rdbAdapt = null;
        if (leaf instanceof RdbExpQueryLeaf) {
            rdbAdapt = ((RdbExpQueryLeaf)leaf).getRdbAdapter();
        } else if (leaf instanceof AggregateRdbQueryNode) {
            QueryTree[] children = ((AggregateRdbQueryNode)leaf).getChildren();
            int i = 0;
            while (rdbAdapt == null) {
                rdbAdapt = this.getRdbAdapter((RdbQueryLeaf)children[i]);
                ++i;
            }
        }
        if (rdbAdapt == null) {
            rdbAdapt = new BasicRdbAdapter();
        }
        return rdbAdapt;
    }

    private void assignParameter(PreparedStatement ps, ParameterOperand[] usedParameters, RdbAdapter rdbAdapt) throws MedorException, ExpressionException, SQLException, IOException {
        int index = 1;
        for (int i = 0; i < usedParameters.length; ++i) {
            ParameterOperand po = usedParameters[i];
            if (this.debug) {
                log.log(BasicLevel.DEBUG, (Object)("Assign parameter (name=" + po.getName() + ", value=" + po + ")"));
            }
            switch (po.getType().getTypeCode()) {
                case 4: {
                    rdbAdapt.setInt(ps, index, po.getInt());
                    break;
                }
                case 12: {
                    rdbAdapt.setOint(ps, index, (Integer)po.getObject());
                    break;
                }
                case 3: {
                    rdbAdapt.setShort(ps, index, po.getShort());
                    break;
                }
                case 11: {
                    rdbAdapt.setOshort(ps, index, (Short)po.getObject());
                    break;
                }
                case 2: {
                    rdbAdapt.setByte(ps, index, po.getByte());
                    break;
                }
                case 10: {
                    rdbAdapt.setObyte(ps, index, (Byte)po.getObject());
                    break;
                }
                case 5: {
                    rdbAdapt.setLong(ps, index, po.getLong());
                    break;
                }
                case 13: {
                    rdbAdapt.setOlong(ps, index, (Long)po.getObject());
                    break;
                }
                case 7: {
                    rdbAdapt.setDouble(ps, index, po.getDouble());
                    break;
                }
                case 15: {
                    rdbAdapt.setOdouble(ps, index, (Double)po.getObject());
                    break;
                }
                case 0: {
                    rdbAdapt.setBoolean(ps, index, po.getBoolean());
                    break;
                }
                case 8: {
                    rdbAdapt.setOboolean(ps, index, (Boolean)po.getObject());
                    break;
                }
                case 6: {
                    rdbAdapt.setFloat(ps, index, po.getFloat());
                    break;
                }
                case 14: {
                    rdbAdapt.setOfloat(ps, index, (Float)po.getObject());
                    break;
                }
                case 21: 
                case 22: {
                    rdbAdapt.setBigDecimal(ps, index, (BigDecimal)po.getObject());
                    break;
                }
                case 16: {
                    rdbAdapt.setString(ps, index, (String)po.getObject());
                    break;
                }
                case 1: {
                    rdbAdapt.setChar(ps, index, po.getChar());
                    break;
                }
                case 9: {
                    rdbAdapt.setOchar(ps, index, (Character)po.getObject());
                    break;
                }
                case 20: {
                    rdbAdapt.setSerialized(ps, index, (Serializable)po.getObject());
                    break;
                }
                case 17: {
                    rdbAdapt.setDate(ps, index, (Date)po.getObject(), null);
                    break;
                }
                case 19: {
                    rdbAdapt.setByteArray(ps, index, (byte[])po.getObject());
                    break;
                }
                case 18: {
                    rdbAdapt.setCharArray(ps, index, (char[])po.getObject());
                    break;
                }
                case 204: {
                    --index;
                    break;
                }
                default: {
                    throw new EvaluationException("The type " + po.getType().getJormName() + " is not supported '" + po.getType().getTypeCode() + "'");
                }
            }
            ++index;
        }
    }

    private ArrayList getUsedParameters(Expression e, ParameterOperand[] parameters, ArrayList al, FilteredQueryTree fqt) throws EvaluationException {
        if (e instanceof IsEmpty) {
            Expression op = ((IsEmpty)e).getExpression(0);
            if (!(op instanceof FieldOperand)) {
                throw new IllegalStateException("can't handle operand type: " + op);
            }
            QueryTree qt = ((QueryTreeField)((FieldOperand)op).getField()).getQueryTree();
            if (!(qt instanceof FilteredQueryTree)) {
                throw new IllegalStateException("can't querytree type: " + qt);
            }
            FilteredQueryTree _fqt = (FilteredQueryTree)qt;
            if (fqt != _fqt) {
                al = this.getUsedParameters(_fqt.getQueryFilter(), parameters, al, _fqt);
            }
        } else if (e instanceof InCollection && !(((Operator)e).getExpression(1) instanceof ParameterOperand)) {
            al = this.getUsedParameters(((Operator)e).getExpression(0), parameters, al, fqt);
            al = this.getUsedParametersInCollection((Collection)((Operand)((Operator)e).getExpression(1)).getObject(), parameters, al);
        } else if (e instanceof Operator) {
            if (e instanceof Equal || e instanceof NotEqual) {
                boolean nullValue_1;
                boolean nullValue_0;
                Operator op = (Operator)e;
                Map<Integer, ParameterOperand[]> ctx = Collections.singletonMap(MedorExpression2WhereClause.POS, parameters);
                try {
                    nullValue_0 = MedorExpression2WhereClause.isNullParameterOperand(op.getExpression(0), ctx);
                    nullValue_1 = MedorExpression2WhereClause.isNullParameterOperand(op.getExpression(1), ctx);
                }
                catch (ExpressionException e1) {
                    throw new EvaluationException(e1);
                }
                if (nullValue_0 ^ nullValue_1) {
                    return al;
                }
            }
            for (int i = 0; i < ((Operator)e).getOperandNumber(); ++i) {
                al = this.getUsedParameters(((Operator)e).getExpression(i), parameters, al, fqt);
            }
        } else if (e instanceof CalculatedParameterOperand) {
            CalculatedParameterOperand cpo = (CalculatedParameterOperand)e;
            try {
                cpo.evaluate(parameters);
            }
            catch (ExpressionException e1) {
                throw new EvaluationException(e1);
            }
            if (al == null) {
                al = new ArrayList<ParameterOperand>();
            }
            al.add(cpo);
        } else if (e instanceof ParameterOperand) {
            int i;
            ParameterOperand param = (ParameterOperand)e;
            for (i = 0; i < parameters.length && !parameters[i].getName().equals(param.getName()); ++i) {
            }
            if (i < parameters.length) {
                if (parameters[i].getType().getTypeCode() != param.getType().getTypeCode()) {
                    throw new EvaluationException("Bad parameter type: found " + parameters[i].getType().getJormName() + " / expected " + param.getType().getJormName());
                }
                if (al == null) {
                    al = new ArrayList<ParameterOperand>();
                }
                al.add(parameters[i]);
            } else {
                StringBuffer msg = new StringBuffer();
                msg.append("You must specify the value of parameter ");
                msg.append(param.getName());
                msg.append(". Found: {");
                String sep = "";
                for (int j = 0; j < parameters.length; ++j) {
                    msg.append(sep);
                    msg.append(parameters[j].getName());
                    sep = ", ";
                }
                msg.append("}");
                throw new EvaluationException(msg.toString());
            }
        }
        return al;
    }

    private ArrayList getUsedParametersInCollection(Collection col, ParameterOperand[] parameters, ArrayList al) throws EvaluationException {
        Iterator colit = col.iterator();
        while (colit.hasNext()) {
            int i;
            Object e = colit.next();
            if (!(e instanceof ParameterOperand)) continue;
            ParameterOperand param = (ParameterOperand)e;
            for (i = 0; i < parameters.length && !parameters[i].getName().equals(param.getName()); ++i) {
            }
            if (i < parameters.length) {
                if (parameters[i].getType().getTypeCode() != param.getType().getTypeCode()) {
                    throw new EvaluationException("Bad parameter type: found " + parameters[i].getType().getJormName() + " / expected " + param.getType().getJormName());
                }
                if (al == null) {
                    al = new ArrayList<ParameterOperand>();
                }
                al.add(parameters[i]);
                continue;
            }
            String msg = "You must specify the value of parameter " + param.getName() + ". Found: {";
            String sep = "";
            for (int j = 0; j < parameters.length; ++j) {
                msg = msg + sep + parameters[j].getName();
                sep = ", ";
            }
            msg = msg + "}";
            throw new EvaluationException(msg);
        }
        return al;
    }

    private ParameterOperand[] getUsedPOs(QueryLeaf leaf, ParameterOperand[] parameters, RdbAdapter rdbAdapt, EvaluationMetaData evalMD) throws EvaluationException {
        Expression filter;
        ArrayList usedParametersList = null;
        if (parameters != null && parameters.length > 0 && leaf instanceof FilteredQueryTree && (filter = ((FilteredQueryTree)((Object)leaf)).getQueryFilter()) != null) {
            usedParametersList = this.getUsedParameters(filter, parameters, null, (FilteredQueryTree)((Object)leaf));
        }
        if ((usedParametersList = this.addRangeParameters(usedParametersList, rdbAdapt, evalMD)) != null && usedParametersList.size() > 0) {
            if (this.debug) {
                log.log(BasicLevel.DEBUG, (Object)("Used parameters: " + usedParametersList));
            }
            return usedParametersList.toArray(new ParameterOperand[usedParametersList.size()]);
        }
        return null;
    }

    private String posToString(ParameterOperand[] pos) {
        if (pos == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("[");
        String sep = "";
        for (int i = 0; i < pos.length; ++i) {
            sb.append(sep);
            sb.append("(name='");
            sb.append("'");
            sb.append(pos[i].getName());
            sb.append("', value=");
            sb.append(pos[i]);
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    private ArrayList addRangeParameters(ArrayList al, RdbAdapter rdbAdapt, EvaluationMetaData evalMD) {
        int rangePosition;
        if (evalMD != null && (rangePosition = rdbAdapt.getRangeParametersAtStart()) != -1) {
            int rangeSize;
            int rangeStart;
            if (al == null) {
                al = new ArrayList<BasicParameterOperand>();
            }
            if ((rangeStart = evalMD.getLimitedRangeStartAt()) > 0) {
                BasicParameterOperand rangeStartParam = new BasicParameterOperand(PTypeSpace.INT, "rangeStart", rangeStart);
                if (rangePosition == 0) {
                    al.add(0, rangeStartParam);
                } else {
                    al.add(rangeStartParam);
                }
            }
            if ((rangeSize = evalMD.getLimitedRangeSize()) < Integer.MAX_VALUE) {
                BasicParameterOperand rangeSizeParam = new BasicParameterOperand(PTypeSpace.INT, "rangeSize", rangeSize);
                if (rangePosition == 0) {
                    if (rangeStart > 0) {
                        al.add(1, rangeSizeParam);
                    } else {
                        al.add(0, rangeSizeParam);
                    }
                } else {
                    al.add(rangeSizeParam);
                }
                if (rangeStart > 0 && rdbAdapt instanceof OracleAdapter) {
                    al.add(new BasicParameterOperand(PTypeSpace.INT, "rangeStart", rangeStart));
                }
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long deleteData(QueryLeaf ql, ParameterOperand[] parameters, Object connection, EvaluationMetaData evalMD) throws EvaluationException {
        int res;
        block17: {
            String sqlDelete;
            this.debug = log.isLoggable(BasicLevel.DEBUG);
            if (this.debug) {
                log.log(BasicLevel.DEBUG, (Object)("Parameters: " + this.posToString(parameters)));
            }
            RdbQueryLeaf leaf = (RdbQueryLeaf)ql;
            RdbAdapter rdbAdapt = this.getRdbAdapter(leaf);
            Connection conn = this.getConnection(connection);
            ParameterOperand[] usedParameters = this.getUsedPOs(leaf, parameters, rdbAdapt, evalMD);
            RdbQueryLeaf rdbQueryLeaf = leaf;
            synchronized (rdbQueryLeaf) {
                try {
                    sqlDelete = leaf.getSqlDelete(parameters);
                }
                catch (Exception e) {
                    throw new EvaluationException(e);
                }
            }
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement(sqlDelete);
                if (usedParameters != null) {
                    this.assignParameter(ps, usedParameters, rdbAdapt);
                }
            }
            catch (Exception e) {
                throw new EvaluationException(e);
            }
            if (this.debug) {
                log.log(BasicLevel.DEBUG, (Object)("Evaluate the query: " + sqlDelete));
            }
            res = 0;
            res = ps.executeUpdate();
            Object var14_16 = null;
            try {
                ps.close();
            }
            catch (SQLException e) {
                log.log(BasicLevel.WARN, (Object)"impossible to close the PreparedStatement", (Throwable)e);
            }
            break block17;
            {
                catch (Exception mexp) {
                    throw new EvaluationException(mexp);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.log(BasicLevel.WARN, (Object)"impossible to close the PreparedStatement", (Throwable)e);
                }
                throw throwable;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long updateData(QueryLeaf ql, ParameterOperand[] parameters, Object connection, EvaluationMetaData evalMD) throws EvaluationException {
        int res;
        block18: {
            String sqlUpdate;
            this.debug = log.isLoggable(BasicLevel.DEBUG);
            if (this.debug) {
                log.log(BasicLevel.DEBUG, (Object)("Parameters: " + this.posToString(parameters)));
            }
            RdbQueryLeaf leaf = (RdbQueryLeaf)ql;
            RdbAdapter rdbAdapt = this.getRdbAdapter(leaf);
            Connection conn = this.getConnection(connection);
            ParameterOperand[] usedParameters = this.getUsedPOs(leaf, parameters, rdbAdapt, evalMD);
            Expression updateExpression = (Expression)evalMD.getAnnotations().get(EvaluationMetaData.ANNOTATION_UPDATE_EXPRESSION);
            if (updateExpression == null) {
                throw new EvaluationException("Impossible to perform an update without update Expression (no annotation found)");
            }
            PreparedStatement ps = null;
            RdbQueryLeaf rdbQueryLeaf = leaf;
            synchronized (rdbQueryLeaf) {
                try {
                    sqlUpdate = leaf.getSqlUpdate(parameters, updateExpression);
                }
                catch (Exception e) {
                    throw new EvaluationException(e);
                }
            }
            try {
                ps = conn.prepareStatement(sqlUpdate);
                if (usedParameters != null) {
                    this.assignParameter(ps, usedParameters, rdbAdapt);
                }
            }
            catch (Exception e) {
                throw new EvaluationException(e);
            }
            if (this.debug) {
                log.log(BasicLevel.DEBUG, (Object)("Evaluate the query: " + sqlUpdate));
            }
            res = 0;
            res = ps.executeUpdate();
            Object var16_18 = null;
            try {
                ps.close();
            }
            catch (SQLException e) {
                log.log(BasicLevel.WARN, (Object)"impossible to close the PreparedStatement", (Throwable)e);
            }
            break block18;
            {
                catch (Exception mexp) {
                    throw new EvaluationException(mexp);
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.log(BasicLevel.WARN, (Object)"impossible to close the PreparedStatement", (Throwable)e);
                }
                throw throwable;
            }
        }
        return res;
    }
}

