/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.EvaluationException;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.datasource.api.WrapperFactory;
import org.objectweb.medor.datasource.lib.MedorWrapperFactory;
import org.objectweb.medor.eval.api.QueryEvaluator;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.lib.BasicField;
import org.objectweb.medor.lib.BasicTupleStructure;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.ExplicitTupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;

public abstract class AbstractQueryEvaluator
implements QueryEvaluator {
    protected QueryTree query;
    protected WrapperFactory wrapperFactory;

    public AbstractQueryEvaluator(QueryTree query) throws EvaluationException {
        this.query = query;
        this.wrapperFactory = new MedorWrapperFactory();
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    public QueryTree getQueryTree() {
        return this.query;
    }

    public static TupleCollection getMemoryTupleCollection(VariableOperand[] values) throws MedorException {
        Field[] fs = new Field[values.length];
        for (int i = 0; i < values.length; ++i) {
            fs[i] = new BasicField("field_" + i, values[i].getType());
        }
        ExplicitTupleCollection tc = new ExplicitTupleCollection(new BasicTupleStructure(fs));
        tc.insertTuple(new MemoryTuple(values));
        return tc;
    }
}

