/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.util.Map;
import java.util.regex.Pattern;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;

public class Like
extends BasicOperator
implements Operator {
    private static final long serialVersionUID = 7364254448772319728L;
    boolean not = false;
    private Pattern pattern = null;

    public Like() {
    }

    public Like(Expression str, Expression pattern, Expression escape) {
        super(new Expression[]{str, pattern, escape});
    }

    public Like(Expression str, Expression pattern, Expression escape, boolean not) {
        super(new Expression[]{str, pattern, escape});
        this.not = not;
    }

    public Like(Expression str, Expression pattern) {
        super(new Expression[]{str, pattern});
    }

    public Like(Expression str, Expression pattern, boolean not) {
        super(new Expression[]{str, pattern});
        this.not = not;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((Like)clone).not = this.not;
        ((Like)clone).pattern = this.pattern;
        return clone;
    }

    public String getOperatorString() {
        return this.not ? "NOT LIKE" : "LIKE";
    }

    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        this.compileOperands();
        if (!this.verified) {
            this.checkOperands(new PType[][]{{PTypeSpace.STRING, PTypeSpace.STRING}, {PTypeSpace.STRING, PTypeSpace.STRING, PTypeSpace.STRING}});
            this.verified = true;
        }
        if (this.result != null) {
            this.result = new BasicVariableOperand(PTypeSpace.BOOLEAN);
        }
        if (this.expressions[1] instanceof Operand && !(this.expressions[1] instanceof VariableOperand)) {
            try {
                this.pattern = Pattern.compile(((Operand)this.expressions[1]).getString());
            }
            catch (TypingException e) {
                throw new ExpressionException(e);
            }
        }
        return this.result;
    }

    public Operand evaluate(ParameterOperand[] values, Object o) throws ExpressionException {
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(this.expressions[1].evaluate(values, o).getString());
            }
            catch (TypingException e) {
                throw new ExpressionException(e);
            }
        }
        boolean eval = this.pattern.matcher(this.expressions[0].evaluate(values, o).getString()).matches();
        this.result.setValue(this.not ^ eval);
        return this.result;
    }
}

