/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.rdb.lib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.JoinedTable;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.QueryLeafException;
import org.objectweb.medor.datasource.api.DataStore;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.filter.api.AggregateOperator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.Count;
import org.objectweb.medor.filter.lib.ExpressionPrinter;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.OrderField;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.rdb.api.QualifiedTable;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.medor.query.rdb.lib.BasicRdbExpField;
import org.objectweb.medor.query.rdb.lib.BasicRdbQueryLeaf;
import org.objectweb.medor.query.rdb.lib.MedorExpression2WhereClause;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicRdbExpQueryLeaf
extends BasicRdbQueryLeaf
implements RdbExpQueryLeaf {
    private static final long serialVersionUID = -6290236340505461978L;
    private static final RdbAdapter BASIC = new BasicRdbAdapter();
    private boolean noGroupBy = false;
    QualifiedTable[] from;
    private ArrayList groupByFields = new ArrayList();
    String rdbAdapterName = null;
    RdbAdapter rdbAdapter = BASIC;
    List rootJoinedTables;
    boolean canReuseSQL = false;

    public BasicRdbExpQueryLeaf() {
    }

    public BasicRdbExpQueryLeaf(DataStore ds, String nodeName) {
        super(nodeName, ds);
    }

    public BasicRdbExpQueryLeaf(DataStore ds, QualifiedTable[] from, String nodeName) throws QueryLeafException {
        this(ds, nodeName);
        this.from = from;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        int i;
        clone = super.clone(clone, obj2clone);
        BasicRdbExpQueryLeaf ql = (BasicRdbExpQueryLeaf)clone;
        if (this.from != null) {
            ql.from = new QualifiedTable[this.from.length];
            for (i = 0; i < this.from.length; ++i) {
                ql.from[i] = (QualifiedTable)BasicRdbExpQueryLeaf.getClone(this.from[i], obj2clone);
            }
        }
        if (this.groupByFields != null) {
            ql.groupByFields = new ArrayList();
            for (i = 0; i < this.groupByFields.size(); ++i) {
                RdbExpField gb = (RdbExpField)this.groupByFields.get(i);
                if (gb == null) {
                    ql.groupByFields.add(null);
                    continue;
                }
                ql.groupByFields.add(gb.clone(null, obj2clone));
            }
        }
        ql.rdbAdapterName = this.rdbAdapterName;
        ql.rdbAdapter = this.rdbAdapter;
        if (this.rootJoinedTables != null) {
            ql.rootJoinedTables = new ArrayList();
            for (i = 0; i < this.rootJoinedTables.size(); ++i) {
                JoinedTable jt = (JoinedTable)this.rootJoinedTables.get(i);
                if (jt == null) {
                    ql.rootJoinedTables.add(null);
                    continue;
                }
                ql.rootJoinedTables.add(jt.clone(null, obj2clone));
            }
        }
        return clone;
    }

    public void setRdbAdapterName(String an) {
        this.logger.log(BasicLevel.DEBUG, (Object)("Setting rdbAdapterName to " + an));
        this.rdbAdapterName = an;
    }

    public String getRdbAdapterName() {
        return this.rdbAdapterName;
    }

    public void setRdbAdapter(RdbAdapter adapter) {
        this.logger.log(BasicLevel.DEBUG, (Object)("Setting rdbAdapter to " + adapter));
        this.rdbAdapter = adapter;
    }

    public RdbAdapter getRdbAdapter() {
        return this.rdbAdapter;
    }

    public void setRootJoinedTables(List rootjts) {
        this.rootJoinedTables = rootjts;
    }

    public RdbExpField addRdbField(String name, PType type, String colName, QualifiedTable table) throws QueryLeafException {
        int i;
        QualifiedTable[] qts = this.getQualifiedTables();
        for (i = 0; i < qts.length && table != qts[i]; ++i) {
        }
        if (i == qts.length) {
            throw new QueryLeafException("The parameter QualifiedTable is not a QualifiedTable of the current RdbExpQueryLeaf");
        }
        BasicRdbExpField f = new BasicRdbExpField(name, type, colName, table, this);
        this.name2field.put(f.getName(), f);
        this.fields.add(f);
        return f;
    }

    public void addQualifiedTable(QualifiedTable qt) {
        if (this.from == null) {
            this.from = new QualifiedTable[]{qt};
        } else {
            QualifiedTable[] qts = new QualifiedTable[this.from.length + 1];
            System.arraycopy(this.from, 0, qts, 0, this.from.length);
            qts[this.from.length] = qt;
            this.from = qts;
        }
    }

    public void removeQualifiedTable(QualifiedTable qt) throws MedorException {
        if (this.from == null) {
            throw new MedorException("QualifiedTable " + qt + " is not in leaf " + this);
        }
        for (int i = 0; i < this.from.length; ++i) {
            if (this.from[i] != qt) continue;
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Found table " + qt.getTableName()));
            }
            QualifiedTable[] qts = new QualifiedTable[this.from.length - 1];
            System.arraycopy(this.from, 0, qts, 0, i);
            System.arraycopy(this.from, i + 1, qts, i, this.from.length - i - 1);
            this.from = qts;
            return;
        }
        throw new MedorException("QualifiedTable " + qt + " is not in leaf " + this);
    }

    public boolean containsQualifiedTable(QualifiedTable qt) {
        if (this.from == null) {
            return false;
        }
        for (int i = 0; i < this.from.length; ++i) {
            if (this.from[i] != qt) continue;
            return true;
        }
        return false;
    }

    public RdbExpField addRdbField(RdbExpField rdbField) throws QueryLeafException {
        rdbField.setQueryLeaf(this);
        this.name2field.put(rdbField.getName(), rdbField);
        this.fields.add(rdbField);
        return rdbField;
    }

    public void removeRdbField(RdbExpField rdbField) throws QueryLeafException {
        this.name2field.remove(rdbField.getName());
        this.fields.remove(rdbField);
    }

    public void resetSqlRequest() {
        this.noGroupBy = false;
        this.query = null;
    }

    public String getSqlRequest(ParameterOperand[] pos, boolean rangeStartAt, boolean rangeSize) throws MedorException, ExpressionException {
        return this.getSqlRequest(pos, null, rangeStartAt, rangeSize);
    }

    public String getSqlDelete(ParameterOperand[] pos) throws MedorException, ExpressionException {
        boolean debug;
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Entering getSqlRequest for " + this));
        }
        if (this.canReuseSQL && this.query != null) {
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Delete query already computed " + this.query));
            }
            return this.deleteQuery;
        }
        QualifiedTable t = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" WHERE ");
        Iterator fieldsIt = this.fields.iterator();
        while (fieldsIt.hasNext()) {
            RdbExpField f = (RdbExpField)fieldsIt.next();
            if (t == null) {
                t = f.getTable();
            } else if (t != f.getTable()) {
                throw new MedorException("Impossible to delete on tables");
            }
            String fn = f.getName();
            int idx = fn.lastIndexOf(46);
            if (idx != -1) {
                fn = fn.substring(idx + 1);
            }
            sb.append(fn);
            if (!fieldsIt.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" IN (").append(this.getSqlRequest(pos, false, false)).append(")");
        if (t == null) {
            throw new MedorException("Impossible to delete without table");
        }
        sb.insert(0, t.getTableName()).insert(0, "DELETE FROM ");
        this.deleteQuery = sb.toString();
        if (!this.canReuseSQL) {
            this.computeCanReuseSQL(pos);
        }
        return this.deleteQuery;
    }

    public String getSqlUpdate(ParameterOperand[] pos, Expression updateExpression) {
        return null;
    }

    public String getSqlRequest(ParameterOperand[] pos, ArrayList selectFields, boolean rangeStart, boolean rangeSize) throws MedorException, ExpressionException {
        String from;
        String where;
        boolean debug;
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Entering getSqlRequest for " + this));
        }
        if (selectFields == null) {
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Setting selectFields (was null) to local fields");
            }
            selectFields = this.fields;
        }
        String string = where = this.sqlFilter == null ? "" : this.parseExpression(this.sqlFilter, pos);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("WHERE clause for " + this + " : " + where));
        }
        ArrayList<QueryTreeField> allSelected = new ArrayList<QueryTreeField>();
        allSelected.addAll(selectFields);
        OrderField[] odfs = this.getOrderBy();
        if (this.getDistinct() && odfs != null) {
            for (int i = 0; i < odfs.length; ++i) {
                QueryTreeField orderField = odfs[i].getField();
                if (allSelected.contains(orderField)) continue;
                allSelected.add(orderField);
            }
        }
        if (this.rootJoinedTables != null && this.rootJoinedTables.size() > 0) {
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Query with rootJoinedTables (adapter is " + this.rdbAdapterName + " - " + this.rdbAdapter + ")"));
            }
            from = this.rdbAdapter.getFromClause(this.rootJoinedTables);
        } else {
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Query without rootJoinedTables (adapter is " + this.rdbAdapterName + " - " + this.rdbAdapter + ")"));
            }
            from = this.getFromList();
        }
        String orderBy = this.getOrderByClause();
        String groupBy = this.groupByFields.isEmpty() ? null : this.getGroupByString();
        this.query = this.rdbAdapter.getQuery(this.getSelectList("", allSelected, true), from, where, orderBy, groupBy, rangeStart, rangeSize);
        if (orderBy != null) {
            this.query = this.rdbAdapter.handleOrderBy(this.query);
        }
        if (!this.canReuseSQL) {
            this.computeCanReuseSQL(pos);
        }
        return this.query;
    }

    private boolean computeCanReuseSQL(ParameterOperand[] pos) {
        this.canReuseSQL = true;
        if (pos != null) {
            for (int i = 0; i < pos.length && this.canReuseSQL; ++i) {
                PType paramType = pos[i].getType();
                this.canReuseSQL = !MedorExpression2WhereClause.isJavaObject(paramType);
            }
        }
        return this.canReuseSQL;
    }

    private String getOrderByClause() {
        OrderField[] orderByFields = this.getOrderBy();
        if (orderByFields == null || orderByFields.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (int cpt = 0; cpt < orderByFields.length; ++cpt) {
            sb.append(sep);
            sep = ", ";
            sb.append(BasicRdbExpQueryLeaf.getQualifiedFieldName((RdbExpField)orderByFields[cpt].getField()));
            sb.append(orderByFields[cpt].getDesc() ? " DESC" : " ASC");
        }
        return sb.toString();
    }

    private String getGroupByString() {
        String groupBy = "";
        for (int i = 0; i < this.groupByFields.size(); ++i) {
            groupBy = groupBy + BasicRdbExpQueryLeaf.getQualifiedFieldName((RdbExpField)this.groupByFields.get(i));
            if (i >= this.groupByFields.size() - 1) continue;
            groupBy = groupBy + ", ";
        }
        return groupBy;
    }

    public void setQueryFilter(Expression exp) {
        this.sqlFilter = exp;
    }

    public Expression getQueryFilter() {
        return this.sqlFilter;
    }

    public QualifiedTable[] getQualifiedTables() {
        return this.from;
    }

    public void addGroupBy(RdbExpField groupBy) throws QueryLeafException {
        if (!this.fields.contains(groupBy)) {
            throw new QueryLeafException("GroupBy error: RdbExpField " + groupBy.getName() + " does not exist in the TupleStructure of RdbQueryLeaf " + this);
        }
        this.groupByFields.add(groupBy);
    }

    public RdbExpField[] getGroupByFields() {
        return this.groupByFields.toArray(new RdbExpField[this.groupByFields.size()]);
    }

    public void setNoGroupBy(boolean noGB) {
        this.noGroupBy = noGB;
    }

    public String getGroupBy() {
        return this.getGroupBy(null);
    }

    public String getGroupBy(String fromAlias) {
        if (this.groupByFields.size() != 0) {
            StringBuffer querySB = new StringBuffer();
            querySB.append(" GROUP BY ");
            for (int i = 0; i < this.groupByFields.size(); ++i) {
                querySB.append(BasicRdbExpQueryLeaf.getQualifiedFieldName((RdbExpField)this.groupByFields.get(i), fromAlias));
                if (i >= this.groupByFields.size() - 1) continue;
                querySB.append(", ");
            }
            return querySB.toString();
        }
        return "";
    }

    public String getSelectList(String selectList, ArrayList selectFields, boolean qualified) {
        this.logger.log(BasicLevel.DEBUG, (Object)"Computing select list");
        selectList = selectList + (this.getDistinct() ? "DISTINCT " : "");
        for (int i = 0; i < selectFields.size(); ++i) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Select field " + selectFields.get(i) + " of node " + ((QueryTreeField)selectFields.get(i)).getQueryTree()));
            if (selectFields.get(i) instanceof RdbExpField) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Found RdbExpField " + selectFields.get(i)));
                selectList = qualified ? selectList + BasicRdbExpQueryLeaf.getQualifiedFieldName((RdbExpField)selectFields.get(i)) : selectList + ((RdbExpField)selectFields.get(i)).getColumnName();
            } else {
                this.logger.log(BasicLevel.DEBUG, (Object)("Found CalculatedField " + selectFields.get(i)));
                AggregateOperator op = (AggregateOperator)((CalculatedField)selectFields.get(i)).getExpression();
                selectList = selectList + op.getOperatorString();
                selectList = selectList + "(";
                if (op.getDistinct()) {
                    selectList = selectList + "DISTINCT ";
                }
                if (op instanceof Count && ((Count)op).countAll()) {
                    selectList = selectList + "*";
                } else {
                    RdbExpField theField = (RdbExpField)((FieldOperand)op.getExpression(0)).getField();
                    selectList = qualified ? selectList + BasicRdbExpQueryLeaf.getQualifiedFieldName(theField) : selectList + theField.getColumnName();
                }
                selectList = selectList + ")";
            }
            if (i >= selectFields.size() - 1) continue;
            selectList = selectList + ", ";
        }
        return selectList;
    }

    public static String getQualifiedFieldName(RdbExpField field) {
        return BasicRdbExpQueryLeaf.getQualifiedFieldName(field, null);
    }

    public static String getQualifiedFieldName(RdbExpField field, String fromAlias) {
        String prefix = null;
        prefix = fromAlias != null ? fromAlias : (field.getTable().getAliasName() == null ? field.getTable().getTableName() : field.getTable().getAliasName());
        return prefix + "." + field.getColumnName();
    }

    protected String getFromList() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.from.length; ++i) {
            sb.append(this.from[i].getTableName());
            if (this.from[i].getAliasName() != null) {
                if (this.rdbAdapter != null) {
                    this.rdbAdapter.writeTableAlias(this.from[i].getAliasName(), sb);
                } else {
                    sb.append(" as ");
                    sb.append(this.from[i].getAliasName());
                }
            }
            if (i >= this.from.length - 1) continue;
            sb.append(", ");
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("FROM clause: " + sb.toString()));
        return sb.toString();
    }

    private String parseExpression(Expression exp, ParameterOperand[] pos) throws ExpressionException {
        this.logger.log(BasicLevel.DEBUG, (Object)("Parsing " + ExpressionPrinter.e2str(exp)));
        return MedorExpression2WhereClause.e2where(exp, this.rdbAdapter, this, pos);
    }
}

