/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.distributed.globallock.lib;

import org.objectweb.perseus.concurrency.distributed.globallock.api.GlobalLockWaiter;

public class GlobalLockWaiterImpl
implements GlobalLockWaiter {
    static final boolean trace = false;
    private byte lck;
    private Handled handled = new Handled();
    GlobalLockWaiterImpl waitFor;

    GlobalLockWaiterImpl(byte lck) {
        this.lck = lck;
    }

    public void waitHandled(long timeout) throws InterruptedException {
        this.handled.waitHandled(timeout);
    }

    public void signalHandled() {
        this.handled.signalHandled();
    }

    public synchronized boolean waitLock(long timeout) throws InterruptedException {
        if (this.lck != 0) {
            this.wait(timeout);
            if (this.waitFor != null) {
                this.waitFor.waitHandled(timeout);
            }
            if (this.lck != 0) {
                this.lck = 0;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean signalLock(byte signaledLck, GlobalLockWaiterImpl waitFor) {
        if (signaledLck >= this.lck) {
            this.lck = 0;
            this.waitFor = waitFor;
            this.notifyAll();
            return true;
        }
        return false;
    }

    public byte getLockLevel() {
        return this.lck;
    }

    private class Handled {
        boolean ok = false;

        private Handled() {
        }

        public synchronized void waitHandled(long timeout) throws InterruptedException {
            while (!this.ok) {
                this.wait(timeout);
            }
        }

        public synchronized void signalHandled() {
            this.ok = true;
            this.notify();
        }
    }
}

