/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.pessimistic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.api.RolledBackConcurrencyException;
import org.objectweb.perseus.concurrency.lib.LockValue;
import org.objectweb.perseus.concurrency.lib.ReadWriteLockValue;
import org.objectweb.perseus.concurrency.lib.Semaphore;
import org.objectweb.perseus.concurrency.pessimistic.Lock;
import org.objectweb.perseus.concurrency.pessimistic.LockRequest;
import org.objectweb.perseus.dependency.api.DependencyGraph;
import org.objectweb.util.monolog.api.BasicLevel;

public final class RWFifoLock
extends Lock {
    protected static final LockValue LOCKS = new ReadWriteLockValue();
    List owners = new ArrayList();
    List waiters = new ArrayList();
    byte lockLevel = 0;
    protected final Semaphore semaphore = new Semaphore();

    public RWFifoLock() {
    }

    public RWFifoLock(Object hints, DependencyGraph dg) {
        super(hints, dg);
    }

    private final boolean acceptLockRequest(Object task, byte askedLock, int waiterIdx) {
        if (this.owners.isEmpty()) {
            return true;
        }
        if (this.owners.contains(task)) {
            if (LOCKS.isCompatibleWith(askedLock, this.lockLevel)) {
                return waiterIdx == 0;
            }
            if (this.owners.size() == 1) {
                return true;
            }
        } else if (LOCKS.isCompatibleWith(askedLock, this.lockLevel) && waiterIdx == 0) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void accessIntention(Object task, byte askedLock) throws RolledBackConcurrencyException {
        try {
            ArrayList<Object> dependencies;
            boolean debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
            this.semaphore.P();
            int ws = this.waiters.size();
            --this.reservations;
            if (this.acceptLockRequest(task, askedLock, ws)) {
                if (debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)(LOCKS.str(askedLock) + " lock accepted directly," + "\n\ttask:" + task + "\n\towners=" + this.owners));
                }
                this.lockLevel = (byte)Math.max(this.lockLevel, askedLock);
                if (!this.owners.contains(task)) {
                    this.owners.add(task);
                }
                this.semaphore.V();
                return;
            }
            if (ws == 0) {
                dependencies = this.owners;
            } else {
                int i;
                LockRequest tmp = null;
                for (i = ws - 1; i >= 0 && LOCKS.isCompatibleWith(askedLock, (tmp = (LockRequest)this.waiters.get(i)).getLockLevel()); --i) {
                }
                if (i >= 0) {
                    dependencies = new ArrayList<Object>();
                    byte l = tmp.getLockLevel();
                    do {
                        tmp = (LockRequest)this.waiters.get(i);
                        dependencies.add(tmp.task);
                    } while (LOCKS.isCompatibleWith(tmp.getLockLevel(), l) && --i >= 0);
                } else {
                    dependencies = this.owners;
                }
            }
            if (this.dg.addVertexes(task, (List)dependencies) != -1) {
                if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
                    this.logger.log(BasicLevel.INFO, (Object)(LOCKS.str(askedLock) + " request: dead lock detected, cancel the task," + "\n\ttask:" + task));
                }
                this.dg.removeVertexes(task, dependencies);
                this.semaphore.V();
                throw new RolledBackConcurrencyException("Deadlock");
            }
            if (debug) {
                // empty if block
            }
            LockRequest lockRequest = new LockRequest(askedLock, task);
            this.waiters.add(lockRequest);
            if (debug) {
                StringBuffer sb = new StringBuffer();
                sb.append(LOCKS.str(lockRequest.getLockLevel()));
                sb.append(" lock waiting, rank=");
                sb.append(this.waiters.indexOf(lockRequest));
                sb.append(", task=");
                sb.append(task);
                sb.append("\n\towners=");
                sb.append(this.owners);
                this.printDG(sb);
                this.logger.log(BasicLevel.DEBUG, (Object)sb.toString());
            }
            try {
                LockRequest sb = lockRequest;
                synchronized (sb) {
                    this.semaphore.V();
                    lockRequest.wait();
                }
                if (lockRequest.hasRolledBack()) {
                    this.forgetWaiter(lockRequest);
                    throw new RolledBackConcurrencyException("The working set has been rolled back by another thread");
                }
            }
            catch (InterruptedException e) {
                this.forgetWaiter(lockRequest);
                throw new RolledBackConcurrencyException("Waiting of a " + LOCKS.str(lockRequest.getLockLevel()) + " intention has been interupted:", e);
            }
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)(LOCKS.str(lockRequest.getLockLevel()) + " Wake up\n\ttask:" + task));
            }
        }
        catch (Error t) {
            this.logger.log(BasicLevel.ERROR, (Object)("accessIntention: " + t.getMessage()), (Throwable)t);
            t.printStackTrace();
        }
    }

    private final void forgetWaiter(LockRequest lr) {
        int i;
        boolean debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        this.semaphore.P();
        int idx = this.waiters.indexOf(lr);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("forgetLockRequest: lock: " + LOCKS.str(lr.getLockLevel()) + ", waiter rank=" + idx + "/" + this.waiters.size() + ", task=" + lr.task));
        }
        if (idx == -1 || this.waiters.size() == 0) {
            this.semaphore.V();
            return;
        }
        this.waiters.remove(idx);
        LockRequest tmp = null;
        for (i = idx - 1; i >= 0; --i) {
            tmp = (LockRequest)this.waiters.get(i);
            if (!LOCKS.isCompatibleWith(lr.getLockLevel(), tmp.getLockLevel())) break;
        }
        if (i >= 0) {
            byte l = tmp.getLockLevel();
            do {
                tmp = (LockRequest)this.waiters.get(i);
                this.dg.removeVertex(lr.task, tmp.task);
            } while (LOCKS.isCompatibleWith(tmp.getLockLevel(), l) && --i >= 0);
        } else {
            this.dg.removeVertexes(lr.task, this.owners);
        }
        int ws = this.waiters.size();
        for (i = idx; i < ws && LOCKS.isCompatibleWith((tmp = (LockRequest)this.waiters.get(i)).getLockLevel(), lr.getLockLevel()); ++i) {
        }
        if (i < ws) {
            byte l = tmp.getLockLevel();
            do {
                tmp = (LockRequest)this.waiters.get(i);
                this.dg.removeVertex(tmp.task, lr.task);
            } while (LOCKS.isCompatibleWith(tmp.getLockLevel(), l) && ++i < ws);
        }
        this.semaphore.V();
    }

    public void readIntention(Object task) throws ConcurrencyException {
        this.accessIntention(task, (byte)1);
    }

    public void writeIntention(Object task) throws ConcurrencyException {
        this.accessIntention(task, (byte)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(Object task) {
        LockRequest lr;
        this.semaphore.P();
        boolean isowner = this.owners.remove(task);
        if (isowner) {
            byte tmpLock = 0;
            for (int i = 0; i < this.waiters.size(); ++i) {
                LockRequest lr2 = (LockRequest)this.waiters.get(i);
                this.dg.removeVertex(lr2.task, task);
                if (!LOCKS.isCompatibleWith(lr2.getLockLevel(), tmpLock)) break;
                tmpLock = (byte)Math.max(lr2.getLockLevel(), tmpLock);
            }
            if (this.owners.isEmpty()) {
                this.lockLevel = 0;
            }
        }
        int nbNotified = 0;
        while (!this.waiters.isEmpty() && this.acceptLockRequest(lr.task, (lr = (LockRequest)this.waiters.get(0)).getLockLevel(), 0)) {
            this.waiters.remove(0);
            this.dg.removeVertexes(lr.task, this.owners);
            if (!this.owners.contains(lr.task)) {
                this.owners.add(lr.task);
            }
            this.lockLevel = (byte)Math.max(lr.getLockLevel(), this.lockLevel);
            LockRequest lockRequest = lr;
            synchronized (lockRequest) {
                lr.notify();
            }
            ++nbNotified;
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            StringBuffer sb = new StringBuffer();
            if (isowner) {
                sb.append("task closed: ");
            } else {
                sb.append("task closed without lock: ");
            }
            sb.append(task);
            sb.append(" / new notified: ");
            sb.append(nbNotified);
            sb.append(" / reservations:");
            sb.append(this.reservations);
            sb.append(" / current lock: ");
            sb.append(LOCKS.str(this.lockLevel));
            sb.append("\n\towners:");
            sb.append(this.owners);
            sb.append("\n\twaiters:");
            sb.append(this.waiters);
            this.printDG(sb);
            this.logger.log(BasicLevel.DEBUG, (Object)sb.toString());
        }
        try {
            boolean bl = this.reservations == 0 && this.owners.isEmpty();
            this.semaphore.V();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.semaphore.V();
                throw throwable;
            }
            catch (Error t) {
                this.logger.log(BasicLevel.ERROR, (Object)("close: " + t.getMessage()), (Throwable)t);
                t.printStackTrace();
                return false;
            }
        }
    }

    public synchronized byte getMax() {
        return this.lockLevel;
    }

    private void printDG(StringBuffer sb) {
        Map m = this.dg.getVertexes();
        if (m.size() > 0) {
            int ws = this.waiters.size();
            sb.append("\ndependency Graph: ");
            ArrayList waiters = new ArrayList(m.keySet());
            HashSet s = new HashSet(waiters.size() * 2);
            s.addAll(m.keySet());
            Iterator it = m.values().iterator();
            while (it.hasNext()) {
                s.addAll((Collection)it.next());
            }
            ArrayList all = new ArrayList(s);
            for (int i = 0; i < all.size(); ++i) {
                Object t1 = all.get(i);
                int t1Idx = all.indexOf(t1);
                Collection dependencies = (Collection)m.get(t1);
                if (dependencies == null) continue;
                Iterator it2 = dependencies.iterator();
                while (it2.hasNext()) {
                    sb.append("\nws");
                    sb.append(t1Idx);
                    sb.append(" ");
                    sb.append(t1);
                    sb.append(" = > ");
                    sb.append("ws");
                    Object t2 = it2.next();
                    sb.append(all.indexOf(t2));
                    sb.append(" ");
                    sb.append(t2);
                }
            }
        }
    }
}

