/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(AbsDeployer.class);
    protected Map<URL, IDeployable<?>> deployedDeployables = new HashMap();

    public abstract void doDeploy(IDeployable<?> var1) throws DeployerException;

    public abstract void doUndeploy(IDeployable<?> var1) throws DeployerException;

    public abstract boolean supports(IDeployable<?> var1);

    public void deploy(final IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        RunnableHelper runner = new RunnableHelper();
        ExecutionResult res = runner.execute(this.getClass().getClassLoader(), (IExecution)new IExecution<Void>(){

            public Void execute() throws Exception {
                AbsDeployer.this.doDeploy(deployable);
                return null;
            }
        });
        res.getResult();
        if (res.hasException()) {
            if (res.getException() instanceof DeployerException) {
                throw (DeployerException)((Object)res.getException());
            }
            throw new DeployerException("Unable to deploy deployable '" + deployable + "'", (Throwable)res.getException());
        }
        this.deployedDeployables.put(this.getURL(deployable), deployable);
    }

    public void undeploy(final IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        RunnableHelper runner = new RunnableHelper();
        ExecutionResult res = runner.execute(this.getClass().getClassLoader(), (IExecution)new IExecution<Void>(){

            public Void execute() throws Exception {
                AbsDeployer.this.doUndeploy(deployable);
                return null;
            }
        });
        res.getResult();
        if (res.hasException()) {
            if (res.getException() instanceof DeployerException) {
                throw (DeployerException)((Object)res.getException());
            }
            throw new DeployerException("Unable to undeploy deployable '" + deployable + "'", (Throwable)res.getException());
        }
        this.deployedDeployables.remove(this.getURL(deployable));
    }

    public void stop() {
        for (IDeployable<?> deployable : new ArrayList(this.deployedDeployables.values())) {
            try {
                this.undeploy(deployable);
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot undeploy the deployable ''{0}''", new Object[]{deployable, e});
            }
        }
    }

    protected URL getURL(IDeployable<?> deployable) throws DeployerException {
        URL url = null;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from deployable '" + deployable + "'.", (Throwable)e);
        }
        return url;
    }

    protected File getFile(IDeployable<?> deployable) throws DeployerException {
        return URLUtils.urlToFile((URL)this.getURL(deployable));
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        return this.deployedDeployables.containsKey(this.getURL(deployable));
    }

    public Map<URL, IDeployable<?>> getDeployedDeployables() {
        return this.deployedDeployables;
    }

    protected void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }
}

