/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.wrapper.common.OutputStreamSwitcher;

public class ConsoleHandler
extends Handler {
    protected OutputStreamSwitcher oss;
    private Writer writer;

    public void desactivateSwitching(OutputStream newOut) {
        if (this.oss != null) {
            this.oss = null;
            this.setOutput(newOut);
        }
    }

    public void activateSwitching() {
        if (this.oss == null) {
            this.oss = new OutputStreamSwitcher();
            this.setOutput(this.oss);
        }
    }

    public void setOutput(OutputStream out) throws SecurityException {
        if (out == null) {
            throw new NullPointerException();
        }
        this.flush();
        String encoding = this.getEncoding();
        if (encoding == null) {
            this.writer = new OutputStreamWriter(out);
        } else {
            try {
                this.writer = new OutputStreamWriter(out, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error("Unexpected exception " + ex);
            }
        }
    }

    public void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        if (this.oss != null) {
            if (record.getLevel().intValue() >= BasicLevel.WARN) {
                this.oss.switchOutput(System.err);
            } else {
                this.oss.switchOutput(System.out);
            }
        }
        try {
            this.writer.write(msg);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
        this.flush();
    }

    public void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 2);
            }
        }
    }

    public void close() throws SecurityException {
        this.flush();
    }
}

