/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.DestinationImplMBean;
import org.objectweb.joram.mom.notifications.AdminReplyNot;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.GetRightsReplyNot;
import org.objectweb.joram.mom.notifications.GetRightsRequestNot;
import org.objectweb.joram.mom.notifications.RequestGroupNot;
import org.objectweb.joram.mom.notifications.SpecialAdminRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.proxies.SendRepliesNot;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.DeleteDestination;
import org.objectweb.joram.shared.admin.GetStatsReply;
import org.objectweb.joram.shared.admin.GetStatsRequest;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetReader;
import org.objectweb.joram.shared.admin.SetRight;
import org.objectweb.joram.shared.admin.SetWriter;
import org.objectweb.joram.shared.admin.UnsetReader;
import org.objectweb.joram.shared.admin.UnsetWriter;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class DestinationImpl
implements Serializable,
DestinationImplMBean {
    public static Logger logger = Debug.getLogger((String)DestinationImpl.class.getName());
    public static final String WAKEUP_PERIOD = "period";
    private boolean deletable = false;
    private long period = -1L;
    private AgentId adminId;
    protected transient Destination agent;
    protected boolean freeReading = false;
    protected boolean freeWriting = false;
    protected Hashtable clients;
    public static int READ = 1;
    public static int WRITE = 2;
    public static int READWRITE = 3;
    protected AgentId dmqId = null;
    transient StringBuffer strbuf;
    public long creationDate = -1L;
    protected long nbMsgsReceiveSinceCreation = 0L;
    protected long nbMsgsDeliverSinceCreation = 0L;
    protected long nbMsgsSentToDMQSinceCreation = 0L;
    public static String[] _rights = new String[]{":R;", ";W;", ":RW;"};

    public final AgentId getId() {
        return this.agent == null ? AgentId.nullId : this.agent.getId();
    }

    public final String getName() {
        return this.agent == null ? null : this.agent.getName();
    }

    public DestinationImpl(AgentId adminId, Properties prop) {
        this.adminId = adminId;
        this.clients = new Hashtable();
        this.strbuf = new StringBuffer();
        if (this.creationDate == -1L) {
            this.creationDate = System.currentTimeMillis();
        }
        try {
            if (prop != null) {
                this.period = ConversionHelper.toLong((Object)prop.get(WAKEUP_PERIOD));
            }
        }
        catch (MessageValueException e) {
            this.period = -1L;
        }
        catch (NumberFormatException e) {
            this.period = -1L;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ", created."));
        }
    }

    void setNoSave() {
        if (this.agent != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + ".setNoSave()."));
            }
            this.agent.setNoSave();
        }
    }

    void setSave() {
        if (this.agent != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + ".setSave()."));
            }
            this.agent.setSave();
        }
    }

    public abstract void initialize(boolean var1);

    public void setAgent(Destination agent) {
        this.setSave();
        this.agent = agent;
    }

    protected boolean isLocal(AgentId id) {
        return this.getId().getTo() == id.getTo();
    }

    public final boolean canBeDeleted() {
        return this.deletable;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        if (this.period != period) {
            WakeUpNot not = new WakeUpNot();
            not.update = true;
            this.forward(this.getId(), not);
            this.period = period;
        }
    }

    public abstract void wakeUpNot(WakeUpNot var1);

    public void setRight(SetRight request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        AgentId user = null;
        if (request.getUserProxId() != null) {
            user = AgentId.fromString((String)request.getUserProxId());
        }
        int right = 0;
        if (request instanceof SetReader) {
            right = READ;
        } else if (request instanceof SetWriter) {
            right = WRITE;
        } else if (request instanceof UnsetReader) {
            right = -READ;
        } else if (request instanceof UnsetWriter) {
            right = -WRITE;
        }
        try {
            this.processSetRight(user, right);
            this.doRightRequest(user, right);
            this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
        }
        catch (RequestException exc) {
            this.strbuf.append("Request [").append(request.getClass().getName());
            this.strbuf.append("], sent to Destination [").append(this.getId());
            this.strbuf.append("], successful [false]: ").append(exc.getMessage());
            this.replyToTopic(new AdminReply(false, this.strbuf.toString()), replyTo, requestMsgId, replyMsgId);
            logger.log(BasicLevel.ERROR, (Object)this.strbuf.toString());
            this.strbuf.setLength(0);
        }
    }

    protected abstract void doRightRequest(AgentId var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processSetRight(AgentId user, int right) throws RequestException {
        this.setSave();
        if (user == null) {
            if (right == READ) {
                this.freeReading = true;
                return;
            } else if (right == WRITE) {
                this.freeWriting = true;
                return;
            } else if (right == -READ) {
                this.freeReading = false;
                return;
            } else {
                if (right != -WRITE) throw new RequestException("Invalid right value: " + right);
                this.freeWriting = false;
            }
            return;
        } else {
            Integer currentRight = (Integer)this.clients.get(user);
            if (right == READ) {
                if (currentRight != null && currentRight == WRITE) {
                    this.clients.put(user, new Integer(READWRITE));
                    return;
                } else {
                    this.clients.put(user, new Integer(READ));
                }
                return;
            } else if (right == WRITE) {
                if (currentRight != null && currentRight == READ) {
                    this.clients.put(user, new Integer(READWRITE));
                    return;
                } else {
                    this.clients.put(user, new Integer(WRITE));
                }
                return;
            } else if (right == -READ) {
                if (currentRight != null && currentRight == READWRITE) {
                    this.clients.put(user, new Integer(WRITE));
                    return;
                } else {
                    if (currentRight == null || currentRight != READ) return;
                    this.clients.remove(user);
                }
                return;
            } else {
                if (right != -WRITE) throw new RequestException("Invalid right value: " + right);
                if (currentRight != null && currentRight == READWRITE) {
                    this.clients.put(user, new Integer(READ));
                    return;
                } else {
                    if (currentRight == null || currentRight != WRITE) return;
                    this.clients.remove(user);
                }
            }
        }
    }

    public void getRights(AgentId from, GetRightsRequestNot not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        Vector<AgentId> readers = new Vector<AgentId>();
        Vector<AgentId> writers = new Vector<AgentId>();
        Enumeration keys = this.clients.keys();
        while (keys.hasMoreElements()) {
            AgentId key = (AgentId)keys.nextElement();
            int right = (Integer)this.clients.get(key);
            if (right == READ || right == READWRITE) {
                readers.add(key);
            }
            if (right != WRITE && right != READWRITE) continue;
            writers.add(key);
        }
        this.forward(from, new GetRightsReplyNot(not, this.freeReading, this.freeWriting, readers, writers));
    }

    public String[] getRights() {
        String[] rigths = new String[this.clients.size()];
        int i = 0;
        Enumeration keys = this.clients.keys();
        while (keys.hasMoreElements()) {
            AgentId key = (AgentId)keys.nextElement();
            int right = (Integer)this.clients.get(key);
            rigths[i++] = key.toString() + _rights[right - 1];
        }
        return rigths;
    }

    public String getRight(String userid) {
        AgentId key = AgentId.fromString((String)userid);
        if (key == null) {
            return userid + ":bad user;";
        }
        Integer right = (Integer)this.clients.get(key);
        if (right == null) {
            return userid + ":unknown;";
        }
        return userid + _rights[right - 1];
    }

    protected boolean isValidJMXAttribute(String attrName) {
        return attrName != null;
    }

    protected final Hashtable getJMXStatistics() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"DestinationImpl.getJMXStatistics()");
        }
        Hashtable<String, Object> stats = null;
        try {
            ObjectName mbeanName = new ObjectName(this.agent.getMBeanName());
            MBeanAttributeInfo[] attributes = MXWrapper.getAttributes((ObjectName)mbeanName);
            if (attributes != null) {
                stats = new Hashtable<String, Object>(attributes.length);
                for (int k = 0; k < attributes.length; ++k) {
                    Object value;
                    String name = attributes[k].getName();
                    if (!this.isValidJMXAttribute(name) || (value = MXWrapper.getAttribute((ObjectName)mbeanName, (String)name)) == null || !(value instanceof String) && !(value instanceof Number)) continue;
                    stats.put(name, value);
                }
            }
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)(" getAttributes  on " + this.agent.getMBeanName() + " error."), (Throwable)exc);
        }
        return stats;
    }

    protected void clientMessages(AgentId from, ClientMessages not) throws AccessException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DestinationImpl.clientMessages(" + from + ',' + (Object)((Object)not) + ')'));
        }
        if (!this.isWriter(from)) {
            DMQManager dmqManager = new DMQManager(not.getDMQId(), this.dmqId, this.getId());
            for (Message msg : not.getMessages()) {
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(msg, (short)1);
                this.handleDeniedMessage(msg.id, AgentId.fromString((String)msg.replyToId));
            }
            dmqManager.sendToDMQ();
            throw new AccessException("WRITE right not granted");
        }
        this.doClientMessages(from, not);
        if (!not.isPersistent() && !not.getAsyncSend()) {
            this.forward(from, new SendReplyNot(not.getClientContext(), not.getRequestId()));
        }
    }

    protected void handleDeniedMessage(String msgId, AgentId replyTo) {
    }

    public void unknownAgent(AgentId from, UnknownAgent not) {
        if (this.isAdministrator(not.agent)) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Admin of dest " + this.getId() + " does not exist anymore."));
            }
        } else if (not.agent.equals((Object)this.dmqId)) {
            this.setSave();
            this.dmqId = null;
        } else {
            this.setSave();
            this.clients.remove(from);
            this.doUnknownAgent(not);
        }
    }

    public void deleteNot(AgentId from, DeleteNot not) {
        if (!this.isAdministrator(from)) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)("Unauthorized deletion request from " + from));
            }
        } else {
            this.doDeleteNot(not);
            this.setSave();
            this.deletable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void specialAdminRequest(AgentId from, SpecialAdminRequest not) {
        Object obj = null;
        this.setSave();
        try {
            if (!this.isAdministrator(from)) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)("Unauthorized SpecialAdminRequest request from " + from));
                }
                throw new RequestException("ADMIN right not granted");
            }
            obj = this.specialAdminProcess(not);
            this.strbuf.append("Request [").append(((Object)((Object)not)).getClass().getName()).append("], sent to Destination [").append(this.getId()).append("], successful [true] ").toString();
            this.forward(from, new AdminReplyNot(not, true, this.strbuf.toString(), obj));
        }
        catch (RequestException exc) {
            this.strbuf.append("Request [").append(((Object)((Object)not)).getClass().getName()).append("], sent to Destination [").append(this.getId()).append("], successful [false]: ").append(exc.getMessage());
            this.forward(from, new AdminReplyNot(not, false, this.strbuf.toString(), obj));
        }
        finally {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)this.strbuf.toString());
            }
            this.strbuf.setLength(0);
        }
    }

    public void requestGroupNot(AgentId from, RequestGroupNot not) {
        Enumeration en = not.getClientMessages();
        ClientMessages theCM = (ClientMessages)((Object)en.nextElement());
        Vector<SendReplyNot> replies = new Vector<SendReplyNot>();
        replies.addElement(new SendReplyNot(theCM.getClientContext(), theCM.getRequestId()));
        while (en.hasMoreElements()) {
            ClientMessages cm = (ClientMessages)((Object)en.nextElement());
            List msgs = cm.getMessages();
            for (int i = 0; i < msgs.size(); ++i) {
                theCM.addMessage((Message)msgs.get(i));
            }
            if (cm.getAsyncSend()) continue;
            replies.addElement(new SendReplyNot(cm.getClientContext(), cm.getRequestId()));
        }
        this.doClientMessages(from, theCM);
        if (!not.isPersistent() && replies.size() > 0) {
            this.forward(from, new SendRepliesNot(replies));
        }
    }

    protected Object specialAdminProcess(SpecialAdminRequest not) throws RequestException {
        return null;
    }

    protected boolean isReader(AgentId client) {
        if (this.isAdministrator(client) || this.freeReading) {
            return true;
        }
        Integer clientRight = (Integer)this.clients.get(client);
        if (clientRight == null) {
            return false;
        }
        return clientRight == READ || clientRight == READWRITE;
    }

    protected boolean isWriter(AgentId client) {
        if (this.isAdministrator(client) || this.freeWriting) {
            return true;
        }
        Integer clientRight = (Integer)this.clients.get(client);
        if (clientRight == null) {
            return false;
        }
        return clientRight == WRITE || clientRight == READWRITE;
    }

    protected boolean isAdministrator(AgentId client) {
        return AdminTopic.isAdminTopicId(client) || client.equals((Object)this.adminId);
    }

    protected abstract void doClientMessages(AgentId var1, ClientMessages var2);

    protected abstract void doUnknownAgent(UnknownAgent var1);

    protected abstract void doDeleteNot(DeleteNot var1);

    public void delete() {
        DeleteDestination request = new DeleteDestination(this.getDestinationId());
        FwdAdminRequestNot deleteNot = new FwdAdminRequestNot((AdminRequest)request, null, null);
        Channel.sendTo((AgentId)AdminTopic.getDefault(), (Notification)deleteNot);
    }

    public ClientMessages preProcess(AgentId from, ClientMessages msgs) {
        return msgs;
    }

    public void postProcess(ClientMessages msgs) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.deletable);
        out.writeObject(this.adminId);
        out.writeBoolean(this.freeReading);
        out.writeBoolean(this.freeWriting);
        out.writeObject(this.clients);
        out.writeObject(this.dmqId);
        out.writeLong(this.creationDate);
        out.writeLong(this.nbMsgsReceiveSinceCreation);
        out.writeLong(this.nbMsgsDeliverSinceCreation);
        out.writeLong(this.nbMsgsSentToDMQSinceCreation);
        out.writeLong(this.period);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.deletable = in.readBoolean();
        this.adminId = (AgentId)in.readObject();
        this.freeReading = in.readBoolean();
        this.freeWriting = in.readBoolean();
        this.clients = (Hashtable)in.readObject();
        this.dmqId = (AgentId)in.readObject();
        this.strbuf = new StringBuffer();
        this.creationDate = in.readLong();
        this.nbMsgsReceiveSinceCreation = in.readLong();
        this.nbMsgsDeliverSinceCreation = in.readLong();
        this.nbMsgsSentToDMQSinceCreation = in.readLong();
        this.period = in.readLong();
    }

    public final String getDestinationId() {
        return this.getId().toString();
    }

    public boolean isFreeReading() {
        return this.freeReading;
    }

    public void setFreeReading(boolean on) {
        this.setSave();
        this.freeReading = on;
    }

    public boolean isFreeWriting() {
        return this.freeWriting;
    }

    public void setFreeWriting(boolean on) {
        this.setSave();
        this.freeWriting = on;
    }

    public String getDMQId() {
        if (this.dmqId != null) {
            return this.dmqId.toString();
        }
        return null;
    }

    public AgentId getDMQAgentId() {
        return this.dmqId;
    }

    public long getCreationTimeInMillis() {
        return this.creationDate;
    }

    public String getCreationDate() {
        return new Date(this.creationDate).toString();
    }

    public abstract long getNbMsgsReceiveSinceCreation();

    public long getNbMsgsDeliverSinceCreation() {
        return this.nbMsgsDeliverSinceCreation;
    }

    public long getNbMsgsSentToDMQSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation;
    }

    protected void replyToTopic(AdminReply reply, AgentId replyTo, String requestMsgId, String replyMsgId) {
        Message message = new Message();
        message.correlationId = requestMsgId;
        message.timestamp = System.currentTimeMillis();
        message.setDestination(replyTo.toString(), (byte)1);
        message.id = replyMsgId;
        try {
            message.setAdminMessage((AbstractAdminMessage)reply);
            ClientMessages clientMessages = new ClientMessages(-1, -1, message);
            this.forward(replyTo, clientMessages);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new Error(exc.getMessage());
        }
    }

    public final void forward(AgentId to, Notification not) {
        Channel.sendTo((AgentId)to, (Notification)not);
    }

    public void handleAdminRequestNot(AgentId from, FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof SetRight) {
            this.setRight((SetRight)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetStatsRequest) {
            this.replyToTopic((AdminReply)new GetStatsReply(this.getJMXStatistics()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetDMQRequest) {
            this.setSave();
            this.dmqId = ((SetDMQRequest)adminRequest).getDmqId() != null ? AgentId.fromString((String)((SetDMQRequest)adminRequest).getDmqId()) : null;
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else {
            logger.log(BasicLevel.ERROR, (Object)("Unknown administration request for destination " + this.agent.getId()));
            this.replyToTopic(new AdminReply(5, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
    }
}

