/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.soap;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Queue;
import java.util.Hashtable;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CnxCloseReply;
import org.objectweb.joram.shared.excepts.StateException;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SoapProxyService {
    public static Logger logger = Debug.getLogger((String)SoapProxyService.class.getName());
    private Hashtable connections;

    public void start(int serverId, String serverName) throws Exception {
        String[] args = new String[]{"" + serverId, serverName};
        AgentServer.init((String[])args);
        AgentServer.start();
        this.connections = new Hashtable();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"SoapProxyService started.");
        }
    }

    public int setConnection(Hashtable identityMap, int heartBeat) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SoapProxyService.setConnection(" + identityMap + ',' + heartBeat + ')'));
        }
        Identity identity = (Identity)Identity.soapDecode((Hashtable)identityMap);
        GetProxyIdNot gpin = new GetProxyIdNot(identity, null);
        gpin.invoke(AdminTopic.getDefault());
        AgentId proxyId = gpin.getProxyId();
        OpenConnectionNot ocn = new OpenConnectionNot(false, heartBeat);
        ocn.invoke(proxyId);
        StandardConnectionContext cc = (StandardConnectionContext)ocn.getConnectionContext();
        ProxyConnectionContext pcc = new ProxyConnectionContext(proxyId, cc.getQueue());
        this.connections.put(new ConnectionKey(identity.getUserName(), cc.getKey()), pcc);
        return cc.getKey();
    }

    public void send(String name, int cnxId, Hashtable h) throws Exception {
        ProxyConnectionContext ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SoapProxyService.send(" + name + ',' + cnxId + ',' + h + ')'));
        }
        AbstractJmsRequest request = (AbstractJmsRequest)AbstractJmsMessage.soapDecode((Hashtable)h);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " forwards request " + request + " with id " + request.getRequestId()));
        }
        if ((ctx = (ProxyConnectionContext)this.connections.get(new ConnectionKey(name, cnxId))) == null) {
            throw new StateException("Connection " + name + ':' + cnxId + " closed.");
        }
        ConnectionManager.sendToProxy(ctx.proxyId, cnxId, request, request);
    }

    public Hashtable getReply(String name, int cnxId) throws Exception {
        ConnectionKey ckey = new ConnectionKey(name, cnxId);
        ProxyConnectionContext ctx = (ProxyConnectionContext)this.connections.get(ckey);
        if (ctx == null) {
            throw new StateException("Connection " + name + ':' + cnxId + " closed.");
        }
        Object obj = ctx.replyQueue.get();
        if (obj instanceof Exception) {
            this.connections.remove(ckey);
            throw (Exception)obj;
        }
        AbstractJmsReply reply = (AbstractJmsReply)obj;
        ctx.replyQueue.pop();
        if (reply instanceof CnxCloseReply) {
            this.connections.remove(ckey);
        }
        return reply.soapCode();
    }

    static class ProxyConnectionContext {
        AgentId proxyId;
        Queue replyQueue;

        ProxyConnectionContext(AgentId proxyId, Queue replyQueue) {
            this.proxyId = proxyId;
            this.replyQueue = replyQueue;
        }
    }

    static class ConnectionKey {
        private String userName;
        private int key;

        public ConnectionKey(String userName, int key) {
            this.userName = userName;
            this.key = key;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionKey) {
                ConnectionKey ck = (ConnectionKey)obj;
                return ck.userName.equals(this.userName) && ck.key == this.key;
            }
            return false;
        }
    }
}

