/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.ews.mapper;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis.i18n.Messages;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.gen.NoopFactory;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionElement;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.ws.ews.mapper.J2eeGeneratorFactory;
import org.apache.ws.ews.mapper.MapperFault;
import org.apache.ws.ews.mapper.context.JAXRPCMapperContext;
import org.apache.ws.ews.mapper.jaxrpc.JaxRpcMapper;
import org.apache.ws.ews.mapper.jaxrpc.XMLBeansJaxRpcMapper;

public class J2eeEmitter
extends Emitter {
    private String mappingFilePath;
    private static final int timeoutms = 45000000;
    private InputStream mappingFileInputStream;
    private QName serviceQName;
    private JaxRpcMapper jaxRpcMapper;
    private SymbolTable symbolTable;
    protected JAXRPCMapperContext wscontext;
    static /* synthetic */ Class class$org$apache$axis$wsdl$toJava$Emitter;

    public J2eeEmitter() {
        J2eeGeneratorFactory factory = new J2eeGeneratorFactory(this);
        this.setFactory(factory);
    }

    public J2eeEmitter(JAXRPCMapperContext wscontext, J2eeGeneratorFactory factory) {
        this.wscontext = wscontext;
        if (factory == null) {
            factory = new J2eeGeneratorFactory(this);
        }
        this.setFactory(factory);
        factory.setEmitter(this);
    }

    public void setMappingFilePath(String mappingFilePath) {
        this.mappingFilePath = mappingFilePath;
    }

    private void loadMapping() throws MapperFault {
        this.jaxRpcMapper = new XMLBeansJaxRpcMapper();
        if (this.mappingFilePath == null) {
            this.jaxRpcMapper.loadMappingFromInputStream(this.mappingFileInputStream);
        } else {
            this.jaxRpcMapper.loadMappingFromDir(this.mappingFilePath);
        }
        this.setNowrap(!this.jaxRpcMapper.hasWrappedElement());
        int length = this.jaxRpcMapper.getPackageMappingCount();
        HashMap namespaceMap = this.getNamespaceMap();
        for (int i = 0; i < length; ++i) {
            namespaceMap.put(this.jaxRpcMapper.getPackageMappingURI(i), this.jaxRpcMapper.getPackageMappingClassName(i));
        }
    }

    public void run(String wsdlURL) throws Exception {
        this.setup();
        this.runTemp(wsdlURL);
    }

    public void runServerSide(String wsdlURL) throws Exception {
        this.setup();
        if (this.getFactory() == null) {
            this.setFactory((GeneratorFactory)new NoopFactory());
        }
        this.symbolTable = new SymbolTable(this.getFactory().getBaseTypeMapping(), this.imports, this.verbose, this.nowrap);
        this.symbolTable.setQuiet(this.quiet);
        this.symbolTable.setWrapArrays(this.wrapArrays);
        this.symbolTable.populate(wsdlURL, this.username, this.password);
        this.generate(this.symbolTable);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    private void setup() throws MapperFault {
        try {
            if (this.baseTypeMapping == null) {
                this.setTypeMappingVersion(this.typeMappingVersion);
            }
            this.getFactory().setBaseTypeMapping(this.baseTypeMapping);
            this.namespaces = new Namespaces(this.getOutputDir());
            if (this.getPackageName() != null) {
                this.namespaces.setDefaultPackage(this.getPackageName());
            } else {
                this.getNStoPkgFromPropsFile((HashMap)this.namespaces);
                this.loadMapping();
                if (this.getNamespaceMap() != null) {
                    this.namespaces.putAll((Map)this.getNamespaceMap());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw MapperFault.createMapperFault(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getNStoPkgFromPropsFile(HashMap namespaces) throws IOException {
        mappings = new Properties();
        if (this.NStoPkgFilename != null) {
            try {
                mappings.load(new FileInputStream(this.NStoPkgFilename));
                if (!this.verbose) ** GOTO lbl23
                System.out.println(Messages.getMessage((String)"nsToPkgFileLoaded00", (String)this.NStoPkgFilename));
            }
            catch (Throwable t) {
                throw new IOException(Messages.getMessage((String)"nsToPkgFileNotFound00", (String)this.NStoPkgFilename));
            }
        } else {
            try {
                mappings.load(new FileInputStream("NStoPkg.properties"));
                if (this.verbose) {
                    System.out.println(Messages.getMessage((String)"nsToPkgFileLoaded00", (String)"NStoPkg.properties"));
                }
            }
            catch (Throwable t) {
                try {
                    mappings.load(ClassUtils.getResourceAsStream((Class)(J2eeEmitter.class$org$apache$axis$wsdl$toJava$Emitter == null ? (J2eeEmitter.class$org$apache$axis$wsdl$toJava$Emitter = J2eeEmitter.class$("org.apache.axis.wsdl.toJava.Emitter")) : J2eeEmitter.class$org$apache$axis$wsdl$toJava$Emitter), (String)"NStoPkg.properties"));
                    if (this.verbose) {
                        System.out.println(Messages.getMessage((String)"nsToPkgDefaultFileLoaded00", (String)"NStoPkg.properties"));
                    }
                }
                catch (Throwable t1) {
                    // empty catch block
                }
            }
        }
lbl23:
        // 5 sources

        keys = mappings.propertyNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            namespaces.put(key, mappings.getProperty(key));
        }
    }

    public String getJavaName(QName qName) {
        if (qName.getLocalPart().indexOf("[") > 0) {
            String localPart = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["));
            QName eQName = new QName(qName.getNamespaceURI(), localPart);
            return this.getJavaName(eQName) + "[]";
        }
        if (qName.getNamespaceURI().equalsIgnoreCase("java")) {
            return qName.getLocalPart();
        }
        String fullJavaName = this.getFactory().getBaseTypeMapping().getBaseName(qName);
        if (fullJavaName != null) {
            return fullJavaName;
        }
        String pkg = this.getPackage(qName.getNamespaceURI());
        fullJavaName = pkg != null ? pkg + "." + Utils.xmlNameToJavaClass((String)qName.getLocalPart()) : Utils.xmlNameToJavaClass((String)qName.getLocalPart());
        return fullJavaName;
    }

    public void runTemp(String wsdlURI) throws Exception {
        if (this.getFactory() == null) {
            this.setFactory((GeneratorFactory)new NoopFactory());
        }
        this.symbolTable = new SymbolTable(this.getFactory().getBaseTypeMapping(), this.imports, this.verbose, this.nowrap);
        this.symbolTable.setQuiet(this.quiet);
        this.symbolTable.setWrapArrays(this.wrapArrays);
        WSDLRunnable runnable = new WSDLRunnable(this.symbolTable, wsdlURI);
        Thread wsdlThread = new Thread(runnable);
        wsdlThread.start();
        try {
            wsdlThread.join(45000000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (wsdlThread.isAlive()) {
            wsdlThread.interrupt();
            throw new IOException(Messages.getMessage((String)"timedOut"));
        }
        if (runnable.getFailure() != null) {
            throw runnable.getFailure();
        }
    }

    protected void sanityCheck(SymbolTable symbolTable) {
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                String namespace = entry.getQName().getNamespaceURI();
                String packageName = Utils.makePackageName((String)namespace);
                String localName = entry.getQName().getLocalPart();
                if (!localName.equals(packageName) || !packageName.equals(this.namespaces.getCreate(namespace))) continue;
                packageName = packageName + "_pkg";
                this.namespaces.put((Object)namespace, (Object)packageName);
            }
        }
    }

    private void generate(SymbolTable symbolTable) throws IOException {
        this.sanityCheck(symbolTable);
        Definition def = symbolTable.getDefinition();
        this.getFactory().generatorPass(def, symbolTable);
        if (this.isDebug()) {
            symbolTable.dump(System.out);
        }
        if (this.getOutputDir() == null) {
            return;
        }
        this.generateTypes(symbolTable);
        Iterator it = symbolTable.getHashMap().values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.elementAt(i);
                Generator gen = null;
                if (entry instanceof MessageEntry) {
                    gen = this.getFactory().getGenerator(((MessageEntry)entry).getMessage(), symbolTable);
                } else if (entry instanceof PortTypeEntry) {
                    PortTypeEntry pEntry = (PortTypeEntry)entry;
                    if (pEntry.getPortType().isUndefined()) continue;
                    gen = this.getFactory().getGenerator(pEntry.getPortType(), symbolTable);
                } else if (entry instanceof BindingEntry) {
                    BindingEntry bEntry = (BindingEntry)entry;
                    Binding binding = bEntry.getBinding();
                    if (binding.isUndefined() || !bEntry.isReferenced()) continue;
                    gen = this.getFactory().getGenerator(binding, symbolTable);
                } else if (entry instanceof ServiceEntry) {
                    ServiceEntry sEntry = (ServiceEntry)entry;
                    this.serviceQName = sEntry.getService().getQName();
                    gen = this.getFactory().getGenerator(sEntry.getService(), symbolTable);
                }
                if (gen == null) continue;
                gen.generate();
            }
        }
        Generator gen = this.getFactory().getGenerator(def, symbolTable);
        gen.generate();
    }

    private void generateTypes(SymbolTable symbolTable) throws IOException {
        Map elements = symbolTable.getElementIndex();
        Collection elementCollection = elements.values();
        Iterator i = elementCollection.iterator();
        while (i.hasNext()) {
            boolean isType;
            TypeEntry type = (TypeEntry)i.next();
            type.setOnlyLiteralReference(false);
            boolean bl = isType = type instanceof Type || type instanceof CollectionElement;
            if (type.getNode() == null || type.getNode().getLocalName().equals("attributeGroup") || type.getNode().getLocalName().equals("group") || !type.isReferenced() || !isType || type.getBaseType() != null) continue;
            Generator gen = this.getFactory().getGenerator(type, symbolTable);
            gen.generate();
        }
        Map types = symbolTable.getTypeIndex();
        Collection typeCollection = types.values();
        Iterator i2 = typeCollection.iterator();
        while (i2.hasNext()) {
            boolean isType;
            TypeEntry type = (TypeEntry)i2.next();
            boolean bl = isType = type instanceof Type || type instanceof CollectionElement;
            if (type.getNode() == null || type.getNode().getLocalName().equals("attributeGroup") || type.getNode().getLocalName().equals("group") || !type.isReferenced() || !isType || type.getBaseType() != null) continue;
            Generator gen = this.getFactory().getGenerator(type, symbolTable);
            gen.generate();
        }
    }

    public void setMappingFileInputStream(InputStream mappingFileInputStream) {
        this.mappingFileInputStream = mappingFileInputStream;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public boolean isGeneratingInterface() {
        return false;
    }

    public boolean isGeneratingTypes() {
        return false;
    }

    public JaxRpcMapper getJaxRpcMapper() {
        return this.jaxRpcMapper;
    }

    public void setJaxRpcMapper(JaxRpcMapper jaxRpcMapper) {
        this.jaxRpcMapper = jaxRpcMapper;
    }

    public JAXRPCMapperContext getWscontext() {
        return this.wscontext;
    }

    public void setWscontext(JAXRPCMapperContext context) {
        this.wscontext = context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WSDLRunnable
    implements Runnable {
        private SymbolTable symbolTable;
        private String wsdlURI;
        private Exception failure = null;

        public WSDLRunnable(SymbolTable symbolTable, String wsdlURI) {
            this.symbolTable = symbolTable;
            this.wsdlURI = wsdlURI;
        }

        public void run() {
            try {
                this.symbolTable.populate(this.wsdlURI, J2eeEmitter.this.username, J2eeEmitter.this.password);
                J2eeEmitter.this.generate(this.symbolTable);
            }
            catch (Exception e) {
                this.failure = e;
            }
        }

        public Exception getFailure() {
            return this.failure;
        }
    }
}

