/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.finder;

import java.util.Iterator;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.wsgen.finder.GenericWSFinder;
import org.ow2.jonas.generators.wsgen.finder.J2EEWebServicesFinder;

public class GeneralWSFinder
implements J2EEWebServicesFinder {
    private J2EEArchive archive = null;

    public GeneralWSFinder(J2EEArchive archive) {
        this.archive = archive;
    }

    public boolean find() {
        if (this.archive instanceof Application) {
            Application app = (Application)this.archive;
            Iterator i = app.getEjbJars();
            while (i.hasNext()) {
                EjbJar ejb = (EjbJar)i.next();
                if (!GeneralWSFinder.findWebServicesInEjbJar(ejb)) continue;
                return true;
            }
            i = app.getWebApps();
            while (i.hasNext()) {
                WebApp web = (WebApp)i.next();
                if (!GeneralWSFinder.findWebServicesInWebApp(web)) continue;
                return true;
            }
            i = app.getClients();
            while (i.hasNext()) {
                Client client = (Client)i.next();
                if (!GeneralWSFinder.findWebServicesInClient(client)) continue;
                return true;
            }
        } else {
            if (this.archive instanceof EjbJar) {
                return GeneralWSFinder.findWebServicesInEjbJar((EjbJar)this.archive);
            }
            if (this.archive instanceof WebApp) {
                return GeneralWSFinder.findWebServicesInWebApp((WebApp)this.archive);
            }
            if (this.archive instanceof Client) {
                return GeneralWSFinder.findWebServicesInClient((Client)this.archive);
            }
        }
        return false;
    }

    private static boolean findWebServicesInClient(Client archive) {
        GenericWSFinder finder = new GenericWSFinder((J2EEArchive)archive, "META-INF/application-client.xml");
        return finder.find();
    }

    private static boolean findWebServicesInWebApp(WebApp archive) {
        GenericWSFinder finder = new GenericWSFinder((J2EEArchive)archive, "WEB-INF/web.xml");
        return finder.find();
    }

    private static boolean findWebServicesInEjbJar(EjbJar archive) {
        GenericWSFinder finder = new GenericWSFinder((J2EEArchive)archive, "META-INF/ejb-jar.xml");
        return finder.find();
    }
}

