/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.client;

import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.joram.shared.client.AbstractJmsRequest;

public final class XACnxRollback
extends AbstractJmsRequest {
    private static final long serialVersionUID = 1L;
    private byte[] bq;
    private int fi;
    private byte[] gti;
    private Hashtable qDenyings = null;
    private Hashtable subDenyings = null;

    public void setBQ(byte[] bq) {
        this.bq = bq;
    }

    public byte[] getBQ() {
        return this.bq;
    }

    public void setFI(int fi) {
        this.fi = fi;
    }

    public int getFI() {
        return this.fi;
    }

    public void setGTI(byte[] gti) {
        this.gti = gti;
    }

    public byte[] getGTI() {
        return this.gti;
    }

    public void add(String target, Vector ids, boolean queueMode) {
        if (queueMode) {
            if (this.qDenyings == null) {
                this.qDenyings = new Hashtable();
            }
            this.qDenyings.put(target, ids);
        } else {
            if (this.subDenyings == null) {
                this.subDenyings = new Hashtable();
            }
            this.subDenyings.put(target, ids);
        }
    }

    public Enumeration getQueues() {
        if (this.qDenyings == null) {
            return new Hashtable().keys();
        }
        return this.qDenyings.keys();
    }

    public Vector getQueueIds(String queue) {
        if (this.qDenyings == null) {
            return null;
        }
        return (Vector)this.qDenyings.get(queue);
    }

    public Enumeration getSubs() {
        if (this.subDenyings == null) {
            return new Hashtable().keys();
        }
        return this.subDenyings.keys();
    }

    public void setQDenyings(Hashtable qDenyings) {
        this.qDenyings = qDenyings;
    }

    public void setSubDenyings(Hashtable subDenyings) {
        this.subDenyings = subDenyings;
    }

    public Vector getSubIds(String sub) {
        if (this.subDenyings == null) {
            return null;
        }
        return (Vector)this.subDenyings.get(sub);
    }

    protected int getClassId() {
        return 36;
    }

    public XACnxRollback(byte[] bq, int fi, byte[] gti) {
        super(null);
        this.bq = bq;
        this.fi = fi;
        this.gti = gti;
    }

    public XACnxRollback() {
    }

    public void writeTo(OutputStream os) throws IOException {
        Vector ids;
        String key;
        Enumeration keys;
        int size;
        super.writeTo(os);
        StreamUtil.writeTo((byte[])this.bq, (OutputStream)os);
        StreamUtil.writeTo((int)this.fi, (OutputStream)os);
        StreamUtil.writeTo((byte[])this.gti, (OutputStream)os);
        if (this.qDenyings == null) {
            StreamUtil.writeTo((int)-1, (OutputStream)os);
        } else {
            size = this.qDenyings.size();
            StreamUtil.writeTo((int)size, (OutputStream)os);
            keys = this.qDenyings.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                StreamUtil.writeTo((String)key, (OutputStream)os);
                ids = (Vector)this.qDenyings.get(key);
                StreamUtil.writeVectorOfStringTo((Vector)ids, (OutputStream)os);
            }
        }
        if (this.subDenyings == null) {
            StreamUtil.writeTo((int)-1, (OutputStream)os);
        } else {
            size = this.subDenyings.size();
            StreamUtil.writeTo((int)size, (OutputStream)os);
            keys = this.subDenyings.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                StreamUtil.writeTo((String)key, (OutputStream)os);
                ids = (Vector)this.subDenyings.get(key);
                StreamUtil.writeVectorOfStringTo((Vector)ids, (OutputStream)os);
            }
        }
    }

    public void readFrom(InputStream is) throws IOException {
        Vector ids;
        String target;
        int i;
        super.readFrom(is);
        this.bq = StreamUtil.readByteArrayFrom((InputStream)is);
        this.fi = StreamUtil.readIntFrom((InputStream)is);
        this.gti = StreamUtil.readByteArrayFrom((InputStream)is);
        int size = StreamUtil.readIntFrom((InputStream)is);
        if (size == -1) {
            this.qDenyings = null;
        } else {
            this.qDenyings = new Hashtable(size * 4 / 3);
            for (i = 0; i < size; ++i) {
                target = StreamUtil.readStringFrom((InputStream)is);
                ids = StreamUtil.readVectorOfStringFrom((InputStream)is);
                this.qDenyings.put(target, ids);
            }
        }
        size = StreamUtil.readIntFrom((InputStream)is);
        if (size == -1) {
            this.subDenyings = null;
        } else {
            this.subDenyings = new Hashtable(size * 4 / 3);
            for (i = 0; i < size; ++i) {
                target = StreamUtil.readStringFrom((InputStream)is);
                ids = StreamUtil.readVectorOfStringFrom((InputStream)is);
                this.subDenyings.put(target, ids);
            }
        }
    }
}

