/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.reconfig;

import java.util.Hashtable;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.management.reconfig.IConfigurationActuator;
import org.ow2.jonas.lib.management.reconfig.IConfigurationData;
import org.ow2.jonas.lib.management.reconfig.PropertiesConfigurationData;
import org.ow2.jonas.lib.management.reconfig.ReconfigException;
import org.ow2.jonas.lib.management.reconfig.XMLConfigurationData;
import org.ow2.jonas.lib.management.reconfig.actuator.BaseConfigurationActuator;
import org.ow2.jonas.lib.management.reconfig.actuator.PropertiesConfigurationActuator;
import org.ow2.jonas.lib.management.reconfig.actuator.XMLConfigurationActuator;
import org.ow2.jonas.properties.ServerProperties;

public class ReconfigManager
extends J2EEManagedObject
implements NotificationListener {
    private static final String SERVICE_TYPE = "service";
    private static final String JTA_RESOURCE_TYPE = "JTAResource";
    private static final String MAIL_RESOURCE_TYPE = "JavaMailResource";
    private static final String JDBC_RESOURCE_TYPE = "JDBCDataSource";
    private static final String SECURITYREALM_FACTORY = "securityfactory";
    private static final String SECURITYREALM_FILE = "jonas-realm.xml";
    private ObjectName reconfigManagerOn = null;
    private ServerProperties props = null;
    private String logConfigFileName = null;
    private String serverConfigFileName = null;
    Hashtable reconfigurators = new Hashtable();
    private JmxService jmxService = null;

    public ReconfigManager(ObjectName objectName, ServerProperties props) {
        super(objectName.toString());
        this.reconfigManagerOn = objectName;
        this.props = props;
    }

    public void addMBeanServerDelegateListener() throws JMException {
        ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        this.jmxService.getJmxServer().addNotificationListener(delegate, this, null, null);
    }

    public void handleNotification(Notification notification, Object handback) {
        String notificationType = notification.getType();
        if (notification instanceof MBeanServerNotification) {
            this.handleRegUnregNotification((MBeanServerNotification)notification);
        } else if (notificationType.equals("jonas.management.reconfiguration")) {
            this.handleReconfig(notification);
        } else if (notificationType.equals("jonas.management.reconfiguration.save")) {
            this.handleSave(notification);
        }
    }

    private void handleRegUnregNotification(MBeanServerNotification notification) {
        String notificationType = notification.getType();
        if (notificationType.equals("JMX.mbean.registered")) {
            this.handleRegistrationNotification(notification);
        } else if (notificationType.equals("JMX.mbean.unregistered")) {
            this.handleUnregistrationNotification(notification);
        }
    }

    private void handleUnregistrationNotification(MBeanServerNotification notification) {
        ObjectName registeringMbean = notification.getMBeanName();
        String registeringName = registeringMbean.getKeyProperty("name");
        if (this.reconfigurators.containsKey(registeringName)) {
            try {
                this.jmxService.getJmxServer().removeNotificationListener(registeringMbean, this);
            }
            catch (JMException me) {
                throw new ReconfigException("ReconfigManager can't remove notification listen because of exception: ", me);
            }
        }
    }

    private void handleRegistrationNotification(MBeanServerNotification notification) {
        BaseConfigurationActuator configurationActuator = null;
        ObjectName registeringMbean = notification.getMBeanName();
        String registeringType = registeringMbean.getKeyProperty("type");
        String registeringJ2eeType = registeringMbean.getKeyProperty("j2eeType");
        if (registeringJ2eeType != null) {
            registeringType = registeringJ2eeType;
        }
        if (registeringType == null) {
            return;
        }
        String registeringName = registeringMbean.getKeyProperty("name");
        if (registeringType.equals(SERVICE_TYPE) || registeringType.equals(JTA_RESOURCE_TYPE)) {
            try {
                String configFileName;
                Properties registeringProps;
                if ("log".equals(registeringName)) {
                    registeringProps = (Properties)this.jmxService.getJmxServer().getAttribute(registeringMbean, "props");
                    configFileName = this.logConfigFileName;
                } else {
                    registeringProps = this.props.getConfigFileEnv();
                    configFileName = this.serverConfigFileName;
                }
                configurationActuator = new PropertiesConfigurationActuator(registeringName, configFileName, registeringProps);
            }
            catch (Exception e) {}
        } else {
            String resourceName = null;
            try {
                String configFilename;
                JProp jprop;
                if (registeringType.equals(MAIL_RESOURCE_TYPE)) {
                    resourceName = (String)this.jmxService.getJmxServer().getAttribute(registeringMbean, "FactoryName");
                } else if (registeringType.equals(JDBC_RESOURCE_TYPE)) {
                    resourceName = (String)this.jmxService.getJmxServer().getAttribute(registeringMbean, "name");
                } else if (registeringType.equals(SECURITYREALM_FACTORY)) {
                    jprop = JProp.getInstance((String)SECURITYREALM_FILE);
                    configFilename = jprop.getPropFile();
                    String txt = jprop.getConfigFileXml();
                    configurationActuator = new XMLConfigurationActuator(SECURITYREALM_FILE, configFilename, txt);
                }
                if (resourceName != null) {
                    jprop = JProp.getInstance((String)resourceName);
                    configFilename = jprop.getPropFile();
                    Properties registeringProps = JProp.getInstance((String)resourceName).getConfigFileEnv();
                    configurationActuator = new PropertiesConfigurationActuator(resourceName, configFilename, registeringProps);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (configurationActuator != null) {
            try {
                this.jmxService.getJmxServer().addNotificationListener(registeringMbean, this, null, null);
            }
            catch (JMException me) {
                throw new ReconfigException("ReconfigManager can't listen to Notifications because of exception: ", me);
            }
            this.reconfigurators.put(registeringName, configurationActuator);
        }
    }

    private void handleReconfig(Notification notification) {
        String name = notification.getMessage();
        long sequence = notification.getSequenceNumber();
        IConfigurationData data = (IConfigurationData)notification.getUserData();
        if (data instanceof PropertiesConfigurationData) {
            PropertiesConfigurationData prop = (PropertiesConfigurationData)data;
            this.handlePropsReconfig(name, sequence, prop);
        } else {
            XMLConfigurationData xmlData = (XMLConfigurationData)data;
            this.handleXmlReconfig(name, sequence, xmlData);
        }
    }

    private void handlePropsReconfig(String name, long sequence, PropertiesConfigurationData prop) throws ReconfigException {
        PropertiesConfigurationActuator actuator = (PropertiesConfigurationActuator)this.reconfigurators.get(name);
        if (actuator == null) {
            throw new ReconfigException("Can't find IConfigurationActuator associated to service or resource " + name);
        }
        if (prop.getPropValue() != null) {
            if (prop.replaceProp()) {
                actuator.updateConfig(prop.getPropName(), prop.getPropValue(), sequence);
            } else {
                actuator.updateConfig(prop.getPropName(), prop.getPropValue(), prop.addProp(), sequence);
            }
        } else {
            actuator.updateConfig(prop.getProps(), sequence);
        }
    }

    private void handleXmlReconfig(String name, long sequence, XMLConfigurationData data) throws ReconfigException {
        XMLConfigurationActuator actuator = (XMLConfigurationActuator)this.reconfigurators.get(name);
        if (actuator == null) {
            throw new ReconfigException("Can't find IConfigurationActuator associated to service or resource " + name);
        }
        actuator.updateConfig(data.getXml(), sequence);
    }

    private void handleSave(Notification notification) {
        String name = notification.getMessage();
        long sequence = notification.getSequenceNumber();
        IConfigurationActuator actuator = (IConfigurationActuator)this.reconfigurators.get(name);
        if (actuator == null) {
            throw new ReconfigException("Can't find IConfigurationActuator associated to service or resource " + name);
        }
        actuator.saveConfig(sequence);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setLogConfigFileName(String logConfigFileName) {
        this.logConfigFileName = logConfigFileName;
    }

    public void setServerConfigFileName(String serverConfigFileName) {
        this.serverConfigFileName = serverConfigFileName;
    }
}

