/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.clusterdaemon;

import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.J2EEDomain;
import org.ow2.jonas.lib.management.domain.proxy.clusterd.ClusterDaemonProxy;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.extensions.base.api.ManagementException;
import org.ow2.jonas.management.extensions.clusterdaemon.api.IClusterdaemon;

public class ClusterdaemonManagement
extends BaseManagement
implements IClusterdaemon {
    private static final String state = "State";
    private static final String controlledServersNames = "ControlledServersNames";
    private static final String runningState = "RUNNING";
    private DomainMonitor dm = J2EEDomain.getInstance().getDomainMonitor();

    public String getOperatingSystemAvailableProcessors(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getOperatingSystemAvailableProcessors();
        }
        return null;
    }

    public String getOperatingSystemName(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getOperatingSystemName();
        }
        return null;
    }

    public String getOperatingSystemVersion(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getOperatingSystemVersion();
        }
        return null;
    }

    public String getRunTimeSpecVendor(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getRunTimeSpecVendor();
        }
        return null;
    }

    public String getRunTimeSpecVersion(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getRunTimeSpecVersion();
        }
        return null;
    }

    public String getRunTimeVmName(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getRunTimeVmName();
        }
        return null;
    }

    public String getRunTimeVmVendor(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getRunTimeVmVendor();
        }
        return null;
    }

    public String getRunTimeVmVersion(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getRunTimeVmVersion();
        }
        return null;
    }

    public String getOperatingSystemArch(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getOperatingSystemArch();
        }
        return null;
    }

    public String getVmCurrentUsedMemory(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getVmCurrentUsedMemory();
        }
        return null;
    }

    public String getVmTotalMemory(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getVmTotalMemory();
        }
        return null;
    }

    public String getVmCurrentUsedHeapMemory(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getVmCurrentUsedHeapMemory();
        }
        return null;
    }

    public String getVmCurrentUsedNonHeapMemory(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getVmCurrentUsedNonHeapMemory();
        }
        return null;
    }

    public String getOsCurrentUsedSpace(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getOsCurrentUsedSpace();
        }
        return null;
    }

    public String getOsTotalSpace(String clusterDaemonName) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            return cdProxy.getOsTotalSpace();
        }
        return null;
    }

    private ObjectName getClusterdaemonOn(String clusterdaemonName) {
        String domain = this.getDomainName();
        ObjectName clusterdaemonOn = null;
        try {
            clusterdaemonOn = JonasObjectName.clusterDaemonProxy((String)domain, (String)clusterdaemonName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return clusterdaemonOn;
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        String clusterdaemonState = null;
        try {
            clusterdaemonState = (String)JonasManagementRepr.getAttribute(clusterdaemonOn, state, this.getServerName());
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot get state for cluster daemon " + clusterdaemonName + " :" + (Object)((Object)e)), new Object[0]);
        }
        return clusterdaemonState;
    }

    public boolean isRunning(String clusterdaemonName) {
        boolean result = false;
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        try {
            String clusterdaemonState = (String)JonasManagementRepr.getAttribute(clusterdaemonOn, state, this.getServerName());
            if (runningState.equals(clusterdaemonState)) {
                result = true;
            }
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot get state for cluster daemon " + clusterdaemonName + " :" + (Object)((Object)e)), new Object[0]);
        }
        return result;
    }

    public String[] getControlledServersNames(String clusterdaemonName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        ArrayList servers = new ArrayList();
        try {
            servers = (ArrayList)JonasManagementRepr.getAttribute(clusterdaemonOn, controlledServersNames, this.getServerName());
            if (servers == null) {
                return new String[0];
            }
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot get controlled server names for cluster daemon " + clusterdaemonName + " :" + (Object)((Object)e)), new Object[0]);
            return null;
        }
        String[] controlledServers = new String[servers.size()];
        for (int i = 0; i < servers.size(); ++i) {
            controlledServers[i] = (String)servers.get(i);
        }
        return controlledServers;
    }

    public boolean startServer(String clusterdaemonName, String serverName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        Boolean result = null;
        String opName = "startServer";
        Object[] opParams = new String[2];
        String[] opSignature = new String[]{"java.lang.String", "java.lang.String"};
        opParams[0] = serverName;
        opParams[1] = null;
        try {
            result = (Boolean)JonasManagementRepr.invoke(clusterdaemonOn, opName, opParams, opSignature, this.getServerName());
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot start server " + serverName + " by cluster daemon " + clusterdaemonName + " :" + (Object)((Object)e)), new Object[0]);
            return false;
        }
        return result;
    }

    public boolean stopServer(String clusterdaemonName, String serverName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        Boolean result = null;
        String opName = "stopServer";
        Object[] opParams = new String[2];
        String[] opSignature = new String[]{"java.lang.String", "java.lang.String"};
        opParams[0] = serverName;
        opParams[1] = null;
        try {
            result = (Boolean)JonasManagementRepr.invoke(clusterdaemonOn, opName, opParams, opSignature, this.getServerName());
        }
        catch (ManagementException e) {
            logger.debug((Object)("Cannot stop server " + serverName + " by cluster daemon " + clusterdaemonName + " :" + (Object)((Object)e)), new Object[0]);
            return false;
        }
        return result;
    }

    public void addServer(String clusterDaemonName, String serverName, String description, String jonasRoot, String jonasBase, String javaHome, String xprem, String autoBoot, String jonasCmd, String saveIt) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            cdProxy.addServer(serverName, description, jonasRoot, jonasBase, javaHome, xprem, autoBoot, jonasCmd, saveIt);
        }
    }

    public void AddServer(String clusterDaemonName, String serverName, String description, String jonasRoot, String jonasBase, String javaHome, String xprem, String autoBoot, String saveIt) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterDaemonName);
        if (clusterdaemonOn != null && serverName != null && description != null && jonasRoot != null && jonasRoot != null && javaHome != null && xprem != null && autoBoot != null && saveIt != null) {
            String opName = "addServer";
            Object[] opParams = new String[8];
            String[] opSignature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
            opParams[0] = serverName;
            opParams[1] = description;
            opParams[2] = jonasRoot;
            opParams[3] = jonasBase;
            opParams[4] = javaHome;
            opParams[5] = xprem;
            opParams[6] = autoBoot;
            opParams[7] = saveIt;
            try {
                JonasManagementRepr.invoke(clusterdaemonOn, opName, opParams, opSignature, this.getServerName());
            }
            catch (ManagementException e) {
                logger.debug((Object)("Cannot Add server named " + serverName + " to cluster daemon " + clusterDaemonName + " control :" + (Object)((Object)e)), new Object[0]);
            }
        }
    }

    public void removeServer(String clusterDaemonName, String serverName, String saveIt) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            cdProxy.removeServer(serverName, saveIt);
        }
    }

    public void startAllServers(String clusterDaemonName, String otherParams) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            cdProxy.startAllServers(otherParams);
        }
    }

    public void stopAllServers(String clusterDaemonName, String otherParams) {
        ClusterDaemonProxy cdProxy = this.dm.findClusterDaemonProxy(clusterDaemonName);
        if (cdProxy != null) {
            cdProxy.stopAllServers(otherParams);
        }
    }
}

