/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class BusDefinitionParser
extends AbstractBeanDefinitionParser {
    private static AtomicInteger counter = new AtomicInteger(0);

    public BusDefinitionParser() {
        this.setBeanClass(BusConfig.class);
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String bus = element.getAttribute("bus");
        if (StringUtils.isEmpty(bus)) {
            this.addBusWiringAttribute(bean, BusWiringType.CONSTRUCTOR);
        } else {
            bean.addConstructorArgReference(bus);
            element.removeAttribute("bus");
        }
        bean.setLazyInit(false);
        super.doParse(element, ctx, bean);
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element e, String name) {
        if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name)) {
            List list = ctx.getDelegate().parseListElement(e, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("properties".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(e, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue("properties", (Object)map);
        }
    }

    protected String getIdOrName(Element elem) {
        String id = super.getIdOrName(elem);
        if (StringUtils.isEmpty(id)) {
            id = "cxf.config" + counter.getAndIncrement();
        }
        return id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BusConfig
    implements ApplicationContextAware {
        CXFBusImpl bus;
        boolean defaultBus;

        public BusConfig() {
            this.bus = (CXFBusImpl)BusFactory.getDefaultBus();
            this.defaultBus = true;
        }

        public BusConfig(Bus b) {
            this.bus = (CXFBusImpl)b;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            if (this.defaultBus && applicationContext.getAutowireCapableBeanFactory() instanceof ConfigurableBeanFactory) {
                ConfigurableBeanFactory bf = (ConfigurableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
                bf.registerSingleton("cxf", (Object)this.bus);
            }
        }

        public List<Interceptor> getOutFaultInterceptors() {
            return this.bus.getOutFaultInterceptors();
        }

        public List<Interceptor> getInFaultInterceptors() {
            return this.bus.getInFaultInterceptors();
        }

        public List<Interceptor> getInInterceptors() {
            return this.bus.getInInterceptors();
        }

        public List<Interceptor> getOutInterceptors() {
            return this.bus.getOutInterceptors();
        }

        public void setInInterceptors(List<Interceptor> interceptors) {
            this.bus.setInInterceptors(interceptors);
        }

        public void setInFaultInterceptors(List<Interceptor> interceptors) {
            this.bus.setInFaultInterceptors(interceptors);
        }

        public void setOutInterceptors(List<Interceptor> interceptors) {
            this.bus.setOutInterceptors(interceptors);
        }

        public void setOutFaultInterceptors(List<Interceptor> interceptors) {
            this.bus.setOutFaultInterceptors(interceptors);
        }

        public Collection<AbstractFeature> getFeatures() {
            return this.bus.getFeatures();
        }

        public void setFeatures(Collection<AbstractFeature> features) {
            this.bus.setFeatures(features);
        }

        public Map<String, Object> getProperties() {
            return this.bus.getProperties();
        }

        public void setProperties(Map<String, Object> s) {
            this.bus.setProperties(s);
        }
    }
}

