/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator;

import java.util.Map;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator.AbstractJaxwsGenerator;

public class JaxwsSEIGenerator
extends AbstractJaxwsGenerator {
    private static final String SEI_TEMPLATE = "org/apache/cxf/tools/java2wsdl/processor/internal/jaxws/generator/template/javafirst-sei.vm";

    public JaxwsSEIGenerator() {
        this.name = "sei.generator";
    }

    public boolean passthrough() {
        Boolean genFromSei = (Boolean)this.env.get("genFromSEI");
        return genFromSei != false || !this.env.optionSet("client") || this.env.optionSet("seiClass");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map<String, JavaInterface> interfaces = javaModel.getInterfaces();
        for (JavaInterface intf : interfaces.values()) {
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setCommonAttributes();
            this.doWrite(SEI_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName()));
            this.env.put("seiClass", intf.getFullClassName());
        }
    }
}

