/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.fastrmic.RMIC;
import org.ow2.jonas.deployment.api.IEJBRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.generator.AbsGenerator;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genclientstub.ClientStubGenException;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.loader.AbsModuleClassLoader;
import org.ow2.jonas.lib.util.Cmd;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public class Generator
extends AbsGenerator {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.generators.genclientstub");
    private static I18n i18n = I18n.getInstance(Generator.class);
    private IEJBRefDesc ejbRef = null;
    private String intfStubClassName = null;
    private Archive archive = null;

    public Generator(Config config, IEJBRefDesc ejbRef, String intfStubClassName, Archive archive) throws GenBaseException {
        super(config);
        this.ejbRef = ejbRef;
        this.intfStubClassName = intfStubClassName;
        this.archive = archive;
    }

    public void generate() throws ClientStubGenException {
        block10: {
            try {
                String rmiName;
                String archiveClasspath = null;
                J2EEArchive arch = (J2EEArchive)this.archive;
                AbsModuleClassLoader loader = (AbsModuleClassLoader)arch.getModuleClassloader();
                archiveClasspath = loader.getClasspath();
                String itfClass = null;
                itfClass = this.ejbRef != null ? this.ejbRef.getHome() : this.intfStubClassName;
                String classpath = this.getConfig().getClasspath() + File.pathSeparator + archiveClasspath;
                String jRoot = JProp.getJonasRoot();
                if (jRoot != null) {
                    classpath = jRoot + File.separator + "lib" + File.separator + "client.jar" + File.pathSeparator + classpath;
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Using classpath '" + classpath + "'."));
                }
                if ((rmiName = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName()).equalsIgnoreCase("iiop") && itfClass != null) {
                    Cmd iiopCmd = new Cmd(this.getConfig().getJavaHomeBin() + this.getConfig().getNameRmic());
                    iiopCmd.addArgument("-classpath");
                    iiopCmd.addArgument(classpath);
                    iiopCmd.addArgument("-iiop");
                    iiopCmd.addArgument("-poa");
                    iiopCmd.addArgument("-always");
                    iiopCmd.addArgument("-keepgenerated");
                    iiopCmd.addArgument("-g");
                    iiopCmd.addArgument("-d");
                    iiopCmd.addArgument(this.getClasses().getCanonicalPath());
                    iiopCmd.addArguments(this.getConfig().getJavacOpts());
                    iiopCmd.addArgument(itfClass);
                    if (Generator.getLogger().isLoggable(BasicLevel.DEBUG)) {
                        Generator.getLogger().log(BasicLevel.DEBUG, (Object)("Running '" + iiopCmd.toString() + "'"));
                    }
                    if (iiopCmd.run()) {
                        Generator.getLogger().log(BasicLevel.INFO, (Object)("Client stubs for classname '" + itfClass + "' successfully generated for protocol 'iiop'."));
                        break block10;
                    }
                    String err = i18n.getMessage("Generator.generate.error");
                    Generator.getLogger().log(BasicLevel.ERROR, (Object)err);
                    throw new ClientStubGenException(err);
                }
                if (itfClass == null || !"jrmp".equalsIgnoreCase(rmiName) && !"irmi".equalsIgnoreCase(rmiName)) break block10;
                Cmd jrmpCmd = new Cmd(this.getConfig().getJavaHomeBin() + this.getConfig().getNameRmic());
                jrmpCmd.addArgument("-classpath");
                jrmpCmd.addArgument(classpath);
                jrmpCmd.addArgument("-keepgenerated");
                jrmpCmd.addArgument("-g");
                jrmpCmd.addArgument("-d");
                jrmpCmd.addArgument(this.getClasses().getCanonicalPath());
                jrmpCmd.addArguments(this.getConfig().getJavacOpts());
                jrmpCmd.addArgument(itfClass);
                ArrayList args = new ArrayList();
                boolean skip = true;
                Iterator it = jrmpCmd.getCommandLine();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    args.add(o);
                }
                String[] a = args.toArray(new String[0]);
                RMIC rmic = new RMIC(a);
                if (rmic.run()) {
                    Generator.getLogger().log(BasicLevel.INFO, (Object)("Client stubs for classname '" + itfClass + "' successfully generated for protocol '" + rmiName + "'."));
                    break block10;
                }
                String err = i18n.getMessage("Generator.generate.error");
                Generator.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new ClientStubGenException(err, rmic.getException());
            }
            catch (Exception e) {
                String err = i18n.getMessage("Generator.generate.error");
                Generator.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new ClientStubGenException(err, e);
            }
        }
    }

    public void compile() throws ClientStubGenException {
    }

    public void addFiles(Archive archive) throws ClientStubGenException {
        if (archive instanceof WebApp) {
            archive.addDirectoryIn("WEB-INF/classes/", this.getClasses());
        } else if (archive instanceof EjbJar) {
            archive.addDirectory(this.getClasses());
        } else if (archive instanceof Client) {
            archive.addDirectory(this.getClasses());
        }
    }
}

