/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Manifest;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.archive.impl.AbsArchiveImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryArchiveImpl
extends AbsArchiveImpl
implements IArchive {
    private static final String MANIFEST_PATH = "META-INF" + File.separator + "MANIFEST.MF";
    private static final Log logger = LogFactory.getLog(DirectoryArchiveImpl.class);
    private File directory = null;
    private URL url = null;
    private boolean metadataAnalyzed = false;

    protected DirectoryArchiveImpl(File directory) {
        try {
            this.directory = directory.getCanonicalFile();
        }
        catch (IOException e) {
            logger.debug((Object)"Directory ''{0}'' cannot be canonicalized, use it as is", new Object[]{directory});
            this.directory = directory;
        }
        this.url = URLUtils.fileToURL((File)this.directory);
    }

    public String getName() {
        return this.directory.getPath();
    }

    @Override
    public IArchiveMetadata getMetadata() {
        if (!this.metadataAnalyzed) {
            try {
                this.initMetadata();
            }
            catch (ArchiveException e) {
                logger.error((Object)("Cannot initialize metadata of file '" + this.directory + "'."), new Object[]{e});
            }
            this.metadataAnalyzed = true;
        }
        return super.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMetadata() throws ArchiveException {
        File manifestFile = new File(this.directory, MANIFEST_PATH);
        if (manifestFile.exists()) {
            Manifest manifest = null;
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(manifestFile);
                }
                catch (FileNotFoundException e) {
                    throw new ArchiveException("Cannot read the manifest file '" + manifestFile + "'", (Throwable)e);
                }
                try {
                    manifest = new Manifest(is);
                }
                catch (IOException e) {
                    throw new ArchiveException("Cannot read the manifest file '" + manifestFile + "'", (Throwable)e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        throw new ArchiveException("Cannot close the manifest file '" + manifestFile + "'", (Throwable)e);
                    }
                }
            }
            this.readManifest(manifest);
        }
    }

    private String encode(String resourceName) {
        String[] tokens = resourceName.split("/");
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (sb.length() > 0) {
                sb.append(File.separator);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public boolean close() {
        return true;
    }

    public URL getResource(String resourceName) throws ArchiveException {
        URL resourceURL = null;
        File f = new File(this.directory, this.encode(resourceName));
        try {
            if (f.exists()) {
                resourceURL = URLUtils.fileToURL2((File)f);
            }
        }
        catch (URLUtilsException e) {
            throw new ArchiveException("Invalid url", (Throwable)e);
        }
        return resourceURL;
    }

    public Iterator<URL> getResources() throws ArchiveException {
        HashMap<String, URL> listResources = new HashMap<String, URL>();
        this.addFiles(this.directory, listResources);
        return listResources.values().iterator();
    }

    private void addFiles(File file, Map<String, URL> listResources) {
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.addFiles("", f, listResources);
            }
        }
    }

    private void addFiles(String name, File file, Map<String, URL> listResources) {
        block4: {
            block3: {
                if (!file.isDirectory()) break block3;
                File[] files = file.listFiles();
                if (files == null) break block4;
                for (File f : files) {
                    this.addFiles(name + file.getName() + "/", f, listResources);
                }
                break block4;
            }
            try {
                listResources.put(name + file.getName(), URLUtils.fileToURL2((File)file));
            }
            catch (URLUtilsException e) {
                throw new IllegalStateException("Invalid url", e);
            }
        }
    }

    public Iterator<URL> getResources(String resourceName) throws ArchiveException {
        ArrayList<URL> listResources = new ArrayList<URL>();
        File f = new File(this.directory, this.encode(resourceName));
        if (f.exists()) {
            try {
                listResources.add(URLUtils.fileToURL2((File)f));
            }
            catch (URLUtilsException e) {
                throw new ArchiveException("Invalid url", (Throwable)e);
            }
        }
        return listResources.iterator();
    }

    public URL getURL() throws ArchiveException {
        return this.url;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DirectoryArchiveImpl)) {
            return false;
        }
        DirectoryArchiveImpl other = (DirectoryArchiveImpl)o;
        return this.directory.equals(other.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public Iterator<String> getEntries() {
        HashMap<String, URL> listResources = new HashMap<String, URL>();
        this.addFiles(this.directory, listResources);
        return listResources.keySet().iterator();
    }
}

