/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DataSourceLogs;
import org.apache.openjpa.lib.jdbc.DelegatingCallableStatement;
import org.apache.openjpa.lib.jdbc.DelegatingConnection;
import org.apache.openjpa.lib.jdbc.DelegatingDatabaseMetaData;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.apache.openjpa.lib.jdbc.DelegatingResultSet;
import org.apache.openjpa.lib.jdbc.DelegatingStatement;
import org.apache.openjpa.lib.jdbc.ReportingSQLException;
import org.apache.openjpa.lib.jdbc.SQLFormatter;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class LoggingConnectionDecorator
implements ConnectionDecorator {
    private static final String SEP = J2DoPrivHelper.getLineSeparator();
    static final Constructor<LoggingConnection> loggingConnectionImpl;
    static final Constructor<LoggingConnection.LoggingResultSet> loggingResultSetImpl;
    static final Constructor<LoggingConnection.LoggingStatement> loggingStatementImpl;
    static final Constructor<LoggingConnection.LoggingPreparedStatement> loggingPreparedStatementImpl;
    static final Constructor<LoggingConnection.LoggingCallableStatement> loggingCallableStatementImpl;
    static final Constructor<LoggingConnection.LoggingDatabaseMetaData> loggingDatabaseMetaDataImpl;
    private static final int WARN_IGNORE = 0;
    private static final int WARN_LOG_TRACE = 1;
    private static final int WARN_LOG_INFO = 2;
    private static final int WARN_LOG_WARN = 3;
    private static final int WARN_LOG_ERROR = 4;
    private static final int WARN_THROW = 5;
    private static final int WARN_HANDLE = 6;
    private static final String[] WARNING_ACTIONS;
    private final DataSourceLogs _logs = new DataSourceLogs();
    private SQLFormatter _formatter;
    private boolean _prettyPrint;
    private int _prettyPrintLineLength = 60;
    private int _warningAction = 0;
    private SQLWarningHandler _warningHandler;
    private boolean _trackParameters = true;

    public void setPrettyPrint(boolean prettyPrint) {
        this._prettyPrint = prettyPrint;
        if (this._formatter == null && this._prettyPrint) {
            this._formatter = new SQLFormatter();
            this._formatter.setLineLength(this._prettyPrintLineLength);
        } else if (!this._prettyPrint) {
            this._formatter = null;
        }
    }

    public boolean getPrettyPrint() {
        return this._prettyPrint;
    }

    public void setPrettyPrintLineLength(int length) {
        this._prettyPrintLineLength = length;
        if (this._formatter != null) {
            this._formatter.setLineLength(length);
        }
    }

    public int getPrettyPrintLineLength() {
        return this._prettyPrintLineLength;
    }

    public void setTrackParameters(boolean trackParameters) {
        this._trackParameters = trackParameters;
    }

    public boolean getTrackParameters() {
        return this._trackParameters;
    }

    public void setWarningAction(String warningAction) {
        int index = Arrays.asList(WARNING_ACTIONS).indexOf(warningAction);
        if (index < 0) {
            index = 0;
        }
        this._warningAction = index;
    }

    public String getWarningAction() {
        return WARNING_ACTIONS[this._warningAction];
    }

    public void setWarningHandler(SQLWarningHandler warningHandler) {
        this._warningHandler = warningHandler;
    }

    public SQLWarningHandler getWarningHandler() {
        return this._warningHandler;
    }

    public DataSourceLogs getLogs() {
        return this._logs;
    }

    public Connection decorate(Connection conn) throws SQLException {
        return this.newLoggingConnection(conn);
    }

    private LoggingConnection newLoggingConnection(Connection conn) throws SQLException {
        return ConcreteClassGenerator.newInstance(loggingConnectionImpl, this, conn);
    }

    private SQLException wrap(SQLException sqle, Statement stmnt) {
        return this.wrap(sqle, stmnt, null, -1);
    }

    private SQLException wrap(SQLException sqle, String sql2) {
        return this.wrap(sqle, null, sql2, -1);
    }

    private SQLException wrap(SQLException sqle, Statement stmnt, String sql2) {
        return this.wrap(sqle, stmnt, sql2, -1);
    }

    private SQLException wrap(SQLException sqle, Statement stmnt, int indexOfFailedBatchObject) {
        return this.wrap(sqle, stmnt, null, indexOfFailedBatchObject);
    }

    private SQLException wrap(SQLException sqle, Statement stmnt, String sql2, int indexOfFailedBatchObject) {
        ReportingSQLException toReturn = null;
        toReturn = sqle instanceof ReportingSQLException ? (ReportingSQLException)sqle : new ReportingSQLException(sqle, stmnt, sql2);
        toReturn.setIndexOfFirstFailedObject(indexOfFailedBatchObject);
        return toReturn;
    }

    static {
        WARNING_ACTIONS = new String[7];
        LoggingConnectionDecorator.WARNING_ACTIONS[0] = "ignore";
        LoggingConnectionDecorator.WARNING_ACTIONS[1] = "trace";
        LoggingConnectionDecorator.WARNING_ACTIONS[2] = "info";
        LoggingConnectionDecorator.WARNING_ACTIONS[3] = "warn";
        LoggingConnectionDecorator.WARNING_ACTIONS[4] = "error";
        LoggingConnectionDecorator.WARNING_ACTIONS[5] = "throw";
        LoggingConnectionDecorator.WARNING_ACTIONS[6] = "handle";
        try {
            loggingConnectionImpl = ConcreteClassGenerator.getConcreteConstructor(LoggingConnection.class, LoggingConnectionDecorator.class, Connection.class);
            loggingResultSetImpl = ConcreteClassGenerator.getConcreteConstructor(LoggingConnection.LoggingResultSet.class, LoggingConnection.class, ResultSet.class, Statement.class);
            loggingStatementImpl = ConcreteClassGenerator.getConcreteConstructor(LoggingConnection.LoggingStatement.class, LoggingConnection.class, Statement.class);
            loggingPreparedStatementImpl = ConcreteClassGenerator.getConcreteConstructor(LoggingConnection.LoggingPreparedStatement.class, LoggingConnection.class, PreparedStatement.class, String.class);
            loggingCallableStatementImpl = ConcreteClassGenerator.getConcreteConstructor(LoggingConnection.LoggingCallableStatement.class, LoggingConnection.class, CallableStatement.class, String.class);
            loggingDatabaseMetaDataImpl = ConcreteClassGenerator.getConcreteConstructor(LoggingConnection.LoggingDatabaseMetaData.class, LoggingConnection.class, DatabaseMetaData.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    protected abstract class LoggingConnection
    extends DelegatingConnection {
        public LoggingConnection(Connection conn) throws SQLException {
            super(conn);
        }

        protected PreparedStatement prepareStatement(String sql2, boolean wrap) throws SQLException {
            LoggingPreparedStatement loggingPreparedStatement;
            SQLException err = null;
            try {
                PreparedStatement stmnt = super.prepareStatement(sql2, false);
                loggingPreparedStatement = this.newLoggingPreparedStatement(stmnt, sql2);
            }
            catch (SQLException se) {
                try {
                    err = LoggingConnectionDecorator.this.wrap(se, sql2);
                    throw err;
                }
                catch (Throwable throwable) {
                    this.handleSQLErrors(err);
                    throw throwable;
                }
            }
            this.handleSQLErrors(err);
            return loggingPreparedStatement;
        }

        protected PreparedStatement prepareStatement(String sql2, int rsType, int rsConcur, boolean wrap) throws SQLException {
            LoggingPreparedStatement loggingPreparedStatement;
            SQLException err = null;
            try {
                PreparedStatement stmnt = super.prepareStatement(sql2, rsType, rsConcur, false);
                loggingPreparedStatement = this.newLoggingPreparedStatement(stmnt, sql2);
            }
            catch (SQLException se) {
                try {
                    err = LoggingConnectionDecorator.this.wrap(se, sql2);
                    throw err;
                }
                catch (Throwable throwable) {
                    this.handleSQLErrors(err);
                    throw throwable;
                }
            }
            this.handleSQLErrors(err);
            return loggingPreparedStatement;
        }

        protected Statement createStatement(boolean wrap) throws SQLException {
            SQLException err = null;
            try {
                Statement stmnt = super.createStatement(false);
                LoggingStatement loggingStatement = this.newLoggingStatement(stmnt);
                return loggingStatement;
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                this.handleSQLErrors(err);
            }
        }

        protected Statement createStatement(int type, int concurrency, boolean wrap) throws SQLException {
            SQLException err = null;
            try {
                Statement stmnt = super.createStatement(type, concurrency, false);
                LoggingStatement loggingStatement = this.newLoggingStatement(stmnt);
                return loggingStatement;
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                this.handleSQLErrors(err);
            }
        }

        protected CallableStatement prepareCall(String sql2, boolean wrap) throws SQLException {
            CallableStatement callableStatement;
            SQLException err = null;
            try {
                CallableStatement stmt = super.prepareCall(sql2, wrap);
                callableStatement = this.newLoggingCallableStatement(stmt, sql2);
            }
            catch (SQLException se) {
                try {
                    err = LoggingConnectionDecorator.this.wrap(se, sql2);
                    throw err;
                }
                catch (Throwable throwable) {
                    this.handleSQLErrors(err);
                    throw throwable;
                }
            }
            this.handleSQLErrors(err);
            return callableStatement;
        }

        private LoggingPreparedStatement newLoggingPreparedStatement(PreparedStatement stmnt, String sql2) throws SQLException {
            return ConcreteClassGenerator.newInstance(loggingPreparedStatementImpl, this, stmnt, sql2);
        }

        private CallableStatement newLoggingCallableStatement(CallableStatement stmnt, String sql2) throws SQLException {
            return ConcreteClassGenerator.newInstance(loggingCallableStatementImpl, this, stmnt, sql2);
        }

        private LoggingStatement newLoggingStatement(Statement stmnt) throws SQLException {
            return ConcreteClassGenerator.newInstance(loggingStatementImpl, this, stmnt);
        }

        private LoggingDatabaseMetaData newLoggingDatabaseMetaData(DatabaseMetaData meta) throws SQLException {
            return ConcreteClassGenerator.newInstance(loggingDatabaseMetaDataImpl, this, meta);
        }

        public void commit() throws SQLException {
            long start = System.currentTimeMillis();
            SQLException err = null;
            try {
                super.commit();
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("commit", start, this);
                }
                this.handleSQLErrors(err);
            }
        }

        public void rollback() throws SQLException {
            long start = System.currentTimeMillis();
            SQLException err = null;
            try {
                super.rollback();
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("rollback", start, this);
                }
                this.handleSQLErrors(err);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            long start = System.currentTimeMillis();
            try {
                super.close();
            }
            finally {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("close", start, this);
                }
            }
        }

        public Savepoint setSavepoint() throws SQLException {
            long start = System.currentTimeMillis();
            SQLException err = null;
            try {
                Savepoint savepoint = super.setSavepoint();
                return savepoint;
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("savepoint", start, this);
                }
                this.handleSQLErrors(err);
            }
        }

        public Savepoint setSavepoint(String name) throws SQLException {
            long start = System.currentTimeMillis();
            SQLException err = null;
            try {
                Savepoint savepoint = super.setSavepoint(name);
                return savepoint;
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("savepoint: " + name, start, this);
                }
                this.handleSQLErrors(err);
            }
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            long start = System.currentTimeMillis();
            SQLException err = null;
            try {
                super.rollback(savepoint);
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    String name = null;
                    try {
                        name = savepoint.getSavepointName();
                    }
                    catch (SQLException sqe) {
                        name = String.valueOf(savepoint.getSavepointId());
                    }
                    LoggingConnectionDecorator.this._logs.logJDBC("rollback: " + name, start, this);
                }
                this.handleSQLErrors(err);
            }
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            long start = System.currentTimeMillis();
            SQLException err = null;
            try {
                super.releaseSavepoint(savepoint);
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    String name = null;
                    try {
                        name = savepoint.getSavepointName();
                    }
                    catch (SQLException sqe) {
                        name = String.valueOf(savepoint.getSavepointId());
                    }
                    LoggingConnectionDecorator.this._logs.logJDBC("release: " + name, start, this);
                }
                this.handleSQLErrors(err);
            }
        }

        protected Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean wrap) throws SQLException {
            SQLException err = null;
            try {
                Statement stmnt = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability, false);
                LoggingStatement loggingStatement = this.newLoggingStatement(stmnt);
                return loggingStatement;
            }
            catch (SQLException se) {
                err = se;
                throw se;
            }
            finally {
                this.handleSQLErrors(err);
            }
        }

        protected PreparedStatement prepareStatement(String sql2, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean wrap) throws SQLException {
            LoggingPreparedStatement loggingPreparedStatement;
            SQLException err = null;
            try {
                PreparedStatement stmnt = super.prepareStatement(sql2, resultSetType, resultSetConcurrency, resultSetHoldability, false);
                loggingPreparedStatement = this.newLoggingPreparedStatement(stmnt, sql2);
            }
            catch (SQLException se) {
                try {
                    err = LoggingConnectionDecorator.this.wrap(se, sql2);
                    throw err;
                }
                catch (Throwable throwable) {
                    this.handleSQLErrors(err);
                    throw throwable;
                }
            }
            this.handleSQLErrors(err);
            return loggingPreparedStatement;
        }

        protected PreparedStatement prepareStatement(String sql2, int autoGeneratedKeys, boolean wrap) throws SQLException {
            LoggingPreparedStatement loggingPreparedStatement;
            SQLException err = null;
            try {
                PreparedStatement stmnt = super.prepareStatement(sql2, autoGeneratedKeys, false);
                loggingPreparedStatement = this.newLoggingPreparedStatement(stmnt, sql2);
            }
            catch (SQLException se) {
                try {
                    err = LoggingConnectionDecorator.this.wrap(se, sql2);
                    throw err;
                }
                catch (Throwable throwable) {
                    this.handleSQLErrors(err);
                    throw throwable;
                }
            }
            this.handleSQLErrors(err);
            return loggingPreparedStatement;
        }

        protected PreparedStatement prepareStatement(String sql2, int[] columnIndexes, boolean wrap) throws SQLException {
            LoggingPreparedStatement loggingPreparedStatement;
            SQLException err = null;
            try {
                PreparedStatement stmnt = super.prepareStatement(sql2, columnIndexes, false);
                loggingPreparedStatement = this.newLoggingPreparedStatement(stmnt, sql2);
            }
            catch (SQLException se) {
                try {
                    err = LoggingConnectionDecorator.this.wrap(se, sql2);
                    throw err;
                }
                catch (Throwable throwable) {
                    this.handleSQLErrors(err);
                    throw throwable;
                }
            }
            this.handleSQLErrors(err);
            return loggingPreparedStatement;
        }

        protected PreparedStatement prepareStatement(String sql2, String[] columnNames, boolean wrap) throws SQLException {
            LoggingPreparedStatement loggingPreparedStatement;
            SQLException err = null;
            try {
                PreparedStatement stmnt = super.prepareStatement(sql2, columnNames, false);
                loggingPreparedStatement = this.newLoggingPreparedStatement(stmnt, sql2);
            }
            catch (SQLException se) {
                try {
                    err = LoggingConnectionDecorator.this.wrap(se, sql2);
                    throw err;
                }
                catch (Throwable throwable) {
                    this.handleSQLErrors(err);
                    throw throwable;
                }
            }
            this.handleSQLErrors(err);
            return loggingPreparedStatement;
        }

        protected DatabaseMetaData getMetaData(boolean wrap) throws SQLException {
            return this.newLoggingDatabaseMetaData(super.getMetaData(false));
        }

        private void logTime(long startTime) throws SQLException {
            if (LoggingConnectionDecorator.this._logs.isSQLEnabled()) {
                LoggingConnectionDecorator.this._logs.logSQL("spent", startTime, this);
            }
        }

        private void logSQL(Statement stmnt) throws SQLException {
            if (LoggingConnectionDecorator.this._logs.isSQLEnabled()) {
                LoggingConnectionDecorator.this._logs.logSQL("executing " + stmnt, this);
            }
        }

        private void logBatchSQL(Statement stmnt) throws SQLException {
            if (LoggingConnectionDecorator.this._logs.isSQLEnabled()) {
                LoggingConnectionDecorator.this._logs.logSQL("executing batch " + stmnt, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSQLErrors(SQLException err) throws SQLException {
            block7: {
                if (LoggingConnectionDecorator.this._warningAction == 0) {
                    return;
                }
                try {
                    this.handleSQLWarning(this.getWarnings());
                }
                catch (SQLException warning) {
                    if (err != null) {
                        err.setNextException(warning);
                        break block7;
                    }
                    throw warning;
                }
                finally {
                    this.clearWarnings();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSQLErrors(Statement stmnt, SQLException err) throws SQLException {
            block7: {
                if (LoggingConnectionDecorator.this._warningAction == 0) {
                    return;
                }
                try {
                    this.handleSQLWarning(stmnt.getWarnings());
                }
                catch (SQLException warning) {
                    if (err != null) {
                        err.setNextException(warning);
                        break block7;
                    }
                    throw warning;
                }
                finally {
                    stmnt.clearWarnings();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSQLErrors(ResultSet rs, SQLException err) throws SQLException {
            block7: {
                if (LoggingConnectionDecorator.this._warningAction == 0) {
                    return;
                }
                try {
                    this.handleSQLWarning(rs.getWarnings());
                }
                catch (SQLException warning) {
                    if (err != null) {
                        err.setNextException(warning);
                        break block7;
                    }
                    throw warning;
                }
                finally {
                    rs.clearWarnings();
                }
            }
        }

        private void handleSQLWarning(SQLWarning warning) throws SQLException {
            if (warning == null) {
                return;
            }
            if (LoggingConnectionDecorator.this._warningAction == 0) {
                return;
            }
            Log log = LoggingConnectionDecorator.this._logs.getJDBCLog();
            while (warning != null) {
                switch (LoggingConnectionDecorator.this._warningAction) {
                    case 1: {
                        if (!log.isTraceEnabled()) break;
                        log.trace(warning);
                        break;
                    }
                    case 2: {
                        if (!log.isInfoEnabled()) break;
                        log.info(warning);
                        break;
                    }
                    case 3: {
                        if (!log.isWarnEnabled()) break;
                        log.warn(warning);
                        break;
                    }
                    case 4: {
                        if (!log.isErrorEnabled()) break;
                        log.error(warning);
                        break;
                    }
                    case 5: {
                        throw warning;
                    }
                    case 6: {
                        if (LoggingConnectionDecorator.this._warningHandler == null) break;
                        LoggingConnectionDecorator.this._warningHandler.handleWarning(warning);
                        break;
                    }
                }
                warning = warning.getNextWarning();
            }
        }

        protected abstract class LoggingCallableStatement
        extends DelegatingCallableStatement {
            private final String _sql;
            private List<String> _params;
            private List<List<String>> _paramBatch;
            int batchedRowsBaseIndex;

            public LoggingCallableStatement(CallableStatement stmt, String sql2) throws SQLException {
                super(stmt, LoggingConnection.this);
                this._params = null;
                this._paramBatch = null;
                this.batchedRowsBaseIndex = 0;
                this._sql = sql2;
            }

            private LoggingResultSet newLoggingResultSet(ResultSet rs, CallableStatement stmnt) {
                return ConcreteClassGenerator.newInstance(loggingResultSetImpl, LoggingConnection.class, LoggingConnection.this, ResultSet.class, rs, CallableStatement.class, stmnt);
            }

            protected ResultSet wrapResult(ResultSet rs, boolean wrap) {
                if (!wrap || rs == null) {
                    return super.wrapResult(wrap, rs);
                }
                return this.newLoggingResultSet(rs, this);
            }

            protected ResultSet executeQuery(String sql2, boolean wrap) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    ResultSet resultSet = super.executeQuery(sql2, wrap);
                    return resultSet;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public int executeUpdate(String sql2) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    int n = super.executeUpdate(sql2);
                    return n;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean execute(String sql2) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    boolean bl = super.execute(sql2);
                    return bl;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            protected ResultSet executeQuery(boolean wrap) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    ResultSet resultSet = super.executeQuery(wrap);
                    return resultSet;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public int executeUpdate() throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    int n = super.executeUpdate();
                    return n;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public int[] executeBatch() throws SQLException {
                int[] nArray;
                int indexOfFirstFailedObject = -1;
                LoggingConnection.this.logBatchSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    int[] toReturn = super.executeBatch();
                    if (this._paramBatch != null) {
                        this.batchedRowsBaseIndex = this._paramBatch.size();
                    }
                    nArray = toReturn;
                }
                catch (SQLException se) {
                    try {
                        int[] count;
                        if (se instanceof BatchUpdateException && this._paramBatch != null && this.shouldTrackParameters() && (count = ((BatchUpdateException)se).getUpdateCounts()) != null && count.length <= this._paramBatch.size()) {
                            for (int i = 0; i < count.length; ++i) {
                                if (count[i] != -3) continue;
                                indexOfFirstFailedObject = i;
                                break;
                            }
                            if (indexOfFirstFailedObject == -1) {
                                indexOfFirstFailedObject = count.length;
                            }
                            if ((indexOfFirstFailedObject += this.batchedRowsBaseIndex) < this._paramBatch.size()) {
                                this._params = this._paramBatch.get(indexOfFirstFailedObject);
                            }
                        }
                        err = LoggingConnectionDecorator.this.wrap(se, this, indexOfFirstFailedObject);
                        throw err;
                    }
                    catch (Throwable throwable) {
                        LoggingConnection.this.logTime(start);
                        LoggingConnection.this.handleSQLErrors(this, err);
                        throw throwable;
                    }
                }
                LoggingConnection.this.logTime(start);
                LoggingConnection.this.handleSQLErrors(this, err);
                return nArray;
            }

            public boolean execute() throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    boolean bl = super.execute();
                    return bl;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public void cancel() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("cancel " + this + ": " + this._sql, LoggingConnection.this);
                }
                super.cancel();
            }

            public void setNull(int i1, int i2) throws SQLException {
                this.setLogParameter(i1, "null", null);
                super.setNull(i1, i2);
            }

            public void setBoolean(int i, boolean b) throws SQLException {
                this.setLogParameter(i, b);
                super.setBoolean(i, b);
            }

            public void setByte(int i, byte b) throws SQLException {
                this.setLogParameter(i, b);
                super.setByte(i, b);
            }

            public void setShort(int i, short s) throws SQLException {
                this.setLogParameter(i, s);
                super.setShort(i, s);
            }

            public void setInt(int i1, int i2) throws SQLException {
                this.setLogParameter(i1, i2);
                super.setInt(i1, i2);
            }

            public void setLong(int i, long l) throws SQLException {
                this.setLogParameter(i, l);
                super.setLong(i, l);
            }

            public void setFloat(int i, float f) throws SQLException {
                this.setLogParameter(i, f);
                super.setFloat(i, f);
            }

            public void setDouble(int i, double d) throws SQLException {
                this.setLogParameter(i, d);
                super.setDouble(i, d);
            }

            public void setBigDecimal(int i, BigDecimal bd) throws SQLException {
                this.setLogParameter(i, "BigDecimal", bd);
                super.setBigDecimal(i, bd);
            }

            public void setString(int i, String s) throws SQLException {
                this.setLogParameter(i, "String", s);
                super.setString(i, s);
            }

            public void setBytes(int i, byte[] b) throws SQLException {
                this.setLogParameter(i, "byte[]", b);
                super.setBytes(i, b);
            }

            public void setDate(int i, Date d) throws SQLException {
                this.setLogParameter(i, "Date", d);
                super.setDate(i, d);
            }

            public void setTime(int i, Time t) throws SQLException {
                this.setLogParameter(i, "Time", t);
                super.setTime(i, t);
            }

            public void setTimestamp(int i, Timestamp t) throws SQLException {
                this.setLogParameter(i, "Timestamp", t);
                super.setTimestamp(i, t);
            }

            public void setAsciiStream(int i1, InputStream is, int i2) throws SQLException {
                this.setLogParameter(i1, "InputStream", is);
                super.setAsciiStream(i1, is, i2);
            }

            @Deprecated
            public void setUnicodeStream(int i1, InputStream is, int i2) throws SQLException {
                this.setLogParameter(i1, "InputStream", is);
                super.setUnicodeStream(i2, is, i2);
            }

            public void setBinaryStream(int i1, InputStream is, int i2) throws SQLException {
                this.setLogParameter(i1, "InputStream", is);
                super.setBinaryStream(i1, is, i2);
            }

            public void clearParameters() throws SQLException {
                this.clearLogParameters(false);
                super.clearParameters();
            }

            public void setObject(int i1, Object o, int i2, int i3) throws SQLException {
                this.setLogParameter(i1, "Object", o);
                super.setObject(i1, o, i2, i3);
            }

            public void setObject(int i1, Object o, int i2) throws SQLException {
                this.setLogParameter(i1, "Object", o);
                super.setObject(i1, o, i2);
            }

            public void setObject(int i, Object o) throws SQLException {
                this.setLogParameter(i, "Object", o);
                super.setObject(i, o);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addBatch() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isSQLEnabled()) {
                    LoggingConnectionDecorator.this._logs.logSQL("batching " + this, LoggingConnection.this);
                }
                long start = System.currentTimeMillis();
                try {
                    super.addBatch();
                    if (this.shouldTrackParameters()) {
                        if (this._paramBatch == null) {
                            this._paramBatch = new ArrayList<List<String>>();
                        }
                        if (this._params != null) {
                            ArrayList<String> copyParams = new ArrayList<String>(this._params);
                            this._paramBatch.add(copyParams);
                        } else {
                            this._paramBatch.add(null);
                        }
                    }
                }
                finally {
                    LoggingConnection.this.logTime(start);
                }
            }

            public void setCharacterStream(int i1, Reader r, int i2) throws SQLException {
                this.setLogParameter(i1, "Reader", r);
                super.setCharacterStream(i1, r, i2);
            }

            public void setRef(int i, Ref r) throws SQLException {
                this.setLogParameter(i, "Ref", r);
                super.setRef(i, r);
            }

            public void setBlob(int i, Blob b) throws SQLException {
                this.setLogParameter(i, "Blob", b);
                super.setBlob(i, b);
            }

            public void setClob(int i, Clob c) throws SQLException {
                this.setLogParameter(i, "Clob", c);
                super.setClob(i, c);
            }

            public void setArray(int i, Array a) throws SQLException {
                this.setLogParameter(i, "Array", a);
                super.setArray(i, a);
            }

            public ResultSetMetaData getMetaData() throws SQLException {
                return super.getMetaData();
            }

            public void setDate(int i, Date d, Calendar c) throws SQLException {
                this.setLogParameter(i, "Date", d);
                super.setDate(i, d, c);
            }

            public void setTime(int i, Time t, Calendar c) throws SQLException {
                this.setLogParameter(i, "Time", t);
                super.setTime(i, t, c);
            }

            public void setTimestamp(int i, Timestamp t, Calendar c) throws SQLException {
                this.setLogParameter(i, "Timestamp", t);
                super.setTimestamp(i, t, c);
            }

            public void setNull(int i1, int i2, String s) throws SQLException {
                this.setLogParameter(i1, "null", null);
                super.setNull(i1, i2, s);
            }

            protected void appendInfo(StringBuffer buf) {
                buf.append(" ");
                if (LoggingConnectionDecorator.this._formatter != null) {
                    buf.append(SEP);
                    buf.append(LoggingConnectionDecorator.this._formatter.prettyPrint(this._sql));
                    buf.append(SEP);
                } else {
                    buf.append(this._sql);
                }
                StringBuilder paramBuf = null;
                if (this._params != null && !this._params.isEmpty()) {
                    paramBuf = new StringBuilder();
                    Iterator<String> itr = this._params.iterator();
                    while (itr.hasNext()) {
                        paramBuf.append(itr.next());
                        if (!itr.hasNext()) continue;
                        paramBuf.append(", ");
                    }
                }
                if (paramBuf != null) {
                    if (!LoggingConnectionDecorator.this._prettyPrint) {
                        buf.append(" ");
                    }
                    buf.append("[params=").append(paramBuf.toString()).append("]");
                }
                super.appendInfo(buf);
            }

            protected void clearLogParameters(boolean batch) {
                if (this._params != null) {
                    this._params.clear();
                }
                if (batch && this._paramBatch != null) {
                    this._paramBatch.clear();
                }
            }

            private boolean shouldTrackParameters() {
                return LoggingConnectionDecorator.this._trackParameters || LoggingConnectionDecorator.this._logs.isSQLEnabled();
            }

            private void setLogParameter(int index, boolean val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(boolean) " + val);
                }
            }

            private void setLogParameter(int index, byte val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(byte) " + val);
                }
            }

            private void setLogParameter(int index, double val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(double) " + val);
                }
            }

            private void setLogParameter(int index, float val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(float) " + val);
                }
            }

            private void setLogParameter(int index, int val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(int) " + val);
                }
            }

            private void setLogParameter(int index, long val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(long) " + val);
                }
            }

            private void setLogParameter(int index, short val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(short) " + val);
                }
            }

            private void setLogParameter(int index, String type, Object val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(" + type + ") " + val);
                }
            }

            private void setLogParameter(int index, String val) {
                if (this._params == null) {
                    this._params = new ArrayList<String>();
                }
                while (this._params.size() < index) {
                    this._params.add(null);
                }
                if (val.length() > 80) {
                    val = val.substring(0, 77) + "...";
                }
                this._params.set(index - 1, val);
            }
        }

        protected abstract class LoggingResultSet
        extends DelegatingResultSet {
            public LoggingResultSet(ResultSet rs, Statement stmnt) {
                super(rs, stmnt);
            }

            public boolean next() throws SQLException {
                SQLException err = null;
                try {
                    boolean bl = super.next();
                    return bl;
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public void close() throws SQLException {
                SQLException err = null;
                try {
                    super.close();
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public void beforeFirst() throws SQLException {
                SQLException err = null;
                try {
                    super.beforeFirst();
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public void afterLast() throws SQLException {
                SQLException err = null;
                try {
                    super.afterLast();
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean first() throws SQLException {
                SQLException err = null;
                try {
                    boolean bl = super.first();
                    return bl;
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean last() throws SQLException {
                SQLException err = null;
                try {
                    boolean bl = super.last();
                    return bl;
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean absolute(int a) throws SQLException {
                SQLException err = null;
                try {
                    boolean bl = super.absolute(a);
                    return bl;
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean relative(int a) throws SQLException {
                SQLException err = null;
                try {
                    boolean bl = super.relative(a);
                    return bl;
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean previous() throws SQLException {
                SQLException err = null;
                try {
                    boolean bl = super.previous();
                    return bl;
                }
                catch (SQLException se) {
                    err = se;
                    throw se;
                }
                finally {
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }
        }

        protected abstract class LoggingPreparedStatement
        extends DelegatingPreparedStatement {
            private final String _sql;
            private List<String> _params;
            private List<List<String>> _paramBatch;
            int batchedRowsBaseIndex;

            public LoggingPreparedStatement(PreparedStatement stmnt, String sql2) throws SQLException {
                super(stmnt, LoggingConnection.this);
                this._params = null;
                this._paramBatch = null;
                this.batchedRowsBaseIndex = 0;
                this._sql = sql2;
            }

            private LoggingResultSet newLoggingResultSet(ResultSet rs, PreparedStatement stmnt) {
                return ConcreteClassGenerator.newInstance(loggingResultSetImpl, LoggingConnection.class, LoggingConnection.this, ResultSet.class, rs, PreparedStatement.class, stmnt);
            }

            protected ResultSet wrapResult(ResultSet rs, boolean wrap) {
                if (!wrap || rs == null) {
                    return super.wrapResult(rs, wrap);
                }
                return this.newLoggingResultSet(rs, this);
            }

            protected ResultSet executeQuery(String sql2, boolean wrap) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    ResultSet resultSet = super.executeQuery(sql2, wrap);
                    return resultSet;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public int executeUpdate(String sql2) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    int n = super.executeUpdate(sql2);
                    return n;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean execute(String sql2) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    boolean bl = super.execute(sql2);
                    return bl;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            protected ResultSet executeQuery(boolean wrap) throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    ResultSet resultSet = super.executeQuery(wrap);
                    return resultSet;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, this._sql);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public int executeUpdate() throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    int n = super.executeUpdate();
                    return n;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public int[] executeBatch() throws SQLException {
                int[] nArray;
                int indexOfFirstFailedObject = -1;
                LoggingConnection.this.logBatchSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    int[] toReturn = super.executeBatch();
                    if (this._paramBatch != null) {
                        this.batchedRowsBaseIndex = this._paramBatch.size();
                    }
                    nArray = toReturn;
                }
                catch (SQLException se) {
                    try {
                        int[] count;
                        if (se instanceof BatchUpdateException && this._paramBatch != null && this.shouldTrackParameters() && (count = ((BatchUpdateException)se).getUpdateCounts()) != null && count.length <= this._paramBatch.size()) {
                            for (int i = 0; i < count.length; ++i) {
                                if (count[i] != -3) continue;
                                indexOfFirstFailedObject = i;
                                break;
                            }
                            if (indexOfFirstFailedObject == -1) {
                                indexOfFirstFailedObject = count.length;
                            }
                            if ((indexOfFirstFailedObject += this.batchedRowsBaseIndex) < this._paramBatch.size()) {
                                this._params = this._paramBatch.get(indexOfFirstFailedObject);
                            }
                        }
                        err = LoggingConnectionDecorator.this.wrap(se, this, indexOfFirstFailedObject);
                        throw err;
                    }
                    catch (Throwable throwable) {
                        LoggingConnection.this.logTime(start);
                        LoggingConnection.this.handleSQLErrors(this, err);
                        throw throwable;
                    }
                }
                LoggingConnection.this.logTime(start);
                LoggingConnection.this.handleSQLErrors(this, err);
                return nArray;
            }

            public boolean execute() throws SQLException {
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    boolean bl = super.execute();
                    return bl;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    this.clearLogParameters(true);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public void cancel() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("cancel " + this + ": " + this._sql, LoggingConnection.this);
                }
                super.cancel();
            }

            public void setNull(int i1, int i2) throws SQLException {
                this.setLogParameter(i1, "null", null);
                super.setNull(i1, i2);
            }

            public void setBoolean(int i, boolean b) throws SQLException {
                this.setLogParameter(i, b);
                super.setBoolean(i, b);
            }

            public void setByte(int i, byte b) throws SQLException {
                this.setLogParameter(i, b);
                super.setByte(i, b);
            }

            public void setShort(int i, short s) throws SQLException {
                this.setLogParameter(i, s);
                super.setShort(i, s);
            }

            public void setInt(int i1, int i2) throws SQLException {
                this.setLogParameter(i1, i2);
                super.setInt(i1, i2);
            }

            public void setLong(int i, long l) throws SQLException {
                this.setLogParameter(i, l);
                super.setLong(i, l);
            }

            public void setFloat(int i, float f) throws SQLException {
                this.setLogParameter(i, f);
                super.setFloat(i, f);
            }

            public void setDouble(int i, double d) throws SQLException {
                this.setLogParameter(i, d);
                super.setDouble(i, d);
            }

            public void setBigDecimal(int i, BigDecimal bd) throws SQLException {
                this.setLogParameter(i, "BigDecimal", bd);
                super.setBigDecimal(i, bd);
            }

            public void setString(int i, String s) throws SQLException {
                this.setLogParameter(i, "String", s);
                super.setString(i, s);
            }

            public void setBytes(int i, byte[] b) throws SQLException {
                this.setLogParameter(i, "byte[]", b);
                super.setBytes(i, b);
            }

            public void setDate(int i, Date d) throws SQLException {
                this.setLogParameter(i, "Date", d);
                super.setDate(i, d);
            }

            public void setTime(int i, Time t) throws SQLException {
                this.setLogParameter(i, "Time", t);
                super.setTime(i, t);
            }

            public void setTimestamp(int i, Timestamp t) throws SQLException {
                this.setLogParameter(i, "Timestamp", t);
                super.setTimestamp(i, t);
            }

            public void setAsciiStream(int i1, InputStream is, int i2) throws SQLException {
                this.setLogParameter(i1, "InputStream", is);
                super.setAsciiStream(i1, is, i2);
            }

            @Deprecated
            public void setUnicodeStream(int i1, InputStream is, int i2) throws SQLException {
                this.setLogParameter(i1, "InputStream", is);
                super.setUnicodeStream(i2, is, i2);
            }

            public void setBinaryStream(int i1, InputStream is, int i2) throws SQLException {
                this.setLogParameter(i1, "InputStream", is);
                super.setBinaryStream(i1, is, i2);
            }

            public void clearParameters() throws SQLException {
                this.clearLogParameters(false);
                super.clearParameters();
            }

            public void setObject(int i1, Object o, int i2, int i3) throws SQLException {
                this.setLogParameter(i1, "Object", o);
                super.setObject(i1, o, i2, i3);
            }

            public void setObject(int i1, Object o, int i2) throws SQLException {
                this.setLogParameter(i1, "Object", o);
                super.setObject(i1, o, i2);
            }

            public void setObject(int i, Object o) throws SQLException {
                this.setLogParameter(i, "Object", o);
                super.setObject(i, o);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addBatch() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isSQLEnabled()) {
                    LoggingConnectionDecorator.this._logs.logSQL("batching " + this, LoggingConnection.this);
                }
                long start = System.currentTimeMillis();
                try {
                    super.addBatch();
                    if (this.shouldTrackParameters()) {
                        if (this._paramBatch == null) {
                            this._paramBatch = new ArrayList<List<String>>();
                        }
                        if (this._params != null) {
                            ArrayList<String> copyParms = new ArrayList<String>(this._params);
                            this._paramBatch.add(copyParms);
                        } else {
                            this._paramBatch.add(null);
                        }
                    }
                }
                finally {
                    LoggingConnection.this.logTime(start);
                }
            }

            public void setCharacterStream(int i1, Reader r, int i2) throws SQLException {
                this.setLogParameter(i1, "Reader", r);
                super.setCharacterStream(i1, r, i2);
            }

            public void setRef(int i, Ref r) throws SQLException {
                this.setLogParameter(i, "Ref", r);
                super.setRef(i, r);
            }

            public void setBlob(int i, Blob b) throws SQLException {
                this.setLogParameter(i, "Blob", b);
                super.setBlob(i, b);
            }

            public void setClob(int i, Clob c) throws SQLException {
                this.setLogParameter(i, "Clob", c);
                super.setClob(i, c);
            }

            public void setArray(int i, Array a) throws SQLException {
                this.setLogParameter(i, "Array", a);
                super.setArray(i, a);
            }

            public ResultSetMetaData getMetaData() throws SQLException {
                return super.getMetaData();
            }

            public void setDate(int i, Date d, Calendar c) throws SQLException {
                this.setLogParameter(i, "Date", d);
                super.setDate(i, d, c);
            }

            public void setTime(int i, Time t, Calendar c) throws SQLException {
                this.setLogParameter(i, "Time", t);
                super.setTime(i, t, c);
            }

            public void setTimestamp(int i, Timestamp t, Calendar c) throws SQLException {
                this.setLogParameter(i, "Timestamp", t);
                super.setTimestamp(i, t, c);
            }

            public void setNull(int i1, int i2, String s) throws SQLException {
                this.setLogParameter(i1, "null", null);
                super.setNull(i1, i2, s);
            }

            protected void appendInfo(StringBuffer buf) {
                buf.append(" ");
                if (LoggingConnectionDecorator.this._formatter != null) {
                    buf.append(SEP);
                    buf.append(LoggingConnectionDecorator.this._formatter.prettyPrint(this._sql));
                    buf.append(SEP);
                } else {
                    buf.append(this._sql);
                }
                StringBuilder paramBuf = null;
                if (this._params != null && !this._params.isEmpty()) {
                    paramBuf = new StringBuilder();
                    Iterator<String> itr = this._params.iterator();
                    while (itr.hasNext()) {
                        paramBuf.append(itr.next());
                        if (!itr.hasNext()) continue;
                        paramBuf.append(", ");
                    }
                }
                if (paramBuf != null) {
                    if (!LoggingConnectionDecorator.this._prettyPrint) {
                        buf.append(" ");
                    }
                    buf.append("[params=").append(paramBuf.toString()).append("]");
                }
                super.appendInfo(buf);
            }

            private void clearLogParameters(boolean batch) {
                if (this._params != null) {
                    this._params.clear();
                }
                if (batch && this._paramBatch != null) {
                    this._paramBatch.clear();
                }
            }

            private boolean shouldTrackParameters() {
                return LoggingConnectionDecorator.this._trackParameters || LoggingConnectionDecorator.this._logs.isSQLEnabled();
            }

            private void setLogParameter(int index, boolean val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(boolean) " + val);
                }
            }

            private void setLogParameter(int index, byte val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(byte) " + val);
                }
            }

            private void setLogParameter(int index, double val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(double) " + val);
                }
            }

            private void setLogParameter(int index, float val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(float) " + val);
                }
            }

            private void setLogParameter(int index, int val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(int) " + val);
                }
            }

            private void setLogParameter(int index, long val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(long) " + val);
                }
            }

            private void setLogParameter(int index, short val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(short) " + val);
                }
            }

            private void setLogParameter(int index, String type, Object val) {
                if (this.shouldTrackParameters()) {
                    this.setLogParameter(index, "(" + type + ") " + val);
                }
            }

            private void setLogParameter(int index, String val) {
                if (this._params == null) {
                    this._params = new ArrayList<String>();
                }
                while (this._params.size() < index) {
                    this._params.add(null);
                }
                if (val.length() > 80) {
                    val = val.substring(0, 77) + "...";
                }
                this._params.set(index - 1, val);
            }
        }

        protected abstract class LoggingStatement
        extends DelegatingStatement {
            private String _sql;

            public LoggingStatement(Statement stmnt) throws SQLException {
                super(stmnt, LoggingConnection.this);
                this._sql = null;
            }

            private LoggingResultSet newLoggingResultSet(ResultSet rs, Statement stmnt) {
                return ConcreteClassGenerator.newInstance(loggingResultSetImpl, LoggingConnection.this, rs, stmnt);
            }

            public void appendInfo(StringBuffer buf) {
                if (this._sql != null) {
                    buf.append(" ");
                    if (LoggingConnectionDecorator.this._formatter != null) {
                        buf.append(SEP);
                        buf.append(LoggingConnectionDecorator.this._formatter.prettyPrint(this._sql));
                    } else {
                        buf.append(this._sql);
                    }
                }
            }

            protected ResultSet wrapResult(ResultSet rs, boolean wrap) {
                if (!wrap || rs == null) {
                    return super.wrapResult(rs, wrap);
                }
                return this.newLoggingResultSet(rs, this);
            }

            public void cancel() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("cancel " + this, LoggingConnection.this);
                }
                super.cancel();
            }

            protected ResultSet executeQuery(String sql2, boolean wrap) throws SQLException {
                this._sql = sql2;
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    ResultSet resultSet = super.executeQuery(sql2, wrap);
                    return resultSet;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public int executeUpdate(String sql2) throws SQLException {
                this._sql = sql2;
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    int n = super.executeUpdate(sql2);
                    return n;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }

            public boolean execute(String sql2) throws SQLException {
                this._sql = sql2;
                LoggingConnection.this.logSQL(this);
                long start = System.currentTimeMillis();
                SQLException err = null;
                try {
                    boolean bl = super.execute(sql2);
                    return bl;
                }
                catch (SQLException se) {
                    err = LoggingConnectionDecorator.this.wrap(se, this, sql2);
                    throw err;
                }
                finally {
                    LoggingConnection.this.logTime(start);
                    LoggingConnection.this.handleSQLErrors(this, err);
                }
            }
        }

        protected abstract class LoggingDatabaseMetaData
        extends DelegatingDatabaseMetaData {
            public LoggingDatabaseMetaData(DatabaseMetaData meta) {
                super(meta, LoggingConnection.this);
            }

            public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getBestRowIdentifier: " + catalog + ", " + schema + ", " + table, LoggingConnection.this);
                }
                return super.getBestRowIdentifier(catalog, schema, table, scope, nullable);
            }

            public ResultSet getCatalogs() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getCatalogs", LoggingConnection.this);
                }
                return super.getCatalogs();
            }

            public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getColumnPrivileges: " + catalog + ", " + schema + ", " + table, LoggingConnection.this);
                }
                return super.getColumnPrivileges(catalog, schema, table, columnNamePattern);
            }

            public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getColumns: " + catalog + ", " + schemaPattern + ", " + tableNamePattern + ", " + columnNamePattern, LoggingConnection.this);
                }
                return super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }

            public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getCrossReference: " + primaryCatalog + ", " + primarySchema + ", " + primaryTable + ", " + foreignCatalog + ", " + foreignSchema + ", " + foreignSchema, LoggingConnection.this);
                }
                return super.getCrossReference(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
            }

            public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getExportedKeys: " + catalog + ", " + schema + ", " + table, LoggingConnection.this);
                }
                return super.getExportedKeys(catalog, schema, table);
            }

            public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getImportedKeys: " + catalog + ", " + schema + ", " + table, LoggingConnection.this);
                }
                return super.getImportedKeys(catalog, schema, table);
            }

            public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getIndexInfo: " + catalog + ", " + schema + ", " + table, LoggingConnection.this);
                }
                return super.getIndexInfo(catalog, schema, table, unique, approximate);
            }

            public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getPrimaryKeys: " + catalog + ", " + schema + ", " + table, LoggingConnection.this);
                }
                return super.getPrimaryKeys(catalog, schema, table);
            }

            public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getProcedureColumns: " + catalog + ", " + schemaPattern + ", " + procedureNamePattern + ", " + columnNamePattern, LoggingConnection.this);
                }
                return super.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }

            public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getProcedures: " + catalog + ", " + schemaPattern + ", " + procedureNamePattern, LoggingConnection.this);
                }
                return super.getProcedures(catalog, schemaPattern, procedureNamePattern);
            }

            public ResultSet getSchemas() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getSchemas", LoggingConnection.this);
                }
                return super.getSchemas();
            }

            public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getTablePrivileges", LoggingConnection.this);
                }
                return super.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
            }

            public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getTables: " + catalog + ", " + schemaPattern + ", " + tableNamePattern, LoggingConnection.this);
                }
                return super.getTables(catalog, schemaPattern, tableNamePattern, types);
            }

            public ResultSet getTableTypes() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getTableTypes", LoggingConnection.this);
                }
                return super.getTableTypes();
            }

            public ResultSet getTypeInfo() throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getTypeInfo", LoggingConnection.this);
                }
                return super.getTypeInfo();
            }

            public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getUDTs", LoggingConnection.this);
                }
                return super.getUDTs(catalog, schemaPattern, typeNamePattern, types);
            }

            public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
                if (LoggingConnectionDecorator.this._logs.isJDBCEnabled()) {
                    LoggingConnectionDecorator.this._logs.logJDBC("getVersionColumns: " + catalog + ", " + schema + ", " + table, LoggingConnection.this);
                }
                return super.getVersionColumns(catalog, schema, table);
            }
        }
    }

    public static interface SQLWarningHandler {
        public void handleWarning(SQLWarning var1) throws SQLException;
    }
}

