/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.basic.ObjectType;
import org.apache.cxf.aegis.type.encoded.MarshalRegistry;
import org.apache.cxf.aegis.type.encoded.SoapEncodingUtil;
import org.apache.cxf.aegis.type.encoded.SoapRefRegistry;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrailingBlocks {
    private ObjectType objectType;

    public TrailingBlocks() {
        this.objectType = new ObjectType();
        this.objectType.setReadToDocument(false);
        this.objectType.setSerializedWhenUnknown(false);
    }

    public TrailingBlocks(TypeMapping typeMapping) {
        this();
        this.objectType.setTypeMapping(typeMapping);
    }

    public TrailingBlocks(ObjectType objectType) {
        this.objectType = objectType;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public List<Object> readBlocks(MessageReader reader, Context context) throws DatabindingException {
        ArrayList<Object> blocks = new ArrayList<Object>();
        while (reader.hasMoreElementReaders()) {
            MessageReader creader = reader.getNextElementReader();
            String id = SoapEncodingUtil.readId(creader);
            if (id == null) {
                throw new DatabindingException("Trailing block does not contain a SOAP id attribute " + creader.getName());
            }
            Object instance = this.objectType.readObject(creader, context);
            blocks.add(instance);
            SoapRefRegistry.get(context).addInstance(id, instance);
            creader.readToEnd();
        }
        return blocks;
    }

    public List<Object> writeBlocks(MessageWriter writer, Context context) {
        ArrayList<Object> blocks = new ArrayList<Object>();
        for (Object instance : MarshalRegistry.get(context)) {
            Type type = this.objectType.determineType(context, instance.getClass());
            if (type == null) {
                TypeMapping tm = context.getTypeMapping();
                if (tm == null) {
                    tm = this.objectType.getTypeMapping();
                }
                type = tm.getTypeCreator().createType(instance.getClass());
                tm.register(type);
            }
            MessageWriter cwriter = writer.getElementWriter(type.getSchemaType());
            String id = MarshalRegistry.get(context).getInstanceId(instance);
            SoapEncodingUtil.writeId(cwriter, id);
            this.objectType.writeObject(instance, cwriter, context);
            blocks.add(instance);
            cwriter.close();
        }
        return blocks;
    }
}

