/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.monitoring.MonitoringTimerTask;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;

public class FileMonitoringTimerTask
extends MonitoringTimerTask {
    public static final String MONITORING_CONFIG_PERIOD_PROPERTY = "FILE_MONITORING_CONFIG_PERIOD";
    public static final long DEFAULT_MONITORING_CONFIG_PERIOD = 60000L;
    public static final String MONITORING_CONFIG_PATH_PROPERTY = "FILE_MONITORING_CONFIG_PATH";
    public static final String DEFAULT_MONITORING_CONFIG_PATH = "fileMonitoring.props";
    public static final String MONITORING_RESULT_PATH_PROPERTY = "FILE_MONITORING_RESULT_PATH";
    public static final String DEFAULT_MONITORING_RESULT_PATH = "monitoringStats.csv";
    FileWriter writer;
    StringBuffer strbuf = null;

    public FileMonitoringTimerTask(Timer timer, long period, Properties attlist, String path) {
        super(period, attlist);
        try {
            this.writer = new FileWriter(path, true);
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)("FileMonitoringTimerTask.<init>, cannot open file \"" + path + "\""), (Throwable)exc);
        }
        this.strbuf = new StringBuffer();
        this.start(timer);
    }

    protected void initializeRecords() {
        this.strbuf.append(System.currentTimeMillis()).append(';');
    }

    protected void addRecord(ObjectName mbean, String att, Object value) {
        this.strbuf.append(mbean).append(':').append(att).append(';').append(value).append(';');
    }

    protected void finalizeRecords() {
        this.strbuf.append('\n');
        try {
            this.writer.write(this.strbuf.toString());
            this.writer.flush();
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)"FileMonitoringTimerTask.finalizeRecords, cannot write records.", (Throwable)exc);
        }
        this.strbuf.setLength(0);
    }
}

