/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.basic.clue;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.IllegalTimeoutException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.WaiterInterruptedException;
import org.ow2.util.pool.impl.enhanced.api.basic.IPoolItemFactory;
import org.ow2.util.pool.impl.enhanced.api.basic.IPoolItemRemoveListener;
import org.ow2.util.pool.impl.enhanced.api.basic.PoolFactoryBroken;
import org.ow2.util.pool.impl.enhanced.api.basic.clue.IBasicCluePool;
import org.ow2.util.pool.impl.enhanced.api.basic.clue.accessmanager.IClueAccessManager;
import org.ow2.util.pool.impl.enhanced.impl.PoolError;
import org.ow2.util.pool.impl.enhanced.impl.basic.BasicPool;
import org.ow2.util.pool.impl.enhanced.internal.lock.api.ISignalClearableCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCluePool<E, C>
extends BasicPool<E>
implements IBasicCluePool<E, C> {
    private static final Log LOG = LogFactory.getLog(BasicCluePool.class);
    private List<E> availablePoolItemList;
    private List<E> unmodifiableAvailablePoolItemList;
    private IClueAccessManager<? super E, ? super C> clueAccessManager;
    private Lock lock;
    private ISignalClearableCondition signalClearableCondition;

    public BasicCluePool(IPoolItemFactory<? extends E> poolItemFactory, int initPoolSize, IClueAccessManager<? super E, ? super C> clueAccessManager, Executor createItemExecutor, IPoolItemRemoveListener<? super E> poolItemRemoveCB, Executor removeItemExecutor) {
        super(poolItemFactory, initPoolSize, clueAccessManager, createItemExecutor, poolItemRemoveCB, removeItemExecutor);
        this.clueAccessManager = clueAccessManager;
        this.availablePoolItemList = this.getAvailablePoolItemList();
        this.unmodifiableAvailablePoolItemList = this.getUnmodifiableAvailablePoolItemList();
        this.lock = this.getLock();
        this.signalClearableCondition = this.getSignalClearableCondition();
    }

    @Override
    public E get(IWaitControl timeout) throws TimeoutPoolException, IllegalTimeoutException, WaiterInterruptedException, PoolFactoryBroken, InterruptedException {
        return this.get(null, timeout);
    }

    @Override
    public E get(C clue) throws WaiterInterruptedException, PoolFactoryBroken, InterruptedException {
        try {
            return this.get(clue, INFINITE_WAIT_CONTROL);
        }
        catch (TimeoutPoolException e) {
            throw new PoolError("get(clue, INFINITE_TIMEOUT) should not return a TimeoutPoolException");
        }
        catch (IllegalTimeoutException e) {
            throw new PoolError("get(clue, INFINITE_TIMEOUT) should not return a IllegalTimeoutException");
        }
    }

    protected int getOneItem(C clue) {
        int position = 0;
        try {
            position = this.clueAccessManager.choosePoolItemToGet(this.unmodifiableAvailablePoolItemList, clue);
            if (position != -1 && (position < 0 || position >= this.unmodifiableAvailablePoolItemList.size())) {
                LOG.error((Object)"Access manager returns {0} which is an invalid value", new Object[]{position});
                position = 0;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Access manager exception", new Object[]{e});
        }
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E get(C clue, IWaitControl timeout) throws TimeoutPoolException, IllegalTimeoutException, WaiterInterruptedException, PoolFactoryBroken, InterruptedException {
        E poolItem;
        block23: {
            boolean delayed = false;
            this.lock.lock();
            try {
                int size = this.availablePoolItemList.size();
                int poolItemToGetChoosed = -1;
                if (size != 0) {
                    poolItemToGetChoosed = this.getOneItem(clue);
                    if (poolItemToGetChoosed == -1) {
                        this.setDelayedCount(this.getDelayedCount() + 1);
                        delayed = true;
                    }
                } else {
                    switch (this.getFactoryState()) {
                        case BROKEN: {
                            throw new PoolFactoryBroken(null);
                        }
                        case TEMPORARY_BROKEN: {
                            throw new PoolFactoryBroken(this.getTemporaryBrokenFactoryEndTime());
                        }
                        case WORKING: {
                            break;
                        }
                        default: {
                            throw new PoolError();
                        }
                    }
                }
                if (poolItemToGetChoosed == -1) {
                    if (!timeout.canContinueToWait()) {
                        throw new TimeoutPoolException();
                    }
                    block12: while (poolItemToGetChoosed == -1) {
                        if (!timeout.waitOnCondition(this.signalClearableCondition)) {
                            throw new TimeoutPoolException();
                        }
                        LOG.debug((Object)"wait notified or expired", new Object[0]);
                        size = this.availablePoolItemList.size();
                        if (size != 0) {
                            poolItemToGetChoosed = this.getOneItem(clue);
                            if (delayed || poolItemToGetChoosed != -1) continue;
                            this.setDelayedCount(this.getDelayedCount() + 1);
                            delayed = true;
                            continue;
                        }
                        if (delayed) {
                            this.setDelayedCount(this.getDelayedCount() - 1);
                            delayed = false;
                        }
                        switch (this.getFactoryState()) {
                            case BROKEN: {
                                throw new PoolFactoryBroken(null);
                            }
                            case TEMPORARY_BROKEN: {
                                throw new PoolFactoryBroken(this.getTemporaryBrokenFactoryEndTime());
                            }
                            case WORKING: {
                                continue block12;
                            }
                        }
                        throw new PoolError();
                    }
                }
                int usedPoolItem = this.getUsedPoolItem();
                this.setUsedPoolItem(++usedPoolItem);
                poolItem = this.availablePoolItemList.remove(poolItemToGetChoosed);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"pool {0}/{1} (used/total)", new Object[]{usedPoolItem, this.availablePoolItemList.size() + usedPoolItem});
                }
                Object var9_8 = null;
                if (!delayed) break block23;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (delayed) {
                    this.setDelayedCount(this.getDelayedCount() - 1);
                }
                this.lock.unlock();
                throw throwable;
            }
            this.setDelayedCount(this.getDelayedCount() - 1);
        }
        this.lock.unlock();
        return poolItem;
    }
}

