/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.stream.impl.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ow2.util.stream.api.IStreamAccessor;
import org.ow2.util.stream.impl.file.TemporaryOutputStream;

public class SystemFileAccessor
implements IStreamAccessor {
    private File file;

    public SystemFileAccessor(File file) {
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public OutputStream getTemporaryOutputStream() throws IOException {
        return new TemporaryOutputStream(File.createTempFile("SystemFileAccessor", ".data"), this.file);
    }

    public void delete() {
        this.file.delete();
    }

    public boolean exists() {
        return this.file.exists();
    }
}

