/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.messages;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.Properties;
import fr.dyade.aaa.common.stream.StreamUtil;
import fr.dyade.aaa.common.stream.Streamable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class Message
implements Cloneable,
Serializable,
Streamable {
    private static final long serialVersionUID = 2L;
    public static final int NON_PERSISTENT = 1;
    public static final int PERSISTENT = 2;
    public static final int DEFAULT_DELIVERY_MODE = 2;
    public static final int DEFAULT_PRIORITY = 4;
    public static final long DEFAULT_TIME_TO_LIVE = 0L;
    public static Logger logger = Debug.getLogger((String)Message.class.getName());
    public transient Properties optionalHeader = null;
    public transient byte[] body = null;
    public transient Properties properties = null;
    public transient String id = null;
    public transient boolean persistent = true;
    public static final int SIMPLE = 0;
    public static final int TEXT = 1;
    public static final int OBJECT = 2;
    public static final int MAP = 3;
    public static final int STREAM = 4;
    public static final int BYTES = 5;
    public static final int ADMIN = 6;
    public transient int type = 0;
    public transient int priority = 4;
    public transient long expiration = 0L;
    public transient long timestamp;
    public transient boolean redelivered = false;
    public static final byte TOPIC_TYPE = 1;
    public static final byte QUEUE_TYPE = 2;
    public transient String toId = null;
    public transient byte toType;
    public transient String replyToId = null;
    public transient byte replyToType;
    public transient String correlationId = null;
    public transient int deliveryCount = 0;
    public static int redeliveredFlag = 4;
    public static int persistentFlag = 8;

    public Object getOptionalHeader(String name) {
        if (this.optionalHeader == null) {
            return null;
        }
        return this.optionalHeader.get(name);
    }

    public void setOptionalHeader(String name, Object value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid header name: " + name);
        }
        if (value == null) {
            return;
        }
        if (this.optionalHeader == null) {
            this.optionalHeader = new Properties();
        }
        this.optionalHeader.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (value instanceof Boolean || value instanceof Number || value instanceof String) {
            this.properties.put(name, value);
        } else {
            this.properties.put(name, (Object)value.toString());
        }
    }

    public final void setDestination(String id, byte type) {
        this.toId = id;
        this.toType = type;
    }

    public final void setReplyTo(String id, byte type) {
        this.replyToId = id;
        this.replyToType = type;
    }

    public void setText(String text) {
        this.body = (byte[])(text == null ? null : text.getBytes());
    }

    public String getText() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body);
    }

    public void setObject(Serializable object) throws IOException {
        this.type = 2;
        if (object == null) {
            this.body = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            this.body = baos.toByteArray();
            oos.close();
            baos.close();
        }
    }

    public Serializable getObject() throws Exception {
        if (this.body == null) {
            return null;
        }
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        Object obj = null;
        try {
            try {
                bais = new ByteArrayInputStream(this.body);
                ois = new ObjectInputStream(bais);
                obj = ois.readObject();
            }
            catch (ClassNotFoundException cnfexc) {
                bais = new ByteArrayInputStream(this.body);
                class Specialized_OIS
                extends ObjectInputStream {
                    Specialized_OIS(InputStream is) throws IOException {
                        super(is);
                    }

                    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
                        String n = osc.getName();
                        return Class.forName(n, false, Thread.currentThread().getContextClassLoader());
                    }
                }
                ois = new Specialized_OIS(bais);
                obj = ois.readObject();
            }
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"ERROR: getObject()", (Throwable)exc);
            }
            throw exc;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {}
            try {
                bais.close();
            }
            catch (Exception e) {}
        }
        return (Serializable)obj;
    }

    public void setAdminMessage(AbstractAdminMessage adminMsg) throws IOException {
        this.type = 6;
        if (adminMsg == null) {
            this.body = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AbstractAdminMessage.write(adminMsg, baos);
            baos.flush();
            this.body = baos.toByteArray();
            baos.close();
        }
    }

    public AbstractAdminMessage getAdminMessage() {
        AbstractAdminMessage adminMsg;
        block3: {
            if (this.body == null) {
                return null;
            }
            ByteArrayInputStream bais = null;
            adminMsg = null;
            try {
                bais = new ByteArrayInputStream(this.body);
                adminMsg = AbstractAdminMessage.read(bais);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block3;
                logger.log(BasicLevel.ERROR, (Object)"ERROR: getAdminMessage()", (Throwable)e);
            }
        }
        return adminMsg;
    }

    public final String toString() {
        StringBuffer strbuf = new StringBuffer();
        this.toString(strbuf);
        return strbuf.toString();
    }

    public void toString(StringBuffer strbuf) {
        strbuf.append('(').append(super.toString());
        strbuf.append(",id=").append(this.id);
        strbuf.append(",type=").append(this.type);
        strbuf.append(",persistent=").append(this.persistent);
        strbuf.append(",priority=").append(this.priority);
        strbuf.append(",expiration=").append(this.expiration);
        strbuf.append(",timestamp=").append(this.timestamp);
        strbuf.append(",toId=").append(this.toId);
        strbuf.append(",replyToId=").append(this.replyToId);
        strbuf.append(",correlationId=").append(this.correlationId);
        strbuf.append(')');
    }

    public Object clone() {
        try {
            Message clone = (Message)super.clone();
            if (this.body != null) {
                clone.body = new byte[this.body.length];
                System.arraycopy(this.body, 0, clone.body, 0, this.body.length);
            }
            if (this.optionalHeader != null) {
                clone.optionalHeader = (Properties)this.optionalHeader.clone();
            }
            if (this.properties != null) {
                clone.properties = (Properties)this.properties.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException cE) {
            return null;
        }
    }

    public Hashtable soapCode() {
        Hashtable h = new Hashtable();
        return h;
    }

    public static Message soapDecode(Hashtable h) {
        return null;
    }

    public void writeTo(OutputStream os) throws IOException {
        this.writeHeaderTo(os);
        StreamUtil.writeTo((byte[])this.body, (OutputStream)os);
    }

    public void writeHeaderTo(OutputStream os) throws IOException {
        int bool = 0;
        StreamUtil.writeTo((int)this.type, (OutputStream)os);
        StreamUtil.writeTo((Properties)this.optionalHeader, (OutputStream)os);
        StreamUtil.writeTo((Properties)this.properties, (OutputStream)os);
        StreamUtil.writeTo((String)this.id, (OutputStream)os);
        StreamUtil.writeTo((int)this.priority, (OutputStream)os);
        StreamUtil.writeTo((String)this.toId, (OutputStream)os);
        StreamUtil.writeTo((byte)this.toType, (OutputStream)os);
        StreamUtil.writeTo((long)this.expiration, (OutputStream)os);
        StreamUtil.writeTo((String)this.replyToId, (OutputStream)os);
        StreamUtil.writeTo((byte)this.replyToType, (OutputStream)os);
        StreamUtil.writeTo((long)this.timestamp, (OutputStream)os);
        StreamUtil.writeTo((String)this.correlationId, (OutputStream)os);
        StreamUtil.writeTo((int)this.deliveryCount, (OutputStream)os);
        bool |= this.redelivered ? redeliveredFlag : 0;
        StreamUtil.writeTo((int)(bool |= this.persistent ? persistentFlag : 0), (OutputStream)os);
    }

    public void readFrom(InputStream is) throws IOException {
        this.readHeaderFrom(is);
        this.body = StreamUtil.readByteArrayFrom((InputStream)is);
    }

    public void readHeaderFrom(InputStream is) throws IOException {
        this.type = StreamUtil.readIntFrom((InputStream)is);
        this.optionalHeader = StreamUtil.readPropertiesFrom((InputStream)is);
        this.properties = StreamUtil.readPropertiesFrom((InputStream)is);
        this.id = StreamUtil.readStringFrom((InputStream)is);
        this.priority = StreamUtil.readIntFrom((InputStream)is);
        this.toId = StreamUtil.readStringFrom((InputStream)is);
        this.toType = StreamUtil.readByteFrom((InputStream)is);
        this.expiration = StreamUtil.readLongFrom((InputStream)is);
        this.replyToId = StreamUtil.readStringFrom((InputStream)is);
        this.replyToType = StreamUtil.readByteFrom((InputStream)is);
        this.timestamp = StreamUtil.readLongFrom((InputStream)is);
        this.correlationId = StreamUtil.readStringFrom((InputStream)is);
        this.deliveryCount = StreamUtil.readIntFrom((InputStream)is);
        int bool = StreamUtil.readIntFrom((InputStream)is);
        this.redelivered = (bool & redeliveredFlag) != 0;
        this.persistent = (bool & persistentFlag) != 0;
    }

    public static void writeVectorTo(Vector messages, OutputStream os) throws IOException {
        if (messages == null) {
            StreamUtil.writeTo((int)-1, (OutputStream)os);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"writeVectorTo: -1");
            }
        } else {
            int size = messages.size();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("writeVectorTo: " + size));
            }
            StreamUtil.writeTo((int)size, (OutputStream)os);
            for (int i = 0; i < size; ++i) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("writeVectorTo: msg#" + i));
                }
                ((Message)messages.elementAt(i)).writeTo(os);
            }
        }
    }

    public static Vector readVectorFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom((InputStream)is);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("readVectorFrom: " + size));
        }
        if (size == -1) {
            return null;
        }
        Vector<Message> messages = new Vector<Message>(size);
        for (int i = 0; i < size; ++i) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("readVectorFrom: msg#" + i));
            }
            Message msg = new Message();
            msg.readFrom(is);
            messages.addElement(msg);
        }
        return messages;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readFrom(in);
    }
}

