/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;

public class JMXProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected MBeanServer mBeanServer = null;
    protected Registry registry;

    public void init() throws ServletException {
        this.registry = Registry.getRegistry(null, null);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        if (this.mBeanServer == null) {
            writer.println("Error - No mbean server");
            return;
        }
        String qry = request.getParameter("set");
        if (qry != null) {
            String name = request.getParameter("att");
            String val = request.getParameter("val");
            this.setAttribute(writer, qry, name, val);
            return;
        }
        qry = request.getParameter("get");
        if (qry != null) {
            String name = request.getParameter("att");
            this.getAttribute(writer, qry, name);
            return;
        }
        qry = request.getParameter("qry");
        if (qry == null) {
            qry = "*:*";
        }
        this.listBeans(writer, qry);
    }

    public void getAttribute(PrintWriter writer, String onameStr, String att) {
        try {
            ObjectName oname = new ObjectName(onameStr);
            Object value = this.mBeanServer.getAttribute(oname, att);
            writer.println("OK - Attribute get '" + onameStr + "' - " + att + "= " + this.escape(value.toString()));
        }
        catch (Exception ex) {
            writer.println("Error - " + ex.toString());
        }
    }

    public void setAttribute(PrintWriter writer, String onameStr, String att, String val) {
        try {
            ObjectName oname = new ObjectName(onameStr);
            String type = this.registry.getType(oname, att);
            Object valueObj = this.registry.convertValue(type, val);
            this.mBeanServer.setAttribute(oname, new Attribute(att, valueObj));
            writer.println("OK - Attribute set");
        }
        catch (Exception ex) {
            writer.println("Error - " + ex.toString());
        }
    }

    public void listBeans(PrintWriter writer, String qry) {
        Set<ObjectName> names = null;
        try {
            names = this.mBeanServer.queryNames(new ObjectName(qry), null);
            writer.println("OK - Number of results: " + names.size());
            writer.println();
        }
        catch (Exception e) {
            writer.println("Error - " + e.toString());
            return;
        }
        for (ObjectName oname : names) {
            writer.println("Name: " + oname.toString());
            try {
                MBeanInfo minfo = this.mBeanServer.getMBeanInfo(oname);
                String code = minfo.getClassName();
                if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                    code = (String)this.mBeanServer.getAttribute(oname, "modelerType");
                }
                writer.println("modelerType: " + code);
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                Object value = null;
                for (int i = 0; i < attrs.length; ++i) {
                    String attName;
                    if (!attrs[i].isReadable() || !this.isSupported(attrs[i].getType()) || "modelerType".equals(attName = attrs[i].getName()) || attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) continue;
                    try {
                        value = this.mBeanServer.getAttribute(oname, attName);
                    }
                    catch (Throwable t) {
                        this.log("Error getting attribute " + oname + " " + attName + " " + t.toString());
                        continue;
                    }
                    if (value == null) continue;
                    try {
                        String valueString;
                        Class<?> c = value.getClass();
                        if (c.isArray()) {
                            int len = Array.getLength(value);
                            StringBuilder sb = new StringBuilder("Array[" + c.getComponentType().getName() + "] of length " + len);
                            if (len > 0) {
                                sb.append("\r\n");
                            }
                            for (int j = 0; j < len; ++j) {
                                sb.append("\t");
                                Object item = Array.get(value, j);
                                if (item == null) {
                                    sb.append("NULL VALUE");
                                } else {
                                    try {
                                        sb.append(this.escape(item.toString()));
                                    }
                                    catch (Throwable t) {
                                        ExceptionUtils.handleThrowable(t);
                                        sb.append("NON-STRINGABLE VALUE");
                                    }
                                }
                                if (j >= len - 1) continue;
                                sb.append("\r\n");
                            }
                            valueString = sb.toString();
                        } else {
                            valueString = this.escape(value.toString());
                        }
                        writer.println(attName + ": " + valueString);
                        continue;
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            writer.println();
        }
    }

    public String escape(String value) {
        int idx = value.indexOf("\n");
        if (idx < 0) {
            return value;
        }
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        while (idx >= 0) {
            this.appendHead(sb, value, prev, idx);
            sb.append("\\n\n ");
            prev = idx + 1;
            if (idx == value.length() - 1) break;
            idx = value.indexOf(10, idx + 1);
        }
        if (prev < value.length()) {
            this.appendHead(sb, value, prev, value.length());
        }
        return sb.toString();
    }

    private void appendHead(StringBuilder sb, String value, int start, int end) {
        if (end < 1) {
            return;
        }
        int pos = start;
        while (end - pos > 78) {
            sb.append(value.substring(pos, pos + 78));
            sb.append("\n ");
            pos += 78;
        }
        sb.append(value.substring(pos, end));
    }

    public boolean isSupported(String type) {
        return true;
    }
}

