/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpAprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpAprProtocol
extends AbstractAjpProtocol {
    private static final Log log = LogFactory.getLog(AjpAprProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpAprProtocol() {
        this.endpoint = new AprEndpoint();
        this.cHandler = new AjpConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        this.setUseSendfile(false);
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int pollTime) {
        ((AprEndpoint)this.endpoint).setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        ((AprEndpoint)this.endpoint).setPollerSize(pollerSize);
    }

    public int getPollerSize() {
        return ((AprEndpoint)this.endpoint).getPollerSize();
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-apr";
    }

    protected static class AjpConnectionHandler
    implements AprEndpoint.Handler {
        protected AjpAprProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<SocketWrapper<Long>, AjpAprProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<AjpAprProcessor> recycledProcessors = new ConcurrentLinkedQueue<AjpAprProcessor>(){
            private static final long serialVersionUID = 1L;
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(AjpAprProcessor processor) {
                boolean offer = AjpConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < AjpConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    AjpConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public AjpAprProcessor poll() {
                AjpAprProcessor result = (AjpAprProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                AjpAprProcessor next = this.poll();
                while (next != null) {
                    AjpConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        public AjpConnectionHandler(AjpAprProtocol proto) {
            this.proto = proto;
        }

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public AbstractEndpoint.Handler.SocketState event(SocketWrapper<Long> socket, SocketStatus status) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socket) {
            AjpAprProcessor processor = this.recycledProcessors.poll();
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if ((state = processor.process(socket)) == AbstractEndpoint.Handler.SocketState.LONG) {
                    state = processor.asyncPostProcess();
                }
                if (state == AbstractEndpoint.Handler.SocketState.LONG || state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    this.connections.put(socket, processor);
                } else {
                    if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                        this.connections.put(socket, processor);
                    }
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                log.debug(AbstractAjpProtocol.sm.getString("ajpprotocol.proto.socketexception.debug"), e);
            }
            catch (IOException e) {
                log.debug(AbstractAjpProtocol.sm.getString("ajpprotocol.proto.ioexception.debug"), e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error(AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
            }
            this.recycledProcessors.offer(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketWrapper<Long> socket, SocketStatus status) {
            AjpAprProcessor result = this.connections.get(socket);
            AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                try {
                    state = result.asyncDispatch(socket, status);
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    log.error(AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
                }
                finally {
                    if (state == AbstractEndpoint.Handler.SocketState.LONG && result.isAsync()) {
                        state = result.asyncPostProcess();
                    }
                    if (state != AbstractEndpoint.Handler.SocketState.LONG && state != AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                        this.connections.remove(socket);
                        this.recycledProcessors.offer(result);
                        if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                            ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket());
                        }
                    }
                }
            }
            return state;
        }

        protected AjpAprProcessor createProcessor() {
            AjpAprProcessor processor = new AjpAprProcessor(this.proto.packetSize, (AprEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AjpAprProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=AjpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug("Register " + rpName);
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn("Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(AjpAprProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug("Unregister " + rpName);
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn("Error unregistering request", e);
                    }
                }
            }
        }
    }
}

