/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.CounterLatch;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public abstract class AbstractEndpoint {
    protected static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    public static final String SSL_ATTR_ALGORITHM = "algorithm";
    public static final String SSL_ATTR_CLIENT_AUTH = "clientAuth";
    public static final String SSL_ATTR_KEYSTORE_FILE = "keystoreFile";
    public static final String SSL_ATTR_KEYSTORE_PASS = "keystorePass";
    public static final String SSL_ATTR_KEYSTORE_TYPE = "keystoreType";
    public static final String SSL_ATTR_KEYSTORE_PROVIDER = "keystoreProvider";
    public static final String SSL_ATTR_SSL_PROTOCOL = "sslProtocol";
    public static final String SSL_ATTR_CIPHERS = "ciphers";
    public static final String SSL_ATTR_KEY_ALIAS = "keyAlias";
    public static final String SSL_ATTR_KEY_PASS = "keyPass";
    public static final String SSL_ATTR_TRUSTSTORE_FILE = "truststoreFile";
    public static final String SSL_ATTR_TRUSTSTORE_PASS = "truststorePass";
    public static final String SSL_ATTR_TRUSTSTORE_TYPE = "truststoreType";
    public static final String SSL_ATTR_TRUSTSTORE_PROVIDER = "truststoreProvider";
    public static final String SSL_ATTR_TRUSTSTORE_ALGORITHM = "truststoreAlgorithm";
    public static final String SSL_ATTR_CRL_FILE = "crlFile";
    public static final String SSL_ATTR_TRUST_MAX_CERT_LENGTH = "trustMaxCertLength";
    public static final String SSL_ATTR_SESSION_CACHE_SIZE = "sessionCacheSize";
    public static final String SSL_ATTR_SESSION_TIMEOUT = "sessionTimeout";
    public static final String SSL_ATTR_ALLOW_UNSAFE_RENEG = "allowUnsafeLegacyRenegotiation";
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected volatile boolean internalExecutor = false;
    private volatile CounterLatch connectionCounterLatch = null;
    protected SocketProperties socketProperties = new SocketProperties();
    private int maxConnections = 10000;
    private Executor executor = null;
    private int port;
    private InetAddress address;
    private int backlog = 100;
    private boolean bindOnInit = true;
    private BindState bindState = BindState.UNBOUND;
    private int keepAliveTimeout = -1;
    private boolean SSLEnabled = false;
    private int minSpareThreads = 10;
    private int maxThreads = 200;
    private int maxKeepAliveRequests = 100;
    private String name = "TP";
    private boolean daemon = true;
    protected int threadPriority = 5;
    protected HashMap<String, Object> attributes = new HashMap();
    private String algorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String clientAuth = "false";
    private String keystoreFile = System.getProperty("user.home") + "/.keystore";
    private String keystorePass = null;
    private String keystoreType = "JKS";
    private String keystoreProvider = null;
    private String sslProtocol = "TLS";
    private String ciphers = null;
    private String[] ciphersarr = new String[0];
    private String keyAlias = null;
    private String keyPass = "changeit";
    private String truststoreFile = System.getProperty("javax.net.ssl.trustStore");
    private String truststorePass = System.getProperty("javax.net.ssl.trustStorePassword");
    private String truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
    private String truststoreProvider = null;
    private String truststoreAlgorithm = null;
    private String crlFile = null;
    private String trustMaxCertLength = null;
    private String sessionCacheSize = null;
    private String sessionTimeout = "86400";
    private String allowUnsafeLegacyRenegotiation = null;
    private String[] sslEnabledProtocolsarr = new String[0];

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public void setMaxConnections(int maxCon) {
        this.maxConnections = maxCon;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.internalExecutor = executor == null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getBindOnInit() {
        return this.bindOnInit;
    }

    public void setBindOnInit(boolean b) {
        this.bindOnInit = b;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.socketProperties.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setSoLinger(int soLinger) {
        this.socketProperties.setSoLingerTime(soLinger);
        this.socketProperties.setSoLingerOn(soLinger >= 0);
    }

    public int getSoTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.socketProperties.setSoTimeout(soTimeout);
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public int getMinSpareThreads() {
        return Math.min(this.minSpareThreads, this.getMaxThreads());
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
        if (this.running && this.executor != null) {
            if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                ((java.util.concurrent.ThreadPoolExecutor)this.executor).setCorePoolSize(minSpareThreads);
            } else if (this.executor instanceof ResizableExecutor) {
                ((ResizableExecutor)this.executor).resizePool(minSpareThreads, this.maxThreads);
            }
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (this.running && this.executor != null) {
            if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                ((java.util.concurrent.ThreadPoolExecutor)this.executor).setMaximumPoolSize(maxThreads);
            } else if (this.executor instanceof ResizableExecutor) {
                ((ResizableExecutor)this.executor).resizePool(this.minSpareThreads, maxThreads);
            }
        }
    }

    public int getMaxThreads() {
        if (this.running && this.executor != null) {
            if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                return ((java.util.concurrent.ThreadPoolExecutor)this.executor).getMaximumPoolSize();
            }
            if (this.executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)this.executor).getMaxThreads();
            }
            return -1;
        }
        return this.maxThreads;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    protected abstract boolean getDeferAccept();

    public void setAttribute(String name, Object value) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace(sm.getString("abstractProtocolHandler.setAttribute", name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        Object value = this.attributes.get(key);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace(sm.getString("abstractProtocolHandler.getAttribute", key, value));
        }
        return value;
    }

    public boolean setProperty(String name, String value) {
        this.setAttribute(name, value);
        String socketName = "socket.";
        try {
            if (name.startsWith("socket.")) {
                return IntrospectionUtils.setProperty(this.socketProperties, name.substring("socket.".length()), value);
            }
            return IntrospectionUtils.setProperty(this, name, value, false);
        }
        catch (Exception x) {
            this.getLog().error("Unable to set attribute \"" + name + "\" to \"" + value + "\"", x);
            return false;
        }
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public int getCurrentThreadCount() {
        if (this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)this.executor).getPoolSize();
            }
            if (this.executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)this.executor).getPoolSize();
            }
            return -1;
        }
        return -2;
    }

    public int getCurrentThreadsBusy() {
        if (this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)this.executor).getActiveCount();
            }
            if (this.executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)this.executor).getActiveCount();
            }
            return -1;
        }
        return -2;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void createExecutor() {
        this.internalExecutor = true;
        TaskQueue taskqueue = new TaskQueue();
        TaskThreadFactory tf = new TaskThreadFactory(this.getName() + "-exec-", this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, tf);
        taskqueue.setParent((ThreadPoolExecutor)this.executor);
    }

    public void shutdownExecutor() {
        if (this.executor != null && this.internalExecutor) {
            if (this.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.executor;
                tpe.shutdownNow();
                TaskQueue queue = (TaskQueue)tpe.getQueue();
                queue.setParent(null);
            }
            this.executor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        Socket s = null;
        InetSocketAddress saddr = null;
        try {
            saddr = this.address == null ? new InetSocketAddress("localhost", this.getPort()) : new InetSocketAddress(this.address, this.getPort());
            s = new Socket();
            int stmo = 2000;
            int utmo = 2000;
            if (this.getSocketProperties().getSoTimeout() > stmo) {
                stmo = this.getSocketProperties().getSoTimeout();
            }
            if (this.getSocketProperties().getUnlockTimeout() > utmo) {
                utmo = this.getSocketProperties().getUnlockTimeout();
            }
            s.setSoTimeout(stmo);
            s.setSoLinger(this.getSocketProperties().getSoLingerOn(), this.getSocketProperties().getSoLingerTime());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("About to unlock socket for:" + saddr);
            }
            s.connect(saddr, utmo);
            if (this.getDeferAccept()) {
                OutputStreamWriter sw = new OutputStreamWriter(s.getOutputStream(), "ISO-8859-1");
                sw.write("OPTIONS * HTTP/1.0\r\nUser-Agent: Tomcat wakeup connection\r\n\r\n");
                sw.flush();
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Socket unlock completed for:" + saddr);
            }
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(sm.getString("endpoint.debug.unlock", "" + this.getPort()), e);
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public abstract void bind() throws Exception;

    public abstract void unbind() throws Exception;

    public abstract void startInternal() throws Exception;

    public abstract void stopInternal() throws Exception;

    public final void init() throws Exception {
        if (this.bindOnInit) {
            this.bind();
            this.bindState = BindState.BOUND_ON_INIT;
        }
    }

    public final void start() throws Exception {
        if (this.bindState == BindState.UNBOUND) {
            this.bind();
            this.bindState = BindState.BOUND_ON_START;
        }
        this.startInternal();
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public final void stop() throws Exception {
        this.stopInternal();
        if (this.bindState == BindState.BOUND_ON_START) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public final void destroy() throws Exception {
        if (this.bindState == BindState.BOUND_ON_INIT) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public String adjustRelativePath(String path, String relativeTo) {
        String newPath = path;
        File f = new File(newPath);
        if (!f.isAbsolute()) {
            newPath = relativeTo + File.separator + newPath;
            f = new File(newPath);
        }
        if (!f.exists()) {
            this.getLog().warn("configured file:[" + newPath + "] does not exist.");
        }
        return newPath;
    }

    protected abstract Log getLog();

    public abstract boolean getUseSendfile();

    protected CounterLatch initializeConnectionLatch() {
        if (this.connectionCounterLatch == null) {
            this.connectionCounterLatch = new CounterLatch(0L, this.getMaxConnections());
        }
        return this.connectionCounterLatch;
    }

    protected void releaseConnectionLatch() {
        CounterLatch latch = this.connectionCounterLatch;
        if (latch != null) {
            latch.releaseAll();
        }
        this.connectionCounterLatch = null;
    }

    protected void awaitConnection() throws InterruptedException {
        CounterLatch latch = this.connectionCounterLatch;
        if (latch != null) {
            latch.await();
        }
    }

    protected long countUpConnection() {
        CounterLatch latch = this.connectionCounterLatch;
        if (latch != null) {
            return latch.countUp();
        }
        return -1L;
    }

    protected long countDownConnection() {
        CounterLatch latch = this.connectionCounterLatch;
        if (latch != null) {
            long result = latch.countDown();
            if (result < 0L) {
                this.getLog().warn("Incorrect connection count, multiple socket.close called on the same socket.");
            }
            return result;
        }
        return -1L;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String s) {
        this.algorithm = s;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String s) {
        this.clientAuth = s;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String s) {
        String file;
        this.keystoreFile = file = this.adjustRelativePath(s, System.getProperty("catalina.base"));
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String s) {
        this.keystorePass = s;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String s) {
        this.keystoreType = s;
    }

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public void setKeystoreProvider(String s) {
        this.keystoreProvider = s;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String s) {
        this.sslProtocol = s;
    }

    public String[] getCiphersArray() {
        return this.ciphersarr;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String s) {
        this.ciphers = s;
        if (s == null) {
            this.ciphersarr = new String[0];
        } else {
            StringTokenizer t = new StringTokenizer(s, ",");
            this.ciphersarr = new String[t.countTokens()];
            for (int i = 0; i < this.ciphersarr.length; ++i) {
                this.ciphersarr[i] = t.nextToken();
            }
        }
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String s) {
        this.keyAlias = s;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String s) {
        this.keyPass = s;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststoreFile(String s) {
        String file;
        this.truststoreFile = file = this.adjustRelativePath(s, System.getProperty("catalina.base"));
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public String getTruststoreProvider() {
        return this.truststoreProvider;
    }

    public void setTruststoreProvider(String truststoreProvider) {
        this.truststoreProvider = truststoreProvider;
    }

    public String getTruststoreAlgorithm() {
        return this.truststoreAlgorithm;
    }

    public void setTruststoreAlgorithm(String truststoreAlgorithm) {
        this.truststoreAlgorithm = truststoreAlgorithm;
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
    }

    public String getTrustMaxCertLength() {
        return this.trustMaxCertLength;
    }

    public void setTrustMaxCertLength(String trustMaxCertLength) {
        this.trustMaxCertLength = trustMaxCertLength;
    }

    public String getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setSessionCacheSize(String s) {
        this.sessionCacheSize = s;
    }

    public String getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(String s) {
        this.sessionTimeout = s;
    }

    public String getAllowUnsafeLegacyRenegotiation() {
        return this.allowUnsafeLegacyRenegotiation;
    }

    public void setAllowUnsafeLegacyRenegotiation(String s) {
        this.allowUnsafeLegacyRenegotiation = s;
    }

    public String[] getSslEnabledProtocolsArray() {
        return this.sslEnabledProtocolsarr;
    }

    public void setSslEnabledProtocols(String s) {
        if (s == null) {
            this.sslEnabledProtocolsarr = new String[0];
        } else {
            ArrayList<String> sslEnabledProtocols = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(s, ",");
            while (t.hasMoreTokens()) {
                String p = t.nextToken().trim();
                if (p.length() <= 0) continue;
                sslEnabledProtocols.add(p);
            }
            this.sslEnabledProtocolsarr = sslEnabledProtocols.toArray(new String[sslEnabledProtocols.size()]);
        }
    }

    protected static enum BindState {
        UNBOUND,
        BOUND_ON_INIT,
        BOUND_ON_START;

    }

    public static interface Handler {
        public Object getGlobal();

        public void recycle();

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG,
            ASYNC_END;

        }
    }
}

