/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote;

import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DistributedSessionIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Project;

public abstract class DistributedSession
extends AbstractSession {
    protected transient RemoteConnection remoteConnection;

    protected DistributedSession(int nothing) {
    }

    public DistributedSession(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        this.project = new Project();
    }

    public abstract UnitOfWorkImpl acquireUnitOfWork();

    public void beginTransaction() {
        this.getTransactionMutex().acquire();
        this.getRemoteConnection().beginTransaction();
    }

    public void commitTransaction() {
        this.getRemoteConnection().commitTransaction();
        this.getTransactionMutex().release();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy policy) {
        return this.getRemoteConnection().cursorSelectObjects(policy, this);
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy policy) {
        return this.getRemoteConnection().cursorSelectObjects(policy, this);
    }

    public Object executeQuery(String queryName) throws DatabaseException {
        return this.executeQuery(queryName, new Vector(1));
    }

    public Object executeQuery(String queryName, Class domainClass) throws DatabaseException {
        return this.executeQuery(queryName, domainClass, new Vector(1));
    }

    public Object executeQuery(String queryName, Class domainClass, Vector argumentValues) throws DatabaseException {
        Transporter transporter = this.getRemoteConnection().remoteExecuteNamedQuery(queryName, domainClass, argumentValues);
        transporter.getQuery().setSession(this);
        return transporter.getQuery().extractRemoteResult(transporter);
    }

    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        if (this.containsQuery(queryName)) {
            return super.executeQuery(queryName, argumentValues);
        }
        return this.executeQuery(queryName, null, argumentValues);
    }

    public abstract Object executeQuery(DatabaseQuery var1);

    public Object executeQuery(DatabaseQuery query, AbstractRecord row) {
        query.setTranslationRow(row);
        return this.executeQuery(query);
    }

    public Vector getDefaultReadOnlyClasses() {
        Vector readOnlyClasses = this.getRemoteConnection().getDefaultReadOnlyClasses();
        return readOnlyClasses;
    }

    public ClassDescriptor getDescriptor(Class domainClass) {
        ClassDescriptor descriptor = this.getDescriptors().get(domainClass);
        if (descriptor == null) {
            descriptor = this.getRemoteConnection().getDescriptor(domainClass);
            if (descriptor == null) {
                return null;
            }
            this.getDescriptors().put(domainClass, descriptor);
            descriptor.remoteInitialization(this);
        }
        return descriptor;
    }

    public ClassDescriptor getDescriptorCorrespondingTo(ClassDescriptor descriptor) {
        return this.getDescriptors().get(descriptor.getJavaClass());
    }

    public abstract Object getObjectCorrespondingTo(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4);

    public abstract Object getObjectsCorrespondingToAll(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4, ContainerPolicy var5);

    public RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public boolean hasCorrespondingDescriptor(ClassDescriptor descriptor) {
        return this.getDescriptors().containsKey(descriptor.getJavaClass());
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new DistributedSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public abstract Object instantiateRemoteValueHolderOnServer(RemoteValueHolder var1);

    public boolean isConnected() {
        return this.getRemoteConnection() != null;
    }

    public boolean isDistributedSession() {
        return true;
    }

    public boolean isRemoteSession() {
        return false;
    }

    public void privilegedAddDescriptor(ClassDescriptor descriptor) {
        this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
    }

    public void rollbackTransaction() {
        this.getRemoteConnection().rollbackTransaction();
        this.getTransactionMutex().release();
    }

    protected void setRemoteConnection(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public void release() {
        this.remoteConnection.release();
    }
}

