/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimerTask;
import org.objectweb.joram.mom.dest.AcquisitionDaemon;
import org.objectweb.joram.mom.dest.AcquisitionHandler;
import org.objectweb.joram.mom.dest.AcquisitionNot;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.dest.ReliableTransmitter;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AcquisitionModule
implements ReliableTransmitter {
    public static Logger logger = Debug.getLogger((String)AcquisitionModule.class.getName());
    public static final String PERIOD = "acquisition.period";
    public static final String CLASS_NAME = "acquisition.className";
    public static final String PERSISTENT_PROPERTY = "persistent";
    public static final String EXPIRATION_PROPERTY = "expiration";
    public static final String PRIORITY_PROPERTY = "priority";
    protected Object acquisitionHandler;
    private int priority = 4;
    private boolean isPersistent = true;
    private long expiration = 0L;
    private final DestinationImpl destination;
    private final byte destType;
    private long period = 0L;
    private AcquisitionTask acquisitionTask;
    private boolean isDaemon = false;

    public static void checkAcquisitionClass(String className) throws Exception {
        if (className == null) {
            throw new Exception("AcquisitionHandler class not defined: use acquisition.className property to chose acquisition class.");
        }
        boolean isDaemon = false;
        boolean isHandler = false;
        for (Class<?> clazz = Class.forName(className); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].equals(AcquisitionDaemon.class)) {
                    isDaemon = true;
                    continue;
                }
                if (!interfaces[i].equals(AcquisitionHandler.class)) continue;
                isHandler = true;
            }
        }
        if (isDaemon && isHandler) {
            throw new Exception("Acquisition class " + className + " can't implement both AcquisitionHandler and AcquisitionDaemon interfaces.");
        }
        if (!isDaemon && !isHandler) {
            throw new Exception("Acquisition class " + className + " must implement either AcquisitionHandler or AcquisitionDaemon interface.");
        }
    }

    private static Properties transform(fr.dyade.aaa.common.stream.Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties prop = new Properties();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            prop.put(key, properties.get(key));
        }
        return prop;
    }

    public AcquisitionModule(DestinationImpl destination, String className, Properties properties, byte destType) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.<init> prop = " + properties));
        }
        this.destination = destination;
        this.destType = destType;
        try {
            Class<?> clazz = Class.forName(className);
            this.acquisitionHandler = clazz.newInstance();
            if (this.acquisitionHandler instanceof AcquisitionDaemon) {
                this.isDaemon = true;
                this.setProperties(properties);
            } else {
                this.acquisitionTask = new AcquisitionTask();
                this.setProperties(properties);
            }
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't create acquisition handler.", (Throwable)exc);
        }
    }

    public boolean isMessagePersistent() {
        return this.isPersistent;
    }

    public void setMessagePersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    private void setProperties(Properties properties) {
        Properties props = (Properties)properties.clone();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.setProperties = " + props + " daemon = " + this.isDaemon));
        }
        this.priority = 4;
        this.isPersistent = true;
        this.expiration = 0L;
        this.period = 0L;
        if (this.acquisitionTask != null) {
            this.acquisitionTask.cancel();
        }
        if (props.containsKey(PERIOD)) {
            try {
                this.period = ConversionHelper.toLong((Object)props.get(PERIOD));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined period property.");
            }
            props.remove(PERIOD);
        }
        if (!this.isDaemon && this.period > 0L) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("schedule acquisition every " + this.period + "ms."));
            }
            this.acquisitionTask = new AcquisitionTask();
            AgentServer.getTimer().schedule((TimerTask)this.acquisitionTask, this.period, this.period);
        }
        if (props.containsKey(PERSISTENT_PROPERTY)) {
            try {
                this.isPersistent = ConversionHelper.toBoolean((Object)props.get(PERSISTENT_PROPERTY));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined message persistence property.");
            }
            props.remove(PERSISTENT_PROPERTY);
        }
        if (props.containsKey(PRIORITY_PROPERTY)) {
            try {
                this.priority = ConversionHelper.toInt((Object)props.get(PRIORITY_PROPERTY));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined message priority property.");
            }
            props.remove(PRIORITY_PROPERTY);
        }
        if (props.containsKey(EXPIRATION_PROPERTY)) {
            try {
                this.expiration = ConversionHelper.toLong((Object)props.get(EXPIRATION_PROPERTY));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: can't parse defined message expiration property.");
            }
            props.remove(EXPIRATION_PROPERTY);
        }
        if (props.containsKey(CLASS_NAME) && !props.get(CLASS_NAME).equals(this.acquisitionHandler.getClass().getName())) {
            logger.log(BasicLevel.ERROR, (Object)"AcquisitionModule: Changing dynamically the acquisition class is not allowed.");
            props.remove(CLASS_NAME);
        }
        if (this.isDaemon) {
            ((AcquisitionDaemon)this.acquisitionHandler).start(props, this);
        } else {
            ((AcquisitionHandler)this.acquisitionHandler).setProperties(props);
        }
    }

    public Properties processMessages(ClientMessages cm) {
        Iterator msgs = cm.getMessages().iterator();
        Properties lastProperties = null;
        while (msgs.hasNext()) {
            Message msg = (Message)msgs.next();
            if (msg.properties != null) {
                lastProperties = AcquisitionModule.transform(msg.properties);
                if (this.isDaemon) {
                    ((AcquisitionDaemon)this.acquisitionHandler).stop();
                    this.setProperties(lastProperties);
                } else {
                    this.setProperties(lastProperties);
                }
            }
            if (this.isDaemon || this.period > 0L) continue;
            this.acquisitionTask = new AcquisitionTask();
            AgentServer.getTimer().schedule((TimerTask)this.acquisitionTask, 0L);
        }
        return lastProperties;
    }

    public ClientMessages acquisitionNot(AcquisitionNot not, long msgCount) {
        ClientMessages acquiredCM;
        List messages;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionModule.acquisitionNot(" + (Object)((Object)not) + ")"));
        }
        if ((messages = (acquiredCM = not.getAcquiredMessages()).getMessages()).size() == 0) {
            return null;
        }
        this.setMessagesInfo(messages, msgCount);
        return acquiredCM;
    }

    private void setMessagesInfo(List messages, long msgCount) {
        long currentTime = System.currentTimeMillis();
        for (Message message : messages) {
            message.id = "ID:" + this.destination.getDestinationId() + '_' + msgCount;
            message.timestamp = currentTime;
            message.persistent = this.isPersistent;
            message.setDestination(this.destination.getId().toString(), this.destType);
            message.priority = this.priority;
            message.expiration = this.expiration > 0L ? currentTime + this.expiration : 0L;
            ++msgCount;
        }
    }

    public void close() {
        if (this.isDaemon) {
            ((AcquisitionDaemon)this.acquisitionHandler).stop();
        } else {
            if (this.acquisitionTask != null) {
                this.acquisitionTask.cancel();
            }
            ((AcquisitionHandler)this.acquisitionHandler).close();
        }
    }

    public void transmit(Message message, String messageId) {
        if (message != null) {
            Channel.sendTo((AgentId)this.destination.getId(), (Notification)new AcquisitionNot(new ClientMessages(-1, -1, message), this.isPersistent, messageId));
        }
    }

    public void transmit(List messages, String messagesId) {
        if (messages != null && messages.size() > 0) {
            Channel.sendTo((AgentId)this.destination.getId(), (Notification)new AcquisitionNot(new ClientMessages(-1, -1, messages), this.isPersistent, messagesId));
        }
    }

    public long getPeriod() {
        return this.period;
    }

    class AcquisitionTask
    extends TimerTask {
        AcquisitionTask() {
        }

        public void run() {
            try {
                ((AcquisitionHandler)AcquisitionModule.this.acquisitionHandler).retrieve(AcquisitionModule.this);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)"Error while doing acquisition.", (Throwable)exc);
            }
        }
    }
}

