/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.Debug;
import java.util.Properties;
import org.objectweb.joram.mom.dest.AcquisitionModule;
import org.objectweb.joram.mom.dest.AcquisitionNot;
import org.objectweb.joram.mom.dest.AcquisitionQueueImplMBean;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AcquisitionQueueImpl
extends QueueImpl
implements AcquisitionQueueImplMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)AcquisitionQueueImpl.class.getName());
    private transient AcquisitionModule acquisitionModule;
    private Properties properties;
    private String lastMessageId;
    private long msgCount = 0L;
    private String acquisitionClassName;

    public String getAcquisitionClassName() {
        return this.acquisitionClassName;
    }

    public AcquisitionQueueImpl(AgentId adminId, Properties properties) throws RequestException {
        super(adminId, properties);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionQueueImpl.<init> prop = " + properties));
        }
        if (properties == null) {
            throw new RequestException("No property found: At least acquisition.className property must be defined on queue creation.");
        }
        this.properties = properties;
        this.acquisitionClassName = properties.getProperty("acquisition.className");
        properties.remove("acquisition.className");
        try {
            AcquisitionModule.checkAcquisitionClass(this.acquisitionClassName);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"AcquisitionQueueImpl: error with acquisition class.", (Throwable)exc);
            throw new RequestException(exc.getMessage());
        }
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
        if (this.acquisitionModule == null) {
            this.acquisitionModule = new AcquisitionModule(this, this.acquisitionClassName, this.properties, 2);
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionQueueImpl. preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        this.properties = this.acquisitionModule.processMessages(cm);
        return null;
    }

    public void acquisitionNot(AcquisitionNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("acquisitionNot(" + (Object)((Object)not) + ")"));
        }
        if (this.lastMessageId != null && this.lastMessageId.equals(not.getId())) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message already received, drop the message " + (Object)((Object)not)));
            }
            return;
        }
        this.lastMessageId = not.getId();
        ClientMessages clientMessages = this.acquisitionModule.acquisitionNot(not, this.msgCount);
        if (clientMessages != null) {
            this.msgCount += (long)clientMessages.getMessageCount();
            this.addClientMessages(clientMessages);
        }
    }

    public String toString() {
        return "AcquisitionQueueImpl:" + this.getId().toString();
    }

    public long getExpiration() {
        return this.acquisitionModule.getExpiration();
    }

    public int getPriority() {
        return this.acquisitionModule.getPriority();
    }

    public boolean isMessagePersistent() {
        return this.acquisitionModule.isMessagePersistent();
    }

    public void setExpiration(long expiration) {
        this.acquisitionModule.setExpiration(expiration);
    }

    public void setMessagePersistent(boolean isPersistent) {
        this.acquisitionModule.setMessagePersistent(isPersistent);
    }

    public void setPriority(int priority) {
        this.acquisitionModule.setPriority(priority);
    }

    public void close() {
        if (this.acquisitionModule != null) {
            this.acquisitionModule.close();
        }
    }

    public long getAcquisitionPeriod() {
        return this.acquisitionModule.getPeriod();
    }
}

